"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Aps extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aps](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmanagedserviceforprometheus.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aps';
        this.accessLevelList = {
            Write: [
                'CreateAlertManagerAlerts',
                'CreateAlertManagerDefinition',
                'CreateLoggingConfiguration',
                'CreateRuleGroupsNamespace',
                'CreateWorkspace',
                'DeleteAlertManagerDefinition',
                'DeleteAlertManagerSilence',
                'DeleteLoggingConfiguration',
                'DeleteRuleGroupsNamespace',
                'DeleteWorkspace',
                'PutAlertManagerDefinition',
                'PutAlertManagerSilences',
                'PutRuleGroupsNamespace',
                'RemoteWrite',
                'UpdateLoggingConfiguration',
                'UpdateWorkspaceAlias'
            ],
            Read: [
                'DescribeAlertManagerDefinition',
                'DescribeLoggingConfiguration',
                'DescribeRuleGroupsNamespace',
                'DescribeWorkspace',
                'GetAlertManagerSilence',
                'GetAlertManagerStatus',
                'GetLabels',
                'GetMetricMetadata',
                'GetSeries',
                'ListAlertManagerAlertGroups',
                'ListAlertManagerAlerts',
                'ListAlertManagerReceivers',
                'ListAlertManagerSilences',
                'ListAlerts',
                'ListRules',
                'ListTagsForResource',
                'QueryMetrics'
            ],
            List: [
                'ListRuleGroupsNamespaces',
                'ListWorkspaces'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create alerts
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateAlertManagerAlerts
     */
    toCreateAlertManagerAlerts() {
        return this.to('CreateAlertManagerAlerts');
    }
    /**
     * Grants permission to create an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateAlertManagerDefinition
     */
    toCreateAlertManagerDefinition() {
        return this.to('CreateAlertManagerDefinition');
    }
    /**
     * Grants permission to create a logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateLoggingConfiguration
     */
    toCreateLoggingConfiguration() {
        return this.to('CreateLoggingConfiguration');
    }
    /**
     * Grants permission to create a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateRuleGroupsNamespace
     */
    toCreateRuleGroupsNamespace() {
        return this.to('CreateRuleGroupsNamespace');
    }
    /**
     * Grants permission to create a workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-CreateWorkspace
     */
    toCreateWorkspace() {
        return this.to('CreateWorkspace');
    }
    /**
     * Grants permission to delete an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteAlertManagerDefinition
     */
    toDeleteAlertManagerDefinition() {
        return this.to('DeleteAlertManagerDefinition');
    }
    /**
     * Grants permission to delete a silence
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteAlertManagerSilence
     */
    toDeleteAlertManagerSilence() {
        return this.to('DeleteAlertManagerSilence');
    }
    /**
     * Grants permission to delete a logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteLoggingConfiguration
     */
    toDeleteLoggingConfiguration() {
        return this.to('DeleteLoggingConfiguration');
    }
    /**
     * Grants permission to delete a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteRuleGroupsNamespace
     */
    toDeleteRuleGroupsNamespace() {
        return this.to('DeleteRuleGroupsNamespace');
    }
    /**
     * Grants permission to delete a workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DeleteWorkspace
     */
    toDeleteWorkspace() {
        return this.to('DeleteWorkspace');
    }
    /**
     * Grants permission to describe an alert manager definition
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeAlertManagerDefinition
     */
    toDescribeAlertManagerDefinition() {
        return this.to('DescribeAlertManagerDefinition');
    }
    /**
     * Grants permission to describe a logging configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeLoggingConfiguration
     */
    toDescribeLoggingConfiguration() {
        return this.to('DescribeLoggingConfiguration');
    }
    /**
     * Grants permission to describe a rule groups namespace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeRuleGroupsNamespace
     */
    toDescribeRuleGroupsNamespace() {
        return this.to('DescribeRuleGroupsNamespace');
    }
    /**
     * Grants permission to describe a workspace
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-DescribeWorkspace
     */
    toDescribeWorkspace() {
        return this.to('DescribeWorkspace');
    }
    /**
     * Grants permission to get a silence
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetAlertManagerSilence
     */
    toGetAlertManagerSilence() {
        return this.to('GetAlertManagerSilence');
    }
    /**
     * Grants permission to get current status of an alertmanager
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetAlertManagerStatus
     */
    toGetAlertManagerStatus() {
        return this.to('GetAlertManagerStatus');
    }
    /**
     * Grants permission to retrieve AMP workspace labels
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetLabels
     */
    toGetLabels() {
        return this.to('GetLabels');
    }
    /**
     * Grants permission to retrieve the metadata for AMP workspace metrics
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetMetricMetadata
     */
    toGetMetricMetadata() {
        return this.to('GetMetricMetadata');
    }
    /**
     * Grants permission to retrieve AMP workspace time series data
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-GetSeries
     */
    toGetSeries() {
        return this.to('GetSeries');
    }
    /**
     * Grants permission to list groups
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerAlertGroups
     */
    toListAlertManagerAlertGroups() {
        return this.to('ListAlertManagerAlertGroups');
    }
    /**
     * Grants permission to list alerts
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerAlerts
     */
    toListAlertManagerAlerts() {
        return this.to('ListAlertManagerAlerts');
    }
    /**
     * Grants permission to list receivers
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerReceivers
     */
    toListAlertManagerReceivers() {
        return this.to('ListAlertManagerReceivers');
    }
    /**
     * Grants permission to list silences
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlertManagerSilences
     */
    toListAlertManagerSilences() {
        return this.to('ListAlertManagerSilences');
    }
    /**
     * Grants permission to list active alerts
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListAlerts
     */
    toListAlerts() {
        return this.to('ListAlerts');
    }
    /**
     * Grants permission to list rule groups namespaces
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListRuleGroupsNamespaces
     */
    toListRuleGroupsNamespaces() {
        return this.to('ListRuleGroupsNamespaces');
    }
    /**
     * Grants permission to list alerting and recording rules
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListRules
     */
    toListRules() {
        return this.to('ListRules');
    }
    /**
     * Grants permission to list tags on an AMP resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListTagsForResource
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list workspaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-ListWorkspaces
     */
    toListWorkspaces() {
        return this.to('ListWorkspaces');
    }
    /**
     * Grants permission to update an alert manager definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutAlertManagerDefinition
     */
    toPutAlertManagerDefinition() {
        return this.to('PutAlertManagerDefinition');
    }
    /**
     * Grants permission to create or update a silence
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutAlertManagerSilences
     */
    toPutAlertManagerSilences() {
        return this.to('PutAlertManagerSilences');
    }
    /**
     * Grants permission to update a rule groups namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-PutRuleGroupsNamespace
     */
    toPutRuleGroupsNamespace() {
        return this.to('PutRuleGroupsNamespace');
    }
    /**
     * Grants permission to run a query on AMP workspace metrics
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-QueryMetrics
     */
    toQueryMetrics() {
        return this.to('QueryMetrics');
    }
    /**
     * Grants permission to perform a remote write operation to initiate the streaming of metrics to AMP workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-RemoteWrite
     */
    toRemoteWrite() {
        return this.to('RemoteWrite');
    }
    /**
     * Grants permission to tag an AMP resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-TagResource
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag an AMP resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-UntagResource
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a logging configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-UpdateLoggingConfiguration
     */
    toUpdateLoggingConfiguration() {
        return this.to('UpdateLoggingConfiguration');
    }
    /**
     * Grants permission to modify the alias of existing AMP workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/AMP-APIReference.html#AMP-APIReference-UpdateWorkspaceAlias
     */
    toUpdateWorkspaceAlias() {
        return this.to('UpdateWorkspaceAlias');
    }
    /**
     * Adds a resource of type workspace to the statement
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onWorkspace(workspaceId, account, region, partition) {
        return this.on(`arn:${partition || Aps.defaultPartition}:aps:${region || '*'}:${account || '*'}:workspace/${workspaceId}`);
    }
    /**
     * Adds a resource of type rulegroupsnamespace to the statement
     *
     * https://docs.aws.amazon.com/prometheus/latest/userguide/security-iam.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param namespace - Identifier for the namespace.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onRulegroupsnamespace(workspaceId, namespace, account, region, partition) {
        return this.on(`arn:${partition || Aps.defaultPartition}:aps:${region || '*'}:${account || '*'}:rulegroupsnamespace/${workspaceId}/${namespace}`);
    }
}
exports.Aps = Aps;
_a = JSII_RTTI_SYMBOL_1;
Aps[_a] = { fqn: "iam-floyd.Aps", version: "0.442.0" };
//# sourceMappingURL=data:application/json;base64,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