"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SagemakerGroundtruthSynthetic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [sagemaker-groundtruth-synthetic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakergroundtruthsynthetic.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SagemakerGroundtruthSynthetic extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [sagemaker-groundtruth-synthetic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakergroundtruthsynthetic.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'sagemaker-groundtruth-synthetic';
        this.accessLevelList = {
            Write: [
                'CreateProject',
                'DeleteProject',
                'StartBatchDataTransfer',
                'StartProjectDataTransfer',
                'UpdateBatch'
            ],
            Read: [
                'GetBatch',
                'GetProject'
            ],
            List: [
                'ListBatchDataTransfers',
                'ListBatchSummaries',
                'ListProjectDataTransfers',
                'ListProjectSummaries'
            ]
        };
    }
    /**
     * Grants permission to create a project
     *
     * Access Level: Write
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     */
    toDeleteProject() {
        return this.to('DeleteProject');
    }
    /**
     * Grants permission to get a batch
     *
     * Access Level: Read
     */
    toGetBatch() {
        return this.to('GetBatch');
    }
    /**
     * Grants permission to get a project
     *
     * Access Level: Read
     */
    toGetProject() {
        return this.to('GetProject');
    }
    /**
     * Grants permission to list batch data transfers
     *
     * Access Level: List
     */
    toListBatchDataTransfers() {
        return this.to('ListBatchDataTransfers');
    }
    /**
     * Grants permission to list batch summaries
     *
     * Access Level: List
     */
    toListBatchSummaries() {
        return this.to('ListBatchSummaries');
    }
    /**
     * Grants permission to list project data transfers
     *
     * Access Level: List
     */
    toListProjectDataTransfers() {
        return this.to('ListProjectDataTransfers');
    }
    /**
     * Grants permission to list project summaries
     *
     * Access Level: List
     */
    toListProjectSummaries() {
        return this.to('ListProjectSummaries');
    }
    /**
     * Grants permission to start a batch data transfer
     *
     * Access Level: Write
     */
    toStartBatchDataTransfer() {
        return this.to('StartBatchDataTransfer');
    }
    /**
     * Grants permission to start a project data transfer
     *
     * Access Level: Write
     */
    toStartProjectDataTransfer() {
        return this.to('StartProjectDataTransfer');
    }
    /**
     * Grants permission to update a batch
     *
     * Access Level: Write
     */
    toUpdateBatch() {
        return this.to('UpdateBatch');
    }
}
exports.SagemakerGroundtruthSynthetic = SagemakerGroundtruthSynthetic;
_a = JSII_RTTI_SYMBOL_1;
SagemakerGroundtruthSynthetic[_a] = { fqn: "iam-floyd.SagemakerGroundtruthSynthetic", version: "0.442.0" };
//# sourceMappingURL=data:application/json;base64,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