"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplate = void 0;
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class ApprovalRuleTemplate extends core_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const { approvalRuleTemplateName, approvalRuleTemplateDescription, template } = props;
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::ApprovalRuleTemplate', {
            codeDirectory: directories_1.approvalRuleTemplateDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:CreateApprovalRuleTemplate',
                        'codecommit:DeleteApprovalRuleTemplate',
                        'codecommit:GetApprovalRuleTemplate',
                        'codecommit:UpdateApprovalRuleTemplateContent',
                        'codecommit:UpdateApprovalRuleTemplateDescription',
                        'codecommit:UpdateApprovalRuleTemplateName',
                    ],
                    Resource: '*',
                },
            ],
        });
        const resource = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::ApprovalRuleTemplate',
            properties: {
                ApprovalRuleTemplateName: approvalRuleTemplateName,
                ApprovalRuleTemplateDescription: approvalRuleTemplateDescription,
                Template: {
                    DestinationReferences: (_a = template.branches) === null || _a === void 0 ? void 0 : _a.map((branch) => `refs/heads/${branch}`),
                    Approvers: {
                        NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
                        ApprovalPoolMembers: template.approvers.approvalPoolMembers,
                    },
                },
            },
        });
        this.approvalRuleTemplateName = resource.getAttString('ApprovalRuleTemplateName');
    }
}
exports.ApprovalRuleTemplate = ApprovalRuleTemplate;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwcm92YWwtcnVsZS10ZW1wbGF0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hcHByb3ZhbC1ydWxlLXRlbXBsYXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUFpSDtBQUVqSCwrQ0FBd0Q7QUE2QnhELE1BQWEsb0JBQXFCLFNBQVEsZ0JBQVM7SUFHakQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFnQzs7UUFDeEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLEVBQUUsd0JBQXdCLEVBQUUsK0JBQStCLEVBQUUsUUFBUSxFQUFFLEdBQUcsS0FBSyxDQUFDO1FBRXRGLE1BQU0sWUFBWSxHQUFHLDZCQUFzQixDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsOEJBQThCLEVBQUU7WUFDNUYsYUFBYSxFQUFFLHFDQUF1QjtZQUN0QyxPQUFPLEVBQUUsb0NBQTZCLENBQUMsU0FBUztZQUNoRCxnQkFBZ0IsRUFBRTtnQkFDaEI7b0JBQ0UsTUFBTSxFQUFFLE9BQU87b0JBQ2YsTUFBTSxFQUFFO3dCQUNOLHVDQUF1Qzt3QkFDdkMsdUNBQXVDO3dCQUN2QyxvQ0FBb0M7d0JBQ3BDLDhDQUE4Qzt3QkFDOUMsa0RBQWtEO3dCQUNsRCwyQ0FBMkM7cUJBQzVDO29CQUNELFFBQVEsRUFBRSxHQUFHO2lCQUNkO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLFFBQVEsR0FBRyxJQUFJLHFCQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFO1lBQzFELFlBQVk7WUFDWixZQUFZLEVBQUUsOEJBQThCO1lBQzVDLFVBQVUsRUFBRTtnQkFDVix3QkFBd0IsRUFBRSx3QkFBd0I7Z0JBQ2xELCtCQUErQixFQUFFLCtCQUErQjtnQkFDaEUsUUFBUSxFQUFFO29CQUNSLHFCQUFxQixRQUFFLFFBQVEsQ0FBQyxRQUFRLDBDQUFFLEdBQUcsQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsY0FBYyxNQUFNLEVBQUUsQ0FBQztvQkFDakYsU0FBUyxFQUFFO3dCQUNULHVCQUF1QixFQUFFLFFBQVEsQ0FBQyxTQUFTLENBQUMsdUJBQXVCO3dCQUNuRSxtQkFBbUIsRUFBRSxRQUFRLENBQUMsU0FBUyxDQUFDLG1CQUFtQjtxQkFDNUQ7aUJBQ0Y7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyx3QkFBd0IsR0FBRyxRQUFRLENBQUMsWUFBWSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDcEYsQ0FBQztDQUNGO0FBN0NELG9EQTZDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCwgQ3VzdG9tUmVzb3VyY2UsIEN1c3RvbVJlc291cmNlUHJvdmlkZXIsIEN1c3RvbVJlc291cmNlUHJvdmlkZXJSdW50aW1lIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmltcG9ydCB7IGFwcHJvdmFsUnVsZVRlbXBsYXRlRGlyIH0gZnJvbSAnLi9kaXJlY3Rvcmllcyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXBwcm92ZXJzIHtcbiAgcmVhZG9ubHkgbnVtYmVyT2ZBcHByb3ZhbHNOZWVkZWQ6IG51bWJlcjtcbiAgcmVhZG9ubHkgYXBwcm92YWxQb29sTWVtYmVycz86IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBUZW1wbGF0ZSB7XG4gIHJlYWRvbmx5IGJyYW5jaGVzPzogc3RyaW5nW107XG4gIHJlYWRvbmx5IGFwcHJvdmVyczogQXBwcm92ZXJzO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEFwcHJvdmFsUnVsZVRlbXBsYXRlUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBwcm92YWxSdWxlVGVtcGxhdGVOYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFwcHJvdmFsUnVsZVRlbXBsYXRlRGVzY3JpcHRpb24/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRlbXBsYXRlOiBUZW1wbGF0ZTtcbn1cblxuZXhwb3J0IGNsYXNzIEFwcHJvdmFsUnVsZVRlbXBsYXRlIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGFwcHJvdmFsUnVsZVRlbXBsYXRlTmFtZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBcHByb3ZhbFJ1bGVUZW1wbGF0ZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHsgYXBwcm92YWxSdWxlVGVtcGxhdGVOYW1lLCBhcHByb3ZhbFJ1bGVUZW1wbGF0ZURlc2NyaXB0aW9uLCB0ZW1wbGF0ZSB9ID0gcHJvcHM7XG5cbiAgICBjb25zdCBzZXJ2aWNlVG9rZW4gPSBDdXN0b21SZXNvdXJjZVByb3ZpZGVyLmdldE9yQ3JlYXRlKHRoaXMsICdDdXN0b206OkFwcHJvdmFsUnVsZVRlbXBsYXRlJywge1xuICAgICAgY29kZURpcmVjdG9yeTogYXBwcm92YWxSdWxlVGVtcGxhdGVEaXIsXG4gICAgICBydW50aW1lOiBDdXN0b21SZXNvdXJjZVByb3ZpZGVyUnVudGltZS5OT0RFSlNfMTIsXG4gICAgICBwb2xpY3lTdGF0ZW1lbnRzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgICAgICAgQWN0aW9uOiBbXG4gICAgICAgICAgICAnY29kZWNvbW1pdDpDcmVhdGVBcHByb3ZhbFJ1bGVUZW1wbGF0ZScsXG4gICAgICAgICAgICAnY29kZWNvbW1pdDpEZWxldGVBcHByb3ZhbFJ1bGVUZW1wbGF0ZScsXG4gICAgICAgICAgICAnY29kZWNvbW1pdDpHZXRBcHByb3ZhbFJ1bGVUZW1wbGF0ZScsXG4gICAgICAgICAgICAnY29kZWNvbW1pdDpVcGRhdGVBcHByb3ZhbFJ1bGVUZW1wbGF0ZUNvbnRlbnQnLFxuICAgICAgICAgICAgJ2NvZGVjb21taXQ6VXBkYXRlQXBwcm92YWxSdWxlVGVtcGxhdGVEZXNjcmlwdGlvbicsXG4gICAgICAgICAgICAnY29kZWNvbW1pdDpVcGRhdGVBcHByb3ZhbFJ1bGVUZW1wbGF0ZU5hbWUnLFxuICAgICAgICAgIF0sXG4gICAgICAgICAgUmVzb3VyY2U6ICcqJyxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfSk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDdXN0b21SZXNvdXJjZSh0aGlzLCAnQ3VzdG9tUmVzb3VyY2UnLCB7XG4gICAgICBzZXJ2aWNlVG9rZW4sXG4gICAgICByZXNvdXJjZVR5cGU6ICdDdXN0b206OkFwcHJvdmFsUnVsZVRlbXBsYXRlJyxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgQXBwcm92YWxSdWxlVGVtcGxhdGVOYW1lOiBhcHByb3ZhbFJ1bGVUZW1wbGF0ZU5hbWUsXG4gICAgICAgIEFwcHJvdmFsUnVsZVRlbXBsYXRlRGVzY3JpcHRpb246IGFwcHJvdmFsUnVsZVRlbXBsYXRlRGVzY3JpcHRpb24sXG4gICAgICAgIFRlbXBsYXRlOiB7XG4gICAgICAgICAgRGVzdGluYXRpb25SZWZlcmVuY2VzOiB0ZW1wbGF0ZS5icmFuY2hlcz8ubWFwKChicmFuY2gpID0+IGByZWZzL2hlYWRzLyR7YnJhbmNofWApLFxuICAgICAgICAgIEFwcHJvdmVyczoge1xuICAgICAgICAgICAgTnVtYmVyT2ZBcHByb3ZhbHNOZWVkZWQ6IHRlbXBsYXRlLmFwcHJvdmVycy5udW1iZXJPZkFwcHJvdmFsc05lZWRlZCxcbiAgICAgICAgICAgIEFwcHJvdmFsUG9vbE1lbWJlcnM6IHRlbXBsYXRlLmFwcHJvdmVycy5hcHByb3ZhbFBvb2xNZW1iZXJzLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5hcHByb3ZhbFJ1bGVUZW1wbGF0ZU5hbWUgPSByZXNvdXJjZS5nZXRBdHRTdHJpbmcoJ0FwcHJvdmFsUnVsZVRlbXBsYXRlTmFtZScpO1xuICB9XG59XG4iXX0=