import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BillingSubaccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html#deletion_policy BillingSubaccount#deletion_policy}.
     *
     * @stability stable
     */
    readonly deletionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html#display_name BillingSubaccount#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html#master_billing_account BillingSubaccount#master_billing_account}.
     *
     * @stability stable
     */
    readonly masterBillingAccount: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html google_billing_subaccount}.
 *
 * @stability stable
 */
export declare class BillingSubaccount extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_subaccount.html google_billing_subaccount} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BillingSubaccountConfig);
    /**
     * @stability stable
     */
    get billingAccountId(): string;
    private _deletionPolicy?;
    /**
     * @stability stable
     */
    get deletionPolicy(): string;
    /**
     * @stability stable
     */
    set deletionPolicy(value: string);
    /**
     * @stability stable
     */
    resetDeletionPolicy(): void;
    /**
     * @stability stable
     */
    get deletionPolicyInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _masterBillingAccount?;
    /**
     * @stability stable
     */
    get masterBillingAccount(): string;
    /**
     * @stability stable
     */
    set masterBillingAccount(value: string);
    /**
     * @stability stable
     */
    get masterBillingAccountInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get open(): any;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
