import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNodeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional textual description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#description ComputeNodeGroup#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The initial number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#initial_size ComputeNodeGroup#initial_size}
     *
     * @stability stable
     */
    readonly initialSize?: number;
    /**
     * Specifies how to handle instances when a node in the group undergoes maintenance.
     *
     * Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#maintenance_policy ComputeNodeGroup#maintenance_policy}
     *
     * @stability stable
     */
    readonly maintenancePolicy?: string;
    /**
     * Name of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#name ComputeNodeGroup#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The URL of the node template to which this node group belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#node_template ComputeNodeGroup#node_template}
     *
     * @stability stable
     */
    readonly nodeTemplate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#project ComputeNodeGroup#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The total number of nodes in the node group. One of 'initial_size' or 'size' must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#size ComputeNodeGroup#size}
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * Zone where this node group is located.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#zone ComputeNodeGroup#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * autoscaling_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#autoscaling_policy ComputeNodeGroup#autoscaling_policy}
     *
     * @stability stable
     */
    readonly autoscalingPolicy?: ComputeNodeGroupAutoscalingPolicy;
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#maintenance_window ComputeNodeGroup#maintenance_window}
     *
     * @stability stable
     */
    readonly maintenanceWindow?: ComputeNodeGroupMaintenanceWindow;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#timeouts ComputeNodeGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNodeGroupTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNodeGroupAutoscalingPolicy {
    /**
     * Maximum size of the node group.
     *
     * Set to a value less than or equal
     * to 100 and greater than or equal to min-nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#max_nodes ComputeNodeGroup#max_nodes}
     *
     * @stability stable
     */
    readonly maxNodes?: number;
    /**
     * Minimum size of the node group. Must be less than or equal to max-nodes. The default value is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#min_nodes ComputeNodeGroup#min_nodes}
     *
     * @stability stable
     */
    readonly minNodes?: number;
    /**
     * The autoscaling mode.
     *
     * Set to one of the following:
     * - OFF: Disables the autoscaler.
     * - ON: Enables scaling in and scaling out.
     * - ONLY_SCALE_OUT: Enables only scaling out.
     * You must use this mode if your node groups are configured to
     * restart their hosted VMs on minimal servers. Possible values: ["OFF", "ON", "ONLY_SCALE_OUT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#mode ComputeNodeGroup#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
}
export declare function computeNodeGroupAutoscalingPolicyToTerraform(struct?: ComputeNodeGroupAutoscalingPolicyOutputReference | ComputeNodeGroupAutoscalingPolicy): any;
/**
 * @stability stable
 */
export declare class ComputeNodeGroupAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeNodeGroupAutoscalingPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeNodeGroupAutoscalingPolicy | undefined);
    private _maxNodes?;
    /**
     * @stability stable
     */
    get maxNodes(): number;
    /**
     * @stability stable
     */
    set maxNodes(value: number);
    /**
     * @stability stable
     */
    resetMaxNodes(): void;
    /**
     * @stability stable
     */
    get maxNodesInput(): number | undefined;
    private _minNodes?;
    /**
     * @stability stable
     */
    get minNodes(): number;
    /**
     * @stability stable
     */
    set minNodes(value: number);
    /**
     * @stability stable
     */
    resetMinNodes(): void;
    /**
     * @stability stable
     */
    get minNodesInput(): number | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeNodeGroupMaintenanceWindow {
    /**
     * instances.start time of the window. This must be in UTC format that resolves to one of 00:00, 04:00, 08:00, 12:00, 16:00, or 20:00. For example, both 13:00-5 and 08:00 are valid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#start_time ComputeNodeGroup#start_time}
     *
     * @stability stable
     */
    readonly startTime: string;
}
export declare function computeNodeGroupMaintenanceWindowToTerraform(struct?: ComputeNodeGroupMaintenanceWindowOutputReference | ComputeNodeGroupMaintenanceWindow): any;
/**
 * @stability stable
 */
export declare class ComputeNodeGroupMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeNodeGroupMaintenanceWindow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeNodeGroupMaintenanceWindow | undefined);
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeNodeGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#create ComputeNodeGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#delete ComputeNodeGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html#update ComputeNodeGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeNodeGroupTimeoutsToTerraform(struct?: ComputeNodeGroupTimeoutsOutputReference | ComputeNodeGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeNodeGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeNodeGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeNodeGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html google_compute_node_group}.
 *
 * @stability stable
 */
export declare class ComputeNodeGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_node_group.html google_compute_node_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNodeGroupConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialSize?;
    /**
     * @stability stable
     */
    get initialSize(): number;
    /**
     * @stability stable
     */
    set initialSize(value: number);
    /**
     * @stability stable
     */
    resetInitialSize(): void;
    /**
     * @stability stable
     */
    get initialSizeInput(): number | undefined;
    private _maintenancePolicy?;
    /**
     * @stability stable
     */
    get maintenancePolicy(): string;
    /**
     * @stability stable
     */
    set maintenancePolicy(value: string);
    /**
     * @stability stable
     */
    resetMaintenancePolicy(): void;
    /**
     * @stability stable
     */
    get maintenancePolicyInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeTemplate?;
    /**
     * @stability stable
     */
    get nodeTemplate(): string;
    /**
     * @stability stable
     */
    set nodeTemplate(value: string);
    /**
     * @stability stable
     */
    get nodeTemplateInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _autoscalingPolicy;
    /**
     * @stability stable
     */
    get autoscalingPolicy(): ComputeNodeGroupAutoscalingPolicyOutputReference;
    /**
     * @stability stable
     */
    putAutoscalingPolicy(value: ComputeNodeGroupAutoscalingPolicy): void;
    /**
     * @stability stable
     */
    resetAutoscalingPolicy(): void;
    /**
     * @stability stable
     */
    get autoscalingPolicyInput(): ComputeNodeGroupAutoscalingPolicy | undefined;
    private _maintenanceWindow;
    /**
     * @stability stable
     */
    get maintenanceWindow(): ComputeNodeGroupMaintenanceWindowOutputReference;
    /**
     * @stability stable
     */
    putMaintenanceWindow(value: ComputeNodeGroupMaintenanceWindow): void;
    /**
     * @stability stable
     */
    resetMaintenanceWindow(): void;
    /**
     * @stability stable
     */
    get maintenanceWindowInput(): ComputeNodeGroupMaintenanceWindow | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNodeGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeNodeGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNodeGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
