import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataflowJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * List of experiments that should be used by the job. An example value is ["enable_stackdriver_agent_metrics"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#additional_experiments DataflowJob#additional_experiments}
     *
     * @stability stable
     */
    readonly additionalExperiments?: string[];
    /**
     * Indicates if the job should use the streaming engine feature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#enable_streaming_engine DataflowJob#enable_streaming_engine}
     *
     * @stability stable
     */
    readonly enableStreamingEngine?: boolean | cdktf.IResolvable;
    /**
     * The configuration for VM IPs. Options are "WORKER_IP_PUBLIC" or "WORKER_IP_PRIVATE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#ip_configuration DataflowJob#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration?: string;
    /**
     * The name for the Cloud KMS key for the job. Key format is: projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#kms_key_name DataflowJob#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName?: string;
    /**
     * User labels to be specified for the job.
     *
     * Keys and values should follow the restrictions specified in the labeling restrictions page. NOTE: Google-provided Dataflow templates often provide default labels that begin with goog-dataflow-provided. Unless explicitly set in config, these labels will be ignored to prevent diffs on re-apply.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#labels DataflowJob#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The machine type to use for the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#machine_type DataflowJob#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The number of workers permitted to work on the job. More workers may improve processing speed at additional cost.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#max_workers DataflowJob#max_workers}
     *
     * @stability stable
     */
    readonly maxWorkers?: number;
    /**
     * A unique name for the resource, required by Dataflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#name DataflowJob#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The network to which VMs will be assigned. If it is not provided, "default" will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#network DataflowJob#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * One of "drain" or "cancel". Specifies behavior of deletion during terraform destroy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#on_delete DataflowJob#on_delete}
     *
     * @stability stable
     */
    readonly onDelete?: string;
    /**
     * Key/Value pairs to be passed to the Dataflow job (as used in the template).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#parameters DataflowJob#parameters}
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The project in which the resource belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#project DataflowJob#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region in which the created job should run.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#region DataflowJob#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The Service Account email used to create the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#service_account_email DataflowJob#service_account_email}
     *
     * @stability stable
     */
    readonly serviceAccountEmail?: string;
    /**
     * The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#subnetwork DataflowJob#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * A writeable location on Google Cloud Storage for the Dataflow job to dump its temporary data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#temp_gcs_location DataflowJob#temp_gcs_location}
     *
     * @stability stable
     */
    readonly tempGcsLocation: string;
    /**
     * The Google Cloud Storage path to the Dataflow job template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#template_gcs_path DataflowJob#template_gcs_path}
     *
     * @stability stable
     */
    readonly templateGcsPath: string;
    /**
     * Only applicable when updating a pipeline.
     *
     * Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#transform_name_mapping DataflowJob#transform_name_mapping}
     *
     * @stability stable
     */
    readonly transformNameMapping?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The zone in which the created job should run. If it is not provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#zone DataflowJob#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#timeouts DataflowJob#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataflowJobTimeouts;
}
/**
 * @stability stable
 */
export interface DataflowJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#update DataflowJob#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataflowJobTimeoutsToTerraform(struct?: DataflowJobTimeoutsOutputReference | DataflowJobTimeouts): any;
/**
 * @stability stable
 */
export declare class DataflowJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataflowJobTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataflowJobTimeouts | undefined);
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html google_dataflow_job}.
 *
 * @stability stable
 */
export declare class DataflowJob extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html google_dataflow_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataflowJobConfig);
    private _additionalExperiments?;
    /**
     * @stability stable
     */
    get additionalExperiments(): string[];
    /**
     * @stability stable
     */
    set additionalExperiments(value: string[]);
    /**
     * @stability stable
     */
    resetAdditionalExperiments(): void;
    /**
     * @stability stable
     */
    get additionalExperimentsInput(): string[] | undefined;
    private _enableStreamingEngine?;
    /**
     * @stability stable
     */
    get enableStreamingEngine(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableStreamingEngine(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableStreamingEngine(): void;
    /**
     * @stability stable
     */
    get enableStreamingEngineInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipConfiguration?;
    /**
     * @stability stable
     */
    get ipConfiguration(): string;
    /**
     * @stability stable
     */
    set ipConfiguration(value: string);
    /**
     * @stability stable
     */
    resetIpConfiguration(): void;
    /**
     * @stability stable
     */
    get ipConfigurationInput(): string | undefined;
    /**
     * @stability stable
     */
    get jobId(): string;
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    resetKmsKeyName(): void;
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _maxWorkers?;
    /**
     * @stability stable
     */
    get maxWorkers(): number;
    /**
     * @stability stable
     */
    set maxWorkers(value: number);
    /**
     * @stability stable
     */
    resetMaxWorkers(): void;
    /**
     * @stability stable
     */
    get maxWorkersInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _onDelete?;
    /**
     * @stability stable
     */
    get onDelete(): string;
    /**
     * @stability stable
     */
    set onDelete(value: string);
    /**
     * @stability stable
     */
    resetOnDelete(): void;
    /**
     * @stability stable
     */
    get onDeleteInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _serviceAccountEmail?;
    /**
     * @stability stable
     */
    get serviceAccountEmail(): string;
    /**
     * @stability stable
     */
    set serviceAccountEmail(value: string);
    /**
     * @stability stable
     */
    resetServiceAccountEmail(): void;
    /**
     * @stability stable
     */
    get serviceAccountEmailInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
    private _tempGcsLocation?;
    /**
     * @stability stable
     */
    get tempGcsLocation(): string;
    /**
     * @stability stable
     */
    set tempGcsLocation(value: string);
    /**
     * @stability stable
     */
    get tempGcsLocationInput(): string | undefined;
    private _templateGcsPath?;
    /**
     * @stability stable
     */
    get templateGcsPath(): string;
    /**
     * @stability stable
     */
    set templateGcsPath(value: string);
    /**
     * @stability stable
     */
    get templateGcsPathInput(): string | undefined;
    private _transformNameMapping?;
    /**
     * @stability stable
     */
    get transformNameMapping(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set transformNameMapping(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTransformNameMapping(): void;
    /**
     * @stability stable
     */
    get transformNameMappingInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataflowJobTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataflowJobTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataflowJobTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
