# corrily-live-price
Corrily's LivePrice lets you to interact with Corrily's localization and dynamic pricing models to localize and
optimize your prices in real-time.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.1.4
- Package version: 0.0.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import corrily_live_price
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import corrily_live_price
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import corrily_live_price
from pprint import pprint
from corrily_live_price.api import default_api
from corrily_live_price.model.get_batch_request import GetBatchRequest
from corrily_live_price.model.get_price_request import GetPriceRequest
from corrily_live_price.model.price import Price
from corrily_live_price.model.products import Products
from corrily_live_price.model.set_success_request import SetSuccessRequest
from corrily_live_price.model.set_success_response import SetSuccessResponse
# Defining the host is optional and defaults to https://app.corrily.com/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = corrily_live_price.Configuration(
    host = "https://app.corrily.com/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: corrily_auth
configuration.api_key['corrily_auth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['corrily_auth'] = 'Bearer'


# Enter a context with an instance of the API client
with corrily_live_price.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    body = GetBatchRequest(
        user_id="user_id_example",
        ip="ip_example",
        country="country_example",
        products=[
            Product(
                product_id="product_id_example",
                base_price=3.14,
            ),
        ],
    ) # GetBatchRequest | The same as Get Price but does the localization and/or optimization across a batch of products.  (optional)

    try:
        # Get batch of prices
        api_response = api_instance.get_batch(body=body)
        pprint(api_response)
    except corrily_live_price.ApiException as e:
        print("Exception when calling DefaultApi->get_batch: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://app.corrily.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_batch**](docs/DefaultApi.md#get_batch) | **POST** /prices/getBatch | Get batch of prices
*DefaultApi* | [**get_price**](docs/DefaultApi.md#get_price) | **POST** /prices/get | Get price
*DefaultApi* | [**set_success**](docs/DefaultApi.md#set_success) | **POST** /prices/setSuccess | Set success


## Documentation For Models

 - [GetBatchRequest](docs/GetBatchRequest.md)
 - [GetPriceRequest](docs/GetPriceRequest.md)
 - [Price](docs/Price.md)
 - [Product](docs/Product.md)
 - [Products](docs/Products.md)
 - [ProductsProducts](docs/ProductsProducts.md)
 - [ProductsProductsProduct1](docs/ProductsProductsProduct1.md)
 - [ProductsProductsProduct2](docs/ProductsProductsProduct2.md)
 - [SetSuccessRequest](docs/SetSuccessRequest.md)
 - [SetSuccessResponse](docs/SetSuccessResponse.md)


## Documentation For Authorization


## corrily_auth

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

founders@corrily.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in corrily_live_price.apis and corrily_live_price.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from corrily_live_price.api.default_api import DefaultApi`
- `from corrily_live_price.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import corrily_live_price
from corrily_live_price.apis import *
from corrily_live_price.models import *
```

