# coding: utf-8


"""
IGNORE:
    Nutanix Clustermgmt Versioned APIs

    Manage Hosts, Clusters and other Infrastructure.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_clustermgmt_py_client.api_client import ApiClient


class ClusterApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_cluster(self, clusterExtId, **kwargs):  # noqa: E501
        """Get cluster entity
        Get cluster entity

        >>> response = api.get_cluster(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cluster(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_cluster_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get cluster entity
        Get cluster entity

        >>> response = api.get_cluster(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cluster_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetClusterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clusters(self, **kwargs):  # noqa: E501
        """Get cluster entities
        Get cluster entities

        >>> response = api.get_clusters((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clusters(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - extId
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - name
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClustersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_clusters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_clusters_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_clusters_with_http_info(self, **kwargs):  # noqa: E501
        """Get cluster entities
        Get cluster entities

        >>> response = api.get_clusters((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clusters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - extId
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - name
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClustersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clusters" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetClustersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_domain_fault_tolerance_status(self, clusterExtId, **kwargs):  # noqa: E501
        """Get Domain Fault tolerance status
        Get Domain Fault tolerance status

        >>> response = api.get_domain_fault_tolerance_status(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_domain_fault_tolerance_status(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetDomainFaultToleranceResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_domain_fault_tolerance_status_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_domain_fault_tolerance_status_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_domain_fault_tolerance_status_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get Domain Fault tolerance status
        Get Domain Fault tolerance status

        >>> response = api.get_domain_fault_tolerance_status(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_domain_fault_tolerance_status_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetDomainFaultToleranceResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_domain_fault_tolerance_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_domain_fault_tolerance_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/domain-fault-tolerance-status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetDomainFaultToleranceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_gpu_profiles(self, clusterExtId, **kwargs):  # noqa: E501
        """Get GPU profiles
        Get GPU profiles

        >>> response = api.get_gpu_profiles(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gpu_profiles(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetGpuProfilesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_gpu_profiles_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_gpu_profiles_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_gpu_profiles_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get GPU profiles
        Get GPU profiles

        >>> response = api.get_gpu_profiles(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gpu_profiles_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetGpuProfilesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gpu_profiles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_gpu_profiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/gpu-profiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetGpuProfilesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host entity
        Get host entity

        >>> response = api.get_host(clusterExtId, hostExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
            return data

    def get_host_with_http_info(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host entity
        Get host entity

        >>> response = api.get_host(clusterExtId, hostExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_with_http_info(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'hostExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host`")  # noqa: E501
        # verify the required parameter 'hostExtId' is set
        if ('hostExtId' not in params or
                params['hostExtId'] is None):
            raise ValueError("Missing the required parameter `hostExtId` when calling `get_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'hostExtId' in params:
            path_params['hostExtId'] = params['hostExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/host/{hostExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_gpu(self, clusterExtId, hostExtId, hostGpuExtId, **kwargs):  # noqa: E501
        """Get host GPU
        Get host GPU

        >>> response = api.get_host_gpu(clusterExtId, hostExtId, hostGpuExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpu(clusterExtId, hostExtId, hostGpuExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param str hostGpuExtId: Host GPU UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_gpu_with_http_info(clusterExtId, hostExtId, hostGpuExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_gpu_with_http_info(clusterExtId, hostExtId, hostGpuExtId, **kwargs)  # noqa: E501
            return data

    def get_host_gpu_with_http_info(self, clusterExtId, hostExtId, hostGpuExtId, **kwargs):  # noqa: E501
        """Get host GPU
        Get host GPU

        >>> response = api.get_host_gpu(clusterExtId, hostExtId, hostGpuExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpu_with_http_info(clusterExtId, hostExtId, hostGpuExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param str hostGpuExtId: Host GPU UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'hostExtId', 'hostGpuExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_gpu" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host_gpu`")  # noqa: E501
        # verify the required parameter 'hostExtId' is set
        if ('hostExtId' not in params or
                params['hostExtId'] is None):
            raise ValueError("Missing the required parameter `hostExtId` when calling `get_host_gpu`")  # noqa: E501
        # verify the required parameter 'hostGpuExtId' is set
        if ('hostGpuExtId' not in params or
                params['hostGpuExtId'] is None):
            raise ValueError("Missing the required parameter `hostGpuExtId` when calling `get_host_gpu`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'hostExtId' in params:
            path_params['hostExtId'] = params['hostExtId']  # noqa: E501
        if 'hostGpuExtId' in params:
            path_params['hostGpuExtId'] = params['hostGpuExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/host/{hostExtId}/host-gpu/{hostGpuExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostGpuResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_gpus(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host GPUs on a particular host
        Get host GPUs on a particular host

        >>> response = api.get_host_gpus(clusterExtId, hostExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_gpus_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_gpus_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
            return data

    def get_host_gpus_with_http_info(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host GPUs on a particular host
        Get host GPUs on a particular host

        >>> response = api.get_host_gpus(clusterExtId, hostExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus_with_http_info(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'hostExtId', '_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_gpus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host_gpus`")  # noqa: E501
        # verify the required parameter 'hostExtId' is set
        if ('hostExtId' not in params or
                params['hostExtId'] is None):
            raise ValueError("Missing the required parameter `hostExtId` when calling `get_host_gpus`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'hostExtId' in params:
            path_params['hostExtId'] = params['hostExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/host/{hostExtId}/host-gpus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostGpusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_gpus_of_cluster(self, clusterExtId, **kwargs):  # noqa: E501
        """Get all host GPUs of a cluster
        Get all host GPUs of a cluster

        >>> response = api.get_host_gpus_of_cluster(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus_of_cluster(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_gpus_of_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_gpus_of_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_host_gpus_of_cluster_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get all host GPUs of a cluster
        Get all host GPUs of a cluster

        >>> response = api.get_host_gpus_of_cluster(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus_of_cluster_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', '_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_gpus_of_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host_gpus_of_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/host-gpus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetClusterHostGpusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hosts(self, clusterExtId, **kwargs):  # noqa: E501
        """Get host entities of a cluster
        Get host entities of a cluster

        >>> response = api.get_hosts(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hosts(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - bootTimeUsecs
        - cpuCapacityHz
        - cpuFrequencyHz
        - cpuModel
        - defaultVhdContainerId
        - defaultVhdContainerUuid
        - defaultVhdLocation
        - defaultVmContainerId
        - defaultVmContainerUuid
        - defaultVmLocation
        - gpuDriverVersion
        - hostName
        - memorySizeBytes
        - numberOfCpuCores
        - numberOfCpuSockets
        - numberOfCpuThreads
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hosts_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hosts_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_hosts_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get host entities of a cluster
        Get host entities of a cluster

        >>> response = api.get_hosts(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hosts_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - bootTimeUsecs
        - cpuCapacityHz
        - cpuFrequencyHz
        - cpuModel
        - defaultVhdContainerId
        - defaultVhdContainerUuid
        - defaultVhdLocation
        - defaultVmContainerId
        - defaultVmContainerUuid
        - defaultVmLocation
        - gpuDriverVersion
        - hostName
        - memorySizeBytes
        - numberOfCpuCores
        - numberOfCpuSockets
        - numberOfCpuThreads
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', '_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_hosts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/hosts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rackable_unit(self, clusterExtId, rackableUnitExtId, **kwargs):  # noqa: E501
        """Get rackable unit entity
        Get rackable unit entity

        >>> response = api.get_rackable_unit(clusterExtId, rackableUnitExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_unit(clusterExtId, rackableUnitExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rackableUnitExtId: Rackable unit UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rackable_unit_with_http_info(clusterExtId, rackableUnitExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rackable_unit_with_http_info(clusterExtId, rackableUnitExtId, **kwargs)  # noqa: E501
            return data

    def get_rackable_unit_with_http_info(self, clusterExtId, rackableUnitExtId, **kwargs):  # noqa: E501
        """Get rackable unit entity
        Get rackable unit entity

        >>> response = api.get_rackable_unit(clusterExtId, rackableUnitExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_unit_with_http_info(clusterExtId, rackableUnitExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rackableUnitExtId: Rackable unit UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'rackableUnitExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rackable_unit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_rackable_unit`")  # noqa: E501
        # verify the required parameter 'rackableUnitExtId' is set
        if ('rackableUnitExtId' not in params or
                params['rackableUnitExtId'] is None):
            raise ValueError("Missing the required parameter `rackableUnitExtId` when calling `get_rackable_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'rackableUnitExtId' in params:
            path_params['rackableUnitExtId'] = params['rackableUnitExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/rackable-unit/{rackableUnitExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetRackableUnitResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rackable_units(self, clusterExtId, **kwargs):  # noqa: E501
        """Get rackable unit entities of a cluster
        Get rackable unit entities of a cluster

        >>> response = api.get_rackable_units(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_units(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rackable_units_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rackable_units_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_rackable_units_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get rackable unit entities of a cluster
        Get rackable unit entities of a cluster

        >>> response = api.get_rackable_units(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_units_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rackable_units" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_rackable_units`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/rackable-units', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetRackableUnitsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rsyslog_servers(self, clusterExtId, **kwargs):  # noqa: E501
        """Get RSYSLOG Servers configuration details
        Get RSYSLOG Servers configuration details

        >>> response = api.get_rsyslog_servers(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rsyslog_servers(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRsyslogServersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rsyslog_servers_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rsyslog_servers_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_rsyslog_servers_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get RSYSLOG Servers configuration details
        Get RSYSLOG Servers configuration details

        >>> response = api.get_rsyslog_servers(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rsyslog_servers_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRsyslogServersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rsyslog_servers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_rsyslog_servers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/rsyslog', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetRsyslogServersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snmp(self, clusterExtId, **kwargs):  # noqa: E501
        """Get SNMP information
        Get SNMP information

        >>> response = api.get_snmp(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snmp_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snmp_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_snmp_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get SNMP information
        Get SNMP information

        >>> response = api.get_snmp(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snmp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_snmp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a1/config/cluster/{clusterExtId}/snmp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetSnmpResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
