# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.connector_check_result import ConnectorCheckResult
from arthur_client.api_bindings.models.connector_spec_field_with_metadata import ConnectorSpecFieldWithMetadata
from arthur_client.api_bindings.models.connector_type import ConnectorType
from arthur_client.api_bindings.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class ConnectorSpec(BaseModel):
    """
    ConnectorSpec
    """ # noqa: E501
    created_at: datetime = Field(description="Time of record creation.")
    updated_at: datetime = Field(description="Time of last record update.")
    id: StrictStr = Field(description="Connector id.")
    connector_type: ConnectorType = Field(description="Type of connector.")
    name: StrictStr = Field(description="Name of connector.")
    temporary: StrictBool = Field(description="True if connector is temporary (ie for testing only), false otherwise.")
    fields: List[ConnectorSpecFieldWithMetadata] = Field(description="List of fields for the connector.")
    last_updated_by_user: Optional[User] = None
    connector_check_result: Optional[ConnectorCheckResult] = None
    project_id: StrictStr = Field(description="ID of parent project.")
    data_plane_id: StrictStr = Field(description="ID of the data plane that will execute the connection. Should be formatted as a UUID.")
    __properties: ClassVar[List[str]] = ["created_at", "updated_at", "id", "connector_type", "name", "temporary", "fields", "last_updated_by_user", "connector_check_result", "project_id", "data_plane_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConnectorSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of last_updated_by_user
        if self.last_updated_by_user:
            _dict['last_updated_by_user'] = self.last_updated_by_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of connector_check_result
        if self.connector_check_result:
            _dict['connector_check_result'] = self.connector_check_result.to_dict()
        # set to None if last_updated_by_user (nullable) is None
        # and model_fields_set contains the field
        if self.last_updated_by_user is None and "last_updated_by_user" in self.model_fields_set:
            _dict['last_updated_by_user'] = None

        # set to None if connector_check_result (nullable) is None
        # and model_fields_set contains the field
        if self.connector_check_result is None and "connector_check_result" in self.model_fields_set:
            _dict['connector_check_result'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConnectorSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "id": obj.get("id"),
            "connector_type": obj.get("connector_type"),
            "name": obj.get("name"),
            "temporary": obj.get("temporary"),
            "fields": [ConnectorSpecFieldWithMetadata.from_dict(_item) for _item in obj["fields"]] if obj.get("fields") is not None else None,
            "last_updated_by_user": User.from_dict(obj["last_updated_by_user"]) if obj.get("last_updated_by_user") is not None else None,
            "connector_check_result": ConnectorCheckResult.from_dict(obj["connector_check_result"]) if obj.get("connector_check_result") is not None else None,
            "project_id": obj.get("project_id"),
            "data_plane_id": obj.get("data_plane_id")
        })
        return _obj


