from distutils.core import setup

import setuptools

setup(
    name='keraspoj',  # How you named your package folder (MyLib)
    packages=setuptools.find_packages(where='keraspoj'),
    version='0.3.1',  # Start with a small number and increase it with every change you make
    license='MIT',  # Chose a license from here: https://help.github.com/articles/licensing-a-repository
    description='yet another keras visualisation library',  # Give a short description about your library
    author='Jari Van Melckebeke',  # Type in your name
    author_email='jarivanmelckebeke@gmail.com',  # Type in your E-Mail
    url='https://github.com/jvanmelckebeke/model-visualizer',
    # Provide either the link to your github or to your website
    download_url='https://github.com/jvanmelckebeke/model-visualizer/archive/refs/tags/prerelease-2.tar.gz',
    # I explain this later on
    keywords=['tensorflow', 'keras', 'visualisation'],  # Keywords that define your package best
    install_requires=[  # I get to this in a second
        'numpy',
        'pandas',
        'keras',
        'matplotlib',
        'inflect',
        'jsonschema',
        'pyYAML',
        'Wand',
        'pygraphviz',
        'pydot',
        'pytz',
        'seaborn',
        'networkx'
    ],
    classifiers=[
        'Development Status :: 3 - Alpha',
        # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
        'Intended Audience :: Developers',  # Define that your audience are developers
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',  # Again, pick a license
        'Programming Language :: Python :: 3',  # Specify which pyhton versions that you want to support
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
    ],
    package_dir={"": "keraspoj"},
    python_requires=">=3.6"
)
