<a id="mypy-boto3-kms"></a>

# mypy-boto3-kms

[![PyPI - mypy-boto3-kms](https://img.shields.io/pypi/v/mypy-boto3-kms.svg?color=blue)](https://pypi.org/project/mypy-boto3-kms)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kms.svg?color=blue)](https://pypi.org/project/mypy-boto3-kms)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-kms?color=blue)](https://pypistats.org/packages/mypy-boto3-kms)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.KMS 1.18.50](https://boto3.amazonaws.com/v1/documentation/api/1.18.50/reference/services/kms.html#KMS)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-kms docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kms/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-kms](#mypy-boto3-kms)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `KMS` service.

```bash
python -m pip install boto3-stubs[kms]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`

Both type checking and auto-complete should work for `KMS` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`

Both type checking and auto-complete should work for `KMS` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`
- Run `mypy` as usual

Type checking should work for `KMS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[kms]` in your environment:
  `python -m pip install 'boto3-stubs[kms]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `KMS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`KMSClient` provides annotations for `boto3.client("kms")`.

```python
import boto3

from mypy_boto3_kms import KMSClient

client: KMSClient = boto3.client("kms")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KMSClient = session.client("kms")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_kms.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_kms import KMSClient
from mypy_boto3_kms.paginator import (
    ListAliasesPaginator,
    ListGrantsPaginator,
    ListKeyPoliciesPaginator,
    ListKeysPaginator,
)

client: KMSClient = boto3.client("kms")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_grants_paginator: ListGrantsPaginator = client.get_paginator("list_grants")
list_key_policies_paginator: ListKeyPoliciesPaginator = client.get_paginator("list_key_policies")
list_keys_paginator: ListKeysPaginator = client.get_paginator("list_keys")
```

<a id="literals"></a>

### Literals

`mypy_boto3_kms.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_kms.literals import (
    AlgorithmSpecType,
    ConnectionErrorCodeTypeType,
    ConnectionStateTypeType,
    CustomerMasterKeySpecType,
    DataKeyPairSpecType,
    DataKeySpecType,
    EncryptionAlgorithmSpecType,
    ExpirationModelTypeType,
    GrantOperationType,
    KeyManagerTypeType,
    KeySpecType,
    KeyStateType,
    KeyUsageTypeType,
    ListAliasesPaginatorName,
    ListGrantsPaginatorName,
    ListKeyPoliciesPaginatorName,
    ListKeysPaginatorName,
    MessageTypeType,
    MultiRegionKeyTypeType,
    OriginTypeType,
    SigningAlgorithmSpecType,
    WrappingKeySpecType,
    ServiceName,
    PaginatorName,
)

def check_value(value: AlgorithmSpecType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_kms.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_kms.type_defs import (
    AliasListEntryTypeDef,
    CancelKeyDeletionRequestRequestTypeDef,
    CancelKeyDeletionResponseTypeDef,
    ConnectCustomKeyStoreRequestRequestTypeDef,
    CreateAliasRequestRequestTypeDef,
    CreateCustomKeyStoreRequestRequestTypeDef,
    CreateCustomKeyStoreResponseTypeDef,
    CreateGrantRequestRequestTypeDef,
    CreateGrantResponseTypeDef,
    CreateKeyRequestRequestTypeDef,
    CreateKeyResponseTypeDef,
    CustomKeyStoresListEntryTypeDef,
    DecryptRequestRequestTypeDef,
    DecryptResponseTypeDef,
    DeleteAliasRequestRequestTypeDef,
    DeleteCustomKeyStoreRequestRequestTypeDef,
    DeleteImportedKeyMaterialRequestRequestTypeDef,
    DescribeCustomKeyStoresRequestRequestTypeDef,
    DescribeCustomKeyStoresResponseTypeDef,
    DescribeKeyRequestRequestTypeDef,
    DescribeKeyResponseTypeDef,
    DisableKeyRequestRequestTypeDef,
    DisableKeyRotationRequestRequestTypeDef,
    DisconnectCustomKeyStoreRequestRequestTypeDef,
    EnableKeyRequestRequestTypeDef,
    EnableKeyRotationRequestRequestTypeDef,
    EncryptRequestRequestTypeDef,
    EncryptResponseTypeDef,
    GenerateDataKeyPairRequestRequestTypeDef,
    GenerateDataKeyPairResponseTypeDef,
    GenerateDataKeyPairWithoutPlaintextRequestRequestTypeDef,
    GenerateDataKeyPairWithoutPlaintextResponseTypeDef,
    GenerateDataKeyRequestRequestTypeDef,
    GenerateDataKeyResponseTypeDef,
    GenerateDataKeyWithoutPlaintextRequestRequestTypeDef,
    GenerateDataKeyWithoutPlaintextResponseTypeDef,
    GenerateRandomRequestRequestTypeDef,
    GenerateRandomResponseTypeDef,
    GetKeyPolicyRequestRequestTypeDef,
    GetKeyPolicyResponseTypeDef,
    GetKeyRotationStatusRequestRequestTypeDef,
    GetKeyRotationStatusResponseTypeDef,
    GetParametersForImportRequestRequestTypeDef,
    GetParametersForImportResponseTypeDef,
    GetPublicKeyRequestRequestTypeDef,
    GetPublicKeyResponseTypeDef,
    GrantConstraintsTypeDef,
    GrantListEntryTypeDef,
    ImportKeyMaterialRequestRequestTypeDef,
    KeyListEntryTypeDef,
    KeyMetadataTypeDef,
    ListAliasesRequestRequestTypeDef,
    ListAliasesResponseTypeDef,
    ListGrantsRequestRequestTypeDef,
    ListGrantsResponseTypeDef,
    ListKeyPoliciesRequestRequestTypeDef,
    ListKeyPoliciesResponseTypeDef,
    ListKeysRequestRequestTypeDef,
    ListKeysResponseTypeDef,
    ListResourceTagsRequestRequestTypeDef,
    ListResourceTagsResponseTypeDef,
    ListRetirableGrantsRequestRequestTypeDef,
    MultiRegionConfigurationTypeDef,
    MultiRegionKeyTypeDef,
    PaginatorConfigTypeDef,
    PutKeyPolicyRequestRequestTypeDef,
    ReEncryptRequestRequestTypeDef,
    ReEncryptResponseTypeDef,
    ReplicateKeyRequestRequestTypeDef,
    ReplicateKeyResponseTypeDef,
    ResponseMetadataTypeDef,
    RetireGrantRequestRequestTypeDef,
    RevokeGrantRequestRequestTypeDef,
    ScheduleKeyDeletionRequestRequestTypeDef,
    ScheduleKeyDeletionResponseTypeDef,
    SignRequestRequestTypeDef,
    SignResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateAliasRequestRequestTypeDef,
    UpdateCustomKeyStoreRequestRequestTypeDef,
    UpdateKeyDescriptionRequestRequestTypeDef,
    UpdatePrimaryRegionRequestRequestTypeDef,
    VerifyRequestRequestTypeDef,
    VerifyResponseTypeDef,
)

def get_structure() -> AliasListEntryTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-kms` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-kms docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_kms/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
