# Generated by Django 2.2.11 on 2020-03-27 19:48

import uuid

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('submissions', '0004_remove_django_extensions'),
    ]

    operations = [
        migrations.CreateModel(
            name='TeamSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='created'
                )),
                ('modified', model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='modified'
                )),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4)),
                ('attempt_number', models.PositiveIntegerField()),
                ('submitted_at', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('course_id', models.CharField(db_index=True, max_length=255)),
                ('item_id', models.CharField(db_index=True, max_length=255)),
                ('team_id', models.CharField(db_index=True, max_length=255)),
                ('status', models.CharField(choices=[('D', 'Deleted'), ('A', 'Active')], default='A', max_length=1)),
                ('submitted_by', models.ForeignKey(
                    null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to=settings.AUTH_USER_MODEL
                )),
            ],
            options={
                'ordering': ['-submitted_at', '-id'],
            },
        ),
        migrations.AddField(
            model_name='submission',
            name='team_submission',
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='submissions',
                to='submissions.TeamSubmission'
            ),
        ),
    ]
