# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['twitterpersona']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.6.3,<4.0.0',
 'nltk>=3.8.1,<4.0.0',
 'numpy>=1.24.1,<2.0.0',
 'pandas>=1.5.2,<2.0.0',
 'pillow>=9.4.0,<10.0.0',
 'python-dotenv>=0.21.0,<0.22.0',
 'tweepy>=4.12.1,<5.0.0',
 'tweet-preprocessor>=0.6.0,<0.7.0',
 'wordcloud>=1.8.2.2,<2.0.0.0']

setup_kwargs = {
    'name': 'twitterpersona',
    'version': '0.0.1',
    'description': "Assess whether a twitter is positive or negative based on the user's recent tweets",
    'long_description': '# twitterpersona\n\nAssess a twitter user\'s character  based on their recent tweets\n\n## Summary\n\nTwitter is a popular social media app with over 1 billion user accounts. While a diversity of users is a strength, some individuals have concerns with the prevalence of "troll" accounts and individuals who exhibit unconstructive tone and diction whom they deem not worth engaging with.\nThe package twitterpersona is intended to provide insight into a twitter user based on their tweet history in effort to determine if an account is worth engaging with. The package provides an easy to use interface for determining the general sentiment expressed by a user.\n\n## Functions\n\n**load_twitter** : Returns a user\'s recent tweets (as a dataframe) given their `user id` using the Twitter API.\n\n**generalPreprocessing** : Cleans the recent tweet dataframe generated by `load_twitter`. Includes features such as removing punctuation and extracting emojis.\n\n**get_sentiment_result** : Determines the general (average) sentiment of recent tweets.\n\n**create_wordcloud** : Generates a word cloud of most frequently used words in tweets.\n\n## Scope and Fit\n\nThere are existing packages that preform tweet analysis (including [twitter-sentiment-analysis](https://github.com/abdulfatir/twitter-sentiment-analysis), [tweetlytics](https://github.com/UBC-MDS/tweetlytics), and [pytweet](https://github.com/UBC-MDS/pytweet)). However, none of these packages focus of providing metrics in the context of determining if the twitter user is worth engaging with.\n\n## Contributing\n\nInterested in contributing? Check out the contributing guidelines in CONTRIBUTING.md. Please note that this project is released with a Code of Conduct. By contributing to this project, you agree to abide by its terms.\n\n## License\n\n`twitterpersona` was created by Andy Wang, Renzo Wijngaarden, Roan Raina, Yurui Feng. It is licensed under the terms of the MIT license.\n\n## Credits\n\n`twitterpersona` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).',
    'author': 'Andy Wang, Renzo Wijngaarden, Roan Raina, Yurui Feng',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
