//ϵͳ
#ifdef WIN32
#include "pch.h"
#endif

#include "vnuft.h"
#include "pybind11/pybind11.h"
#include "uft/HSMdApi.h"


using namespace pybind11;

//
#define ONFRONTCONNECTED 0
#define ONFRONTDISCONNECTED 1
#define ONRSPDEPTHMARKETDATASUBSCRIBE 2
#define ONRSPDEPTHMARKETDATACANCEL 3
#define ONRTNDEPTHMARKETDATA 4



///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class MdApi : public CHSMdSpi
{
private:
	CHSMdApi* api;				//API
	thread task_thread;					//ָ߳루pythonݣ
	TaskQueue task_queue;			    //
	bool active = false;				//״̬

public:
	MdApi()
	{
	};

	~MdApi()
	{
		if (this->active)
		{
			this->exit();
		}
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	/// Description: ͻ뽻׺̨ʼͨӣӳɹ˷ص
	virtual void OnFrontConnected();

	/// Description:ͻ뽻׺̨ͨ쳣ʱ÷á
	/// Others     :ͨGetApiErrorMsg(nResult)ȡϸϢ
	virtual void OnFrontDisconnected(int nResult);

	/// Description: -Ӧ
	virtual void OnRspDepthMarketDataSubscribe(CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	/// Description: ȡ-Ӧ
	virtual void OnRspDepthMarketDataCancel(CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast);

	/// Description: -
	virtual void OnRtnDepthMarketData(CHSDepthMarketDataField *pDepthMarketData);

	//-------------------------------------------------------------------------------------
	//task
	//-------------------------------------------------------------------------------------

	void processTask();

	void processFrontConnected(Task *task);

	void processFrontDisconnected(Task *task);

	void processRspDepthMarketDataSubscribe(Task *task);

	void processRspDepthMarketDataCancel(Task *task);

	void processRtnDepthMarketData(Task *task);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//idid
	//lastǷΪ󷵻
	//i
	//-------------------------------------------------------------------------------------
	virtual void onFrontConnected() {};

	virtual void onFrontDisconnected(int reqid) {};

	virtual void onRspDepthMarketDataSubscribe(const dict &error, int reqid, bool last) {};

	virtual void onRspDepthMarketDataCancel(const dict &error, int reqid, bool last) {};

	virtual void onRtnDepthMarketData(const dict &data) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void newMdApi(string pszFlowPath);

	int init(string pszLicFile, string pszSafeLevel, string pszPwd, string pszSslFile, string pszSslPwd);

	int join(); 

	int exit();

	int registerFront(string pszFrontAddress);

	int registerFensServer(string pszFensAddress, string pszAccountID);

	int reqDepthMarketDataSubscribe(const dict &req, int reqid);

	int reqDepthMarketDataCancel(const dict &req, int reqid);

	string getApiErrorMsg(int nErrorCode);
};
