"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImagePipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs_1 = require("fs");
const iam = require("aws-cdk-lib/aws-iam");
const imagebuilder = require("aws-cdk-lib/aws-imagebuilder");
const sns = require("aws-cdk-lib/aws-sns");
const subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
class ImagePipeline extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        let infrastructureConfig = null;
        // Constuct code below
        const topic = new sns.Topic(this, 'ImageBuilderTopic', {
            displayName: 'Image Builder Notify',
        });
        if (props.email != null) {
            topic.addSubscription(new subscriptions.EmailSubscription(props.email));
        }
        const role = new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('ec2.amazonaws.com'),
            description: 'IAM role used as part of an Image Builder pipeline',
        });
        role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('EC2InstanceProfileForImageBuilder'));
        role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('EC2InstanceProfileForImageBuilderECRContainerBuilds'));
        role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        const profile = new iam.CfnInstanceProfile(this, 'InstanceProfile', {
            roles: [role.roleName],
            instanceProfileName: props.profileName,
        });
        if (props.securityGroups == null || props.subnetId == null) {
            infrastructureConfig = new imagebuilder.CfnInfrastructureConfiguration(this, 'InfrastructureConfiguration', {
                instanceProfileName: props.profileName,
                name: props.infraConfigName,
                description: 'Example Infrastructure Configuration for Image Builder',
                instanceTypes: (_b = props.instanceTypes) !== null && _b !== void 0 ? _b : ['t3.medium', 'm5.large', 'm5.xlarge'],
                snsTopicArn: topic.topicArn,
            });
        }
        else {
            infrastructureConfig = new imagebuilder.CfnInfrastructureConfiguration(this, 'InfrastructureConfiguration', {
                instanceProfileName: props.profileName,
                name: props.infraConfigName,
                description: 'Example Infrastructure Configuration for Image Builder',
                instanceTypes: (_c = props.instanceTypes) !== null && _c !== void 0 ? _c : ['t3.medium', 'm5.large', 'm5.xlarge'],
                snsTopicArn: topic.topicArn,
                securityGroupIds: props.securityGroups,
                subnetId: props.subnetId,
            });
        }
        infrastructureConfig.addDependsOn(profile);
        const component = new imagebuilder.CfnComponent(this, 'Component', {
            name: props.componentName,
            platform: (_d = props.platform) !== null && _d !== void 0 ? _d : 'Linux',
            version: '1.0.0',
            data: fs_1.readFileSync(props.componentDocPath).toString(),
        });
        const imageRecipe = new imagebuilder.CfnImageRecipe(this, 'ImageRecipe', {
            components: [{
                    componentArn: component.attrArn,
                }],
            name: props.imageRecipe,
            parentImage: props.parentImage,
            version: (_e = props.imageRecipeVersion) !== null && _e !== void 0 ? _e : '0.0.1',
        });
        new imagebuilder.CfnImagePipeline(this, 'ImagePipeline', {
            infrastructureConfigurationArn: infrastructureConfig.attrArn,
            name: props.pipelineName,
            description: 'A sample image pipeline',
            imageRecipeArn: imageRecipe.attrArn,
        });
    }
}
exports.ImagePipeline = ImagePipeline;
_a = JSII_RTTI_SYMBOL_1;
ImagePipeline[_a] = { fqn: "cdk-image-pipeline.ImagePipeline", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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