# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class BackendRole(pulumi.CustomResource):
    application_object_id: pulumi.Output[str]
    """
    Application Object ID for an existing service principal that will
    be used instead of creating dynamic service principals. If present, `azure_roles` will be ignored.
    """
    azure_roles: pulumi.Output[list]
    """
    List of Azure roles to be assigned to the generated service principal.

      * `role_id` (`str`)
      * `role_name` (`str`)
      * `scope` (`str`)
    """
    backend: pulumi.Output[str]
    """
    Path to the mounted Azure auth backend
    """
    description: pulumi.Output[str]
    """
    Human-friendly description of the mount for the backend.
    """
    max_ttl: pulumi.Output[str]
    """
    Specifies the maximum TTL for service principals generated using this role. Accepts time
    suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine max TTL time.
    """
    role: pulumi.Output[str]
    """
    Name of the Azure role
    """
    ttl: pulumi.Output[str]
    """
    Specifies the default TTL for service principals generated using this role.
    Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.
    """
    def __init__(__self__, resource_name, opts=None, application_object_id=None, azure_roles=None, backend=None, description=None, max_ttl=None, role=None, ttl=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a BackendRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_object_id: Application Object ID for an existing service principal that will
               be used instead of creating dynamic service principals. If present, `azure_roles` will be ignored.
        :param pulumi.Input[list] azure_roles: List of Azure roles to be assigned to the generated service principal.
        :param pulumi.Input[str] backend: Path to the mounted Azure auth backend
        :param pulumi.Input[str] description: Human-friendly description of the mount for the backend.
        :param pulumi.Input[str] max_ttl: Specifies the maximum TTL for service principals generated using this role. Accepts time
               suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine max TTL time.
        :param pulumi.Input[str] role: Name of the Azure role
        :param pulumi.Input[str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.

        The **azure_roles** object supports the following:

          * `role_id` (`pulumi.Input[str]`)
          * `role_name` (`pulumi.Input[str]`)
          * `scope` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['application_object_id'] = application_object_id
            __props__['azure_roles'] = azure_roles
            __props__['backend'] = backend
            __props__['description'] = description
            __props__['max_ttl'] = max_ttl
            if role is None:
                raise TypeError("Missing required property 'role'")
            __props__['role'] = role
            __props__['ttl'] = ttl
        super(BackendRole, __self__).__init__(
            'vault:azure/backendRole:BackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, application_object_id=None, azure_roles=None, backend=None, description=None, max_ttl=None, role=None, ttl=None):
        """
        Get an existing BackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_object_id: Application Object ID for an existing service principal that will
               be used instead of creating dynamic service principals. If present, `azure_roles` will be ignored.
        :param pulumi.Input[list] azure_roles: List of Azure roles to be assigned to the generated service principal.
        :param pulumi.Input[str] backend: Path to the mounted Azure auth backend
        :param pulumi.Input[str] description: Human-friendly description of the mount for the backend.
        :param pulumi.Input[str] max_ttl: Specifies the maximum TTL for service principals generated using this role. Accepts time
               suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine max TTL time.
        :param pulumi.Input[str] role: Name of the Azure role
        :param pulumi.Input[str] ttl: Specifies the default TTL for service principals generated using this role.
               Accepts time suffixed strings ("1h") or an integer number of seconds. Defaults to the system/engine default TTL time.

        The **azure_roles** object supports the following:

          * `role_id` (`pulumi.Input[str]`)
          * `role_name` (`pulumi.Input[str]`)
          * `scope` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["application_object_id"] = application_object_id
        __props__["azure_roles"] = azure_roles
        __props__["backend"] = backend
        __props__["description"] = description
        __props__["max_ttl"] = max_ttl
        __props__["role"] = role
        __props__["ttl"] = ttl
        return BackendRole(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

