# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Oidc(pulumi.CustomResource):
    issuer: pulumi.Output[str]
    """
    Issuer URL to be used in the iss claim of the token. If not set, Vault's
    `api_addr` will be used. The issuer is a case sensitive URL using the https scheme that contains
    scheme, host, and optionally, port number and path components, but no query or fragment
    components.
    """
    def __init__(__self__, resource_name, opts=None, issuer=None, __props__=None, __name__=None, __opts__=None):
        """
        Configure the [Identity Tokens Backend](https://www.vaultproject.io/docs/secrets/identity/index.html#identity-tokens).

        The Identity secrets engine is the identity management solution for Vault. It internally maintains
        the clients who are recognized by Vault.

        > **NOTE:** Each Vault server may only have one Identity Tokens Backend configuration. Multiple configurations of the resource against the same Vault server will cause a perpetual difference.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_vault as vault

        server = vault.identity.Oidc("server", issuer="https://www.acme.com")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] issuer: Issuer URL to be used in the iss claim of the token. If not set, Vault's
               `api_addr` will be used. The issuer is a case sensitive URL using the https scheme that contains
               scheme, host, and optionally, port number and path components, but no query or fragment
               components.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['issuer'] = issuer
        super(Oidc, __self__).__init__(
            'vault:identity/oidc:Oidc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, issuer=None):
        """
        Get an existing Oidc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] issuer: Issuer URL to be used in the iss claim of the token. If not set, Vault's
               `api_addr` will be used. The issuer is a case sensitive URL using the https scheme that contains
               scheme, host, and optionally, port number and path components, but no query or fragment
               components.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["issuer"] = issuer
        return Oidc(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

