## Join the Human-First AI revolution
_“We humans have .. insight that can then be mixed with powerful AI .. to help move society forward. Second, we also have to build trust directly into our technology .. And third, all of the technology we build must be inclusive and respectful to everyone.”_
<br/>— Satya Nadella, Microsoft CEO

As trail-blazers in Industrial AI, our team at Arimo-Panasonic has found Satya Nadella‘s observations to be powerful and prescient. Many hard-won lessons from the field have led us to adopt this approach which we call Human-First AI (`H1st` AI). 

Today, we‘re excited to share these ideas and concrete implementation of `H1st` AI with you and the open-source data science community!

## Learn the Key Concepts
Human-First AI (`H1st` AI) solves three critical challenges in real-world data science:

1. __Industrial AI needs human insight:__ In so many important applications, there isn‘t enough data for ML. For example, last year‘s product‘s data does not apply to this year‘s new model. Or, equipment not yet shipped obviously have no data history to speak of. `H1st` combines human knowledge and any available data to enable intelligent systems, and companies can achieve earlier time-to-market.

2. __Data scientists need human tools:__ Today‘s tools are to compete rather than to collaborate. When multiple data scientists work on the same project, they are effectively competing to see who can build the better model. `H1st` breaks a large modeling problem into smaller, easier parts. This allows true collaboration and high productivity, in ways similar to well-established software engineering methodology. 

3. __AI needs human trust:__ AI models can't be deployed when they lack user trust. AI increasingly face regulatory challenges. `H1st` supports model description and explanation at multiple layers, enabling transparent and trustworthy AI.


## Get started
`H1st` runs on Python 3.7 or above. Install with `pip3 install h1st`. For Windows, please use 64bit version and install [VS Build Tools](https://visualstudio.microsoft.com/downloads/) before installing H1st.

See the [examples/HelloWorld folder](examples/HelloWorld) for simple "Hello world" examples of using 
[H1st rule-based](examples/HelloWorld/rule_based_model.py) & [machine-learned models](examples/HelloWorld/ml_model.py) and using [H1st Graph](examples/HelloWorld/graph.py).

For a simple real-world data science example using H1st Model API, take a look at the [forecasting example](examples/Forecasting).

To fully understand H1st philosophy and power, check out the [H1st Automotive Cybersecurity Tutorial](https://h1st.ai).


## Read the Tutorials, Wiki, and API Documentation
We highly recommend following the [H1st Automotive Cybersecurity Tutorial](https://h1st.ai) as well as the quick-start examples in the [examples/HelloWorld folder](examples/HelloWorld).

See the wiki for design consideration e.g. [H1st.AI Model Explained](../../wiki/Human-First-AI-Graph-Explained), [H1st.AI Graph Explained](../../wiki/Human-First-AI-Graph-Explained).

Our full API Documentation is at [docs.h1st.ai](https://docs.h1st.ai/).

See our public [H1st.AI's roadmap](../../wiki/Human-First-AI-Roadmap).

## Join and Learn from Our Open-Source Community
We are collaborating with the open-source community. For Arimo-Panasonic, use cases include industrial applications such as Cybersecurity, Predictive Maintenance, Fault Prediction, Home Automation, Avionic & Automotive Experience Management, etc.

We'd love to see your use cases and your contributions to open-source `H1st` AI. 
