"""Platform config client."""
from pkg_resources import get_distribution

from .client import ConfigClient
from .entities import (
    ACMEEnvironment,
    ARecord,
    AWSCloudProvider,
    AWSCredentials,
    AWSStorage,
    AzureCloudProvider,
    AzureCredentials,
    AzureReplicationType,
    AzureStorage,
    AzureStorageTier,
    CloudProvider,
    Cluster,
    CredentialsConfig,
    DNSConfig,
    DockerRegistryConfig,
    EMCECSCredentials,
    GoogleCloudProvider,
    GoogleFilestoreTier,
    GoogleStorage,
    GrafanaCredentials,
    HelmRegistryConfig,
    MetricsConfig,
    MinioCredentials,
    MonitoringConfig,
    NeuroAuthConfig,
    OnPremCloudProvider,
    OpenStackCredentials,
    OrchestratorConfig,
    RegistryConfig,
    ResourcePoolType,
    ResourcePreset,
    SecretsConfig,
    SentryCredentials,
    StorageConfig,
    TPUPreset,
    TPUResource,
    VCDCloudProvider,
    VCDCredentials,
    VCDStorage,
    VolumeConfig,
)

__all__ = [
    "ConfigClient",
    "ACMEEnvironment",
    "ARecord",
    "AWSCloudProvider",
    "AWSCredentials",
    "AWSStorage",
    "AzureCloudProvider",
    "AzureCredentials",
    "AzureReplicationType",
    "AzureStorage",
    "AzureStorageTier",
    "CloudProvider",
    "Cluster",
    "CredentialsConfig",
    "DNSConfig",
    "DockerRegistryConfig",
    "EMCECSCredentials",
    "GoogleCloudProvider",
    "GoogleFilestoreTier",
    "GoogleStorage",
    "GrafanaCredentials",
    "HelmRegistryConfig",
    "MetricsConfig",
    "MinioCredentials",
    "MonitoringConfig",
    "NeuroAuthConfig",
    "OnPremCloudProvider",
    "OpenStackCredentials",
    "OrchestratorConfig",
    "RegistryConfig",
    "ResourcePoolType",
    "ResourcePreset",
    "SecretsConfig",
    "SentryCredentials",
    "StorageConfig",
    "TPUPreset",
    "TPUResource",
    "VCDCloudProvider",
    "VCDCredentials",
    "VCDStorage",
    "VolumeConfig",
]
__version__ = get_distribution(__name__).version
