"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnServer = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-07-06T19:14:28.476Z","fingerprint":"1Rmxh0STV60tK7VzOjut2vjMcHNuvI09SPOK50dT+OA="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnServerProps`
 *
 * @param properties - the TypeScript properties of a `CfnServerProps`
 *
 * @returns the result of the validation.
 */
function CfnServerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('associatePublicIpAddress', cdk.validateBoolean)(properties.associatePublicIpAddress));
    errors.collect(cdk.propertyValidator('backupId', cdk.validateString)(properties.backupId));
    errors.collect(cdk.propertyValidator('backupRetentionCount', cdk.validateNumber)(properties.backupRetentionCount));
    errors.collect(cdk.propertyValidator('customCertificate', cdk.validateString)(properties.customCertificate));
    errors.collect(cdk.propertyValidator('customDomain', cdk.validateString)(properties.customDomain));
    errors.collect(cdk.propertyValidator('customPrivateKey', cdk.validateString)(properties.customPrivateKey));
    errors.collect(cdk.propertyValidator('disableAutomatedBackup', cdk.validateBoolean)(properties.disableAutomatedBackup));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineAttributes', cdk.listValidator(CfnServer_EngineAttributePropertyValidator))(properties.engineAttributes));
    errors.collect(cdk.propertyValidator('engineModel', cdk.validateString)(properties.engineModel));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('instanceProfileArn', cdk.requiredValidator)(properties.instanceProfileArn));
    errors.collect(cdk.propertyValidator('instanceProfileArn', cdk.validateString)(properties.instanceProfileArn));
    errors.collect(cdk.propertyValidator('instanceType', cdk.requiredValidator)(properties.instanceType));
    errors.collect(cdk.propertyValidator('instanceType', cdk.validateString)(properties.instanceType));
    errors.collect(cdk.propertyValidator('keyPair', cdk.validateString)(properties.keyPair));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.requiredValidator)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('serviceRoleArn', cdk.validateString)(properties.serviceRoleArn));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnServerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server` resource
 *
 * @param properties - the TypeScript properties of a `CfnServerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server` resource.
 */
// @ts-ignore TS6133
function cfnServerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnServerPropsValidator(properties).assertSuccess();
    return {
        InstanceProfileArn: cdk.stringToCloudFormation(properties.instanceProfileArn),
        InstanceType: cdk.stringToCloudFormation(properties.instanceType),
        ServiceRoleArn: cdk.stringToCloudFormation(properties.serviceRoleArn),
        AssociatePublicIpAddress: cdk.booleanToCloudFormation(properties.associatePublicIpAddress),
        BackupId: cdk.stringToCloudFormation(properties.backupId),
        BackupRetentionCount: cdk.numberToCloudFormation(properties.backupRetentionCount),
        CustomCertificate: cdk.stringToCloudFormation(properties.customCertificate),
        CustomDomain: cdk.stringToCloudFormation(properties.customDomain),
        CustomPrivateKey: cdk.stringToCloudFormation(properties.customPrivateKey),
        DisableAutomatedBackup: cdk.booleanToCloudFormation(properties.disableAutomatedBackup),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineAttributes: cdk.listMapper(cfnServerEngineAttributePropertyToCloudFormation)(properties.engineAttributes),
        EngineModel: cdk.stringToCloudFormation(properties.engineModel),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        KeyPair: cdk.stringToCloudFormation(properties.keyPair),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnServerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceProfileArn', 'InstanceProfileArn', cfn_parse.FromCloudFormation.getString(properties.InstanceProfileArn));
    ret.addPropertyResult('instanceType', 'InstanceType', cfn_parse.FromCloudFormation.getString(properties.InstanceType));
    ret.addPropertyResult('serviceRoleArn', 'ServiceRoleArn', cfn_parse.FromCloudFormation.getString(properties.ServiceRoleArn));
    ret.addPropertyResult('associatePublicIpAddress', 'AssociatePublicIpAddress', properties.AssociatePublicIpAddress != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AssociatePublicIpAddress) : undefined);
    ret.addPropertyResult('backupId', 'BackupId', properties.BackupId != null ? cfn_parse.FromCloudFormation.getString(properties.BackupId) : undefined);
    ret.addPropertyResult('backupRetentionCount', 'BackupRetentionCount', properties.BackupRetentionCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionCount) : undefined);
    ret.addPropertyResult('customCertificate', 'CustomCertificate', properties.CustomCertificate != null ? cfn_parse.FromCloudFormation.getString(properties.CustomCertificate) : undefined);
    ret.addPropertyResult('customDomain', 'CustomDomain', properties.CustomDomain != null ? cfn_parse.FromCloudFormation.getString(properties.CustomDomain) : undefined);
    ret.addPropertyResult('customPrivateKey', 'CustomPrivateKey', properties.CustomPrivateKey != null ? cfn_parse.FromCloudFormation.getString(properties.CustomPrivateKey) : undefined);
    ret.addPropertyResult('disableAutomatedBackup', 'DisableAutomatedBackup', properties.DisableAutomatedBackup != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableAutomatedBackup) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineAttributes', 'EngineAttributes', properties.EngineAttributes != null ? cfn_parse.FromCloudFormation.getArray(CfnServerEngineAttributePropertyFromCloudFormation)(properties.EngineAttributes) : undefined);
    ret.addPropertyResult('engineModel', 'EngineModel', properties.EngineModel != null ? cfn_parse.FromCloudFormation.getString(properties.EngineModel) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('keyPair', 'KeyPair', properties.KeyPair != null ? cfn_parse.FromCloudFormation.getString(properties.KeyPair) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('subnetIds', 'SubnetIds', properties.SubnetIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::OpsWorksCM::Server`
 *
 * The `AWS::OpsWorksCM::Server` resource creates an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise configuration management server. For more information, see [Create a Chef Automate Server in AWS CloudFormation](https://docs.aws.amazon.com/opsworks/latest/userguide/opscm-create-server-cfn.html) or [Create a Puppet Enterprise Master in AWS CloudFormation](https://docs.aws.amazon.com/opsworks/latest/userguide/opspup-create-server-cfn.html) in the *AWS OpsWorks User Guide* , and [CreateServer](https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateServer.html) in the *AWS OpsWorks CM API Reference* .
 *
 * @cloudformationResource AWS::OpsWorksCM::Server
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html
 */
class CfnServer extends cdk.CfnResource {
    /**
     * Create a new `AWS::OpsWorksCM::Server`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnServer.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_opsworkscm_CfnServerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnServer);
            }
            throw error;
        }
        cdk.requireProperty(props, 'instanceProfileArn', this);
        cdk.requireProperty(props, 'instanceType', this);
        cdk.requireProperty(props, 'serviceRoleArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.instanceProfileArn = props.instanceProfileArn;
        this.instanceType = props.instanceType;
        this.serviceRoleArn = props.serviceRoleArn;
        this.associatePublicIpAddress = props.associatePublicIpAddress;
        this.backupId = props.backupId;
        this.backupRetentionCount = props.backupRetentionCount;
        this.customCertificate = props.customCertificate;
        this.customDomain = props.customDomain;
        this.customPrivateKey = props.customPrivateKey;
        this.disableAutomatedBackup = props.disableAutomatedBackup;
        this.engine = props.engine;
        this.engineAttributes = props.engineAttributes;
        this.engineModel = props.engineModel;
        this.engineVersion = props.engineVersion;
        this.keyPair = props.keyPair;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.securityGroupIds = props.securityGroupIds;
        this.serverName = props.serverName;
        this.subnetIds = props.subnetIds;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::OpsWorksCM::Server", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnServerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnServer(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnServer.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            instanceProfileArn: this.instanceProfileArn,
            instanceType: this.instanceType,
            serviceRoleArn: this.serviceRoleArn,
            associatePublicIpAddress: this.associatePublicIpAddress,
            backupId: this.backupId,
            backupRetentionCount: this.backupRetentionCount,
            customCertificate: this.customCertificate,
            customDomain: this.customDomain,
            customPrivateKey: this.customPrivateKey,
            disableAutomatedBackup: this.disableAutomatedBackup,
            engine: this.engine,
            engineAttributes: this.engineAttributes,
            engineModel: this.engineModel,
            engineVersion: this.engineVersion,
            keyPair: this.keyPair,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            securityGroupIds: this.securityGroupIds,
            serverName: this.serverName,
            subnetIds: this.subnetIds,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnServerPropsToCloudFormation(props);
    }
}
exports.CfnServer = CfnServer;
_a = JSII_RTTI_SYMBOL_1;
CfnServer[_a] = { fqn: "@aws-cdk/aws-opsworkscm.CfnServer", version: "1.163.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnServer.CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorksCM::Server";
/**
 * Determine whether the given properties match those of a `EngineAttributeProperty`
 *
 * @param properties - the TypeScript properties of a `EngineAttributeProperty`
 *
 * @returns the result of the validation.
 */
function CfnServer_EngineAttributePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "EngineAttributeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server.EngineAttribute` resource
 *
 * @param properties - the TypeScript properties of a `EngineAttributeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::OpsWorksCM::Server.EngineAttribute` resource.
 */
// @ts-ignore TS6133
function cfnServerEngineAttributePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnServer_EngineAttributePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnServerEngineAttributePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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