"""
Replace any CF-specific strategies in the database.

Revision ID: 75f69831f74f
Revises: 9b8df9661cdb
Create Date: 2021-11-12 13:14:12.745467

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '75f69831f74f'
down_revision = '9b8df9661cdb'
branch_labels = None
depends_on = None


def upgrade():
    pkg_options = sa.table('pkg_options', sa.column('strategy', sa.String))
    op.execute(
        sa.update(pkg_options)
        .where(pkg_options.c.strategy.in_(['curse_latest_alpha', 'curse_latest_beta']))
        .values(strategy='latest')
    )


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
