from argparse import ArgumentParser
from hfradarpy import __version__

def cli(args=None):
    p = ArgumentParser(
        description="Toolbox to read in High Frequency Radar (HFR) files written in CODAR Tabular Format (CTF).",
        conflict_handler='resolve'
    )
    p.add_argument(
        '-V', '--version',
        action='version',
        help='Show the conda-prefix-replacement version number and exit.',
        version="hfradarpy %s" % __version__,
    )

    args, unknown = p.parse_known_args(args)

    # do something with the args
    print("CLI template - fix me up!")

    # No return value means no error.
    # Return a value of 1 or higher to signify an error.
    # See https://docs.python.org/3/library/sys.html#sys.exit


if __name__ == '__main__':
    import sys
    cli(sys.argv[1:])
