"""Generated message classes for businesscommunications version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'businesscommunications'


class Agent(_messages.Message):
  r"""A conversational entity that represents a brand.

  Fields:
    businessMessagesAgent: Detailed agent information for Business Messages.
    displayName: Required. The name that the agent displays to users. Maximum
      40 characters. Not modifiable after agent verification.
    name: The unique identifier of the agent. Read-only. Defined by the
      platform.
    verifiedCallsAgent: Detailed agent information for Verified Calls.
    verifiedSmsAgent: Detailed agent information for Verified SMS.
  """

  businessMessagesAgent = _messages.MessageField('BusinessMessagesAgent', 1)
  displayName = _messages.StringField(2)
  name = _messages.StringField(3)
  verifiedCallsAgent = _messages.MessageField('VerifiedCallsAgent', 4)
  verifiedSmsAgent = _messages.MessageField('VerifiedSmsAgent', 5)


class AgentLaunch(_messages.Message):
  r"""Details about an agent launch.

  Fields:
    businessMessages: Launch details for a Business Messages agent.
    name: Required. The identifier for launch.
    verifiedCalls: Launch details for a Verified Calls agent.
  """

  businessMessages = _messages.MessageField('BusinessMessagesLaunch', 1)
  name = _messages.StringField(2)
  verifiedCalls = _messages.MessageField('VerifiedCallsLaunch', 3)


class AgentVerification(_messages.Message):
  r"""Details about the verification information for an agent.

  Enums:
    VerificationStateValueValuesEnum: The verification state.

  Fields:
    agentVerificationContact: Required. The contact details.
    name: Required. The identifier for verification.
    verificationState: The verification state.
  """

  class VerificationStateValueValuesEnum(_messages.Enum):
    r"""The verification state.

    Values:
      VERIFICATION_STATE_UNSPECIFIED: Unspecified state.
      VERIFICATION_STATE_UNVERIFIED: Unverified state.
      VERIFICATION_STATE_PENDING: Verification in review.
      VERIFICATION_STATE_VERIFIED: Verification complete.
    """
    VERIFICATION_STATE_UNSPECIFIED = 0
    VERIFICATION_STATE_UNVERIFIED = 1
    VERIFICATION_STATE_PENDING = 2
    VERIFICATION_STATE_VERIFIED = 3

  agentVerificationContact = _messages.MessageField('AgentVerificationContact', 1)
  name = _messages.StringField(2)
  verificationState = _messages.EnumField('VerificationStateValueValuesEnum', 3)


class AgentVerificationContact(_messages.Message):
  r"""Verification contact details for an agent.

  Fields:
    brandContactEmailAddress: Required. The email address of the brand
      representative.
    brandContactName: Required. Name of a brand representative who can verify
      the accuracy of the launch details and that the partner represents the
      brand.
    brandWebsiteUrl: Required. The public website of the brand to verify the
      domain.
    partnerEmailAddress: Required. The email address of the partner.
    partnerName: Required. The name of the partner requesting the
      verification.
  """

  brandContactEmailAddress = _messages.StringField(1)
  brandContactName = _messages.StringField(2)
  brandWebsiteUrl = _messages.StringField(3)
  partnerEmailAddress = _messages.StringField(4)
  partnerName = _messages.StringField(5)


class ApprovalDetails(_messages.Message):
  r"""Approval details composed from the state and optional additional
  information.

  Enums:
    ApprovalStateValueValuesEnum: Output only. The current approval state.

  Fields:
    approvalInfo: Output only. Additional information about the decision, if
      available.
    approvalState: Output only. The current approval state.
  """

  class ApprovalStateValueValuesEnum(_messages.Enum):
    r"""Output only. The current approval state.

    Values:
      STATE_UNSPECIFIED: Approval state unspecified.
      PENDING_APPROVAL: Pending for an approval.
      APPROVED: Approved.
      DENIED: Denied.
      PENDING_REMOVAL: Pending for a deletion.
    """
    STATE_UNSPECIFIED = 0
    PENDING_APPROVAL = 1
    APPROVED = 2
    DENIED = 3
    PENDING_REMOVAL = 4

  approvalInfo = _messages.StringField(1)
  approvalState = _messages.EnumField('ApprovalStateValueValuesEnum', 2)


class AuthorizationConfig(_messages.Message):
  r"""Configuration details for supporting OAuth on Business Messages.

  Fields:
    endpointUrl: The endpoint URL where the user logs in.
  """

  endpointUrl = _messages.StringField(1)


class BotRepresentative(_messages.Message):
  r"""Details for bot representative.

  Fields:
    botMessagingAvailability: Required. Bot messaging availability.
  """

  botMessagingAvailability = _messages.MessageField('MessagingAvailability', 1)


class Brand(_messages.Message):
  r"""A brand (business, organization, or group) that is represented by an
  agent.

  Fields:
    displayName: Required. The display name of the brand. Maximum 40
      characters.
    name: Output only. The unique identifier of the brand. Defined by the
      platform.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)


class BusinessMessagesAgent(_messages.Message):
  r"""Agent information specific to Business Messages.

  Messages:
    ConversationalSettingsValue: Required. Conversational settings for an
      agent, mapped to a locale. Locale is represented by a well-formed [IETF
      BCP 47](https://tools.ietf.org/html/bcp47) language tag.

  Fields:
    additionalAgentInteractions: Optional. Additional agent interaction
      information. Enables the agent to support multiple interaction types.
    agentTestUrl: Output only. The URL for testing the agent's conversational
      experience. Defined by the platform.
    authorizationConfig: Optional. Authorization configuration for OAuth
      support.
    conversationalSettings: Required. Conversational settings for an agent,
      mapped to a locale. Locale is represented by a well-formed [IETF BCP
      47](https://tools.ietf.org/html/bcp47) language tag.
    customAgentId: Optional. A partner-specified identifier for the agent. The
      identifier is passed alongside all messages sent to the agent.
    defaultLocale: Required. The default locale for the agent. Must match a
      locale defined in `conversationalSettings`.
    entryPointConfigs: Optional. List of entry point configurations. Not
      modifiable after agent verification.
    logoUrl: Required. Publicly available URL of the logo for the agent.
      Maximum 50 KB. Not modifiable after agent verification.
    nonLocalConfig: Optional. Configuration for non-local entry points.
    phone: Optional. The phone number for the agent to display. If not
      specified, the agent displays the phone number for the brand found in
      the [Google Knowledge Graph](https://developers.google.com/knowledge-
      graph), if any.
    primaryAgentInteraction: Required. Primary agent interaction information.
      Used when the user initiates a conversation.
    testUrls: Output only. URLs for testing the agent's conversational
      experience. Defined by the platform.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConversationalSettingsValue(_messages.Message):
    r"""Required. Conversational settings for an agent, mapped to a locale.
    Locale is represented by a well-formed [IETF BCP
    47](https://tools.ietf.org/html/bcp47) language tag.

    Messages:
      AdditionalProperty: An additional property for a
        ConversationalSettingsValue object.

    Fields:
      additionalProperties: Additional properties of type
        ConversationalSettingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConversationalSettingsValue object.

      Fields:
        key: Name of the additional property.
        value: A ConversationalSetting attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ConversationalSetting', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalAgentInteractions = _messages.MessageField('SupportedAgentInteraction', 1, repeated=True)
  agentTestUrl = _messages.StringField(2)
  authorizationConfig = _messages.MessageField('AuthorizationConfig', 3)
  conversationalSettings = _messages.MessageField('ConversationalSettingsValue', 4)
  customAgentId = _messages.StringField(5)
  defaultLocale = _messages.StringField(6)
  entryPointConfigs = _messages.MessageField('BusinessMessagesEntryPointConfig', 7, repeated=True)
  logoUrl = _messages.StringField(8)
  nonLocalConfig = _messages.MessageField('NonLocalConfig', 9)
  phone = _messages.MessageField('Phone', 10)
  primaryAgentInteraction = _messages.MessageField('SupportedAgentInteraction', 11)
  testUrls = _messages.MessageField('TestUrl', 12, repeated=True)


class BusinessMessagesCapability(_messages.Message):
  r"""Business Messages capabilities

  Fields:
    webhookUrl: Required. The webhook URL where the messages are delivered.
  """

  webhookUrl = _messages.StringField(1)


class BusinessMessagesEntryPointConfig(_messages.Message):
  r"""The entry point configuration for an agent.

  Enums:
    AllowedEntryPointValueValuesEnum: Required. The Google surfaces the agent
      is enabled to appear on.

  Fields:
    allowedEntryPoint: Required. The Google surfaces the agent is enabled to
      appear on.
  """

  class AllowedEntryPointValueValuesEnum(_messages.Enum):
    r"""Required. The Google surfaces the agent is enabled to appear on.

    Values:
      ENTRY_POINT_UNSPECIFIED: Unspecified entry point.
      LOCATION: Enable locations for this agent.
      NON_LOCAL: Enable Business Messages for non-local entry points.
    """
    ENTRY_POINT_UNSPECIFIED = 0
    LOCATION = 1
    NON_LOCAL = 2

  allowedEntryPoint = _messages.EnumField('AllowedEntryPointValueValuesEnum', 1)


class BusinessMessagesEntryPointLaunch(_messages.Message):
  r"""Details about Business Messages agent launch for each entry point.

  Enums:
    EntryPointValueValuesEnum: Entry point for which launch information is
      provided.
    LaunchStateValueValuesEnum: The launch state for entry point.

  Fields:
    entryPoint: Entry point for which launch information is provided.
    launchState: The launch state for entry point.
    regionCodes: List of [CLDR region codes](https://www.iana.org/assignments
      /language-subtag-registry/language-subtag-registry) for countries where
      the agent should launch `NON_LOCAL` entry points. Required for
      `NON_LOCAL` entry points. This must be a subset of the region codes
      specified in the agent's `nonLocalConfig`.
  """

  class EntryPointValueValuesEnum(_messages.Enum):
    r"""Entry point for which launch information is provided.

    Values:
      ENTRY_POINT_UNSPECIFIED: Unspecified entry point.
      LOCATION: Enable locations for this agent.
      NON_LOCAL: Enable Business Messages for non-local entry points.
    """
    ENTRY_POINT_UNSPECIFIED = 0
    LOCATION = 1
    NON_LOCAL = 2

  class LaunchStateValueValuesEnum(_messages.Enum):
    r"""The launch state for entry point.

    Values:
      LAUNCH_STATE_UNSPECIFIED: Unspecified state.
      LAUNCH_STATE_UNLAUNCHED: Entity is unlaunched.
      LAUNCH_STATE_PENDING: Launch in review.
      LAUNCH_STATE_LAUNCHED: Launched.
      LAUNCH_STATE_REJECTED: Launch is rejected.
      LAUNCH_STATE_SUSPENDED: Launch is suspended.
      LAUNCH_STATE_PENDING_UNLAUNCH: Unlaunch in review.
    """
    LAUNCH_STATE_UNSPECIFIED = 0
    LAUNCH_STATE_UNLAUNCHED = 1
    LAUNCH_STATE_PENDING = 2
    LAUNCH_STATE_LAUNCHED = 3
    LAUNCH_STATE_REJECTED = 4
    LAUNCH_STATE_SUSPENDED = 5
    LAUNCH_STATE_PENDING_UNLAUNCH = 6

  entryPoint = _messages.EnumField('EntryPointValueValuesEnum', 1)
  launchState = _messages.EnumField('LaunchStateValueValuesEnum', 2)
  regionCodes = _messages.StringField(3, repeated=True)


class BusinessMessagesLaunch(_messages.Message):
  r"""Details about business messages agent launch.

  Messages:
    LaunchDetailsValue: Required. Launch details for each supported entry
      point. Key represented by BusinessMessagesEntryPointConfig.EntryPoint

  Fields:
    launchDetails: Required. Launch details for each supported entry point.
      Key represented by BusinessMessagesEntryPointConfig.EntryPoint
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LaunchDetailsValue(_messages.Message):
    r"""Required. Launch details for each supported entry point. Key
    represented by BusinessMessagesEntryPointConfig.EntryPoint

    Messages:
      AdditionalProperty: An additional property for a LaunchDetailsValue
        object.

    Fields:
      additionalProperties: Additional properties of type LaunchDetailsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LaunchDetailsValue object.

      Fields:
        key: Name of the additional property.
        value: A BusinessMessagesEntryPointLaunch attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('BusinessMessagesEntryPointLaunch', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  launchDetails = _messages.MessageField('LaunchDetailsValue', 1)


class BusinesscommunicationsBrandsAgentsCreateRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsCreateRequest object.

  Fields:
    agent: A Agent resource to be passed as the request body.
    parent: Required. The unique identifier of the brand the agent represents.
      If the brand identifier is "1234", this parameter is "brands/1234".
  """

  agent = _messages.MessageField('Agent', 1)
  parent = _messages.StringField(2, required=True)


class BusinesscommunicationsBrandsAgentsDeleteRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsDeleteRequest object.

  Fields:
    name: Required. The unique identifier of the agent. If the brand
      identifier is "1234" and the agent identifier is "5678", this parameter
      resolves to "brands/1234/agents/5668".
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsAgentsGetLaunchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsGetLaunchRequest object.

  Fields:
    name: Required. The unique identifier of the agent launch.
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsAgentsGetRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsGetRequest object.

  Fields:
    name: Required. The unique identifier of the agent. If the brand
      identifier is "1234" and the agent identifier is "5678", this parameter
      resolves to "brands/1234/agents/5668".
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsAgentsGetVerificationRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsGetVerificationRequest object.

  Fields:
    name: Required. The unique identifier of the brand and agent verification.
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsAgentsListRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsListRequest object.

  Fields:
    pageSize: Specify the maximum number of results to be returned by the
      server. The server may further constrain the maximum number of results
      returned in a single page. If the page_size is 0, the server will decide
      the number of results to be returned.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. The unique identifier of the brand. If the brand
      identifier is "1234", this parameter resolves to "brands/1234".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BusinesscommunicationsBrandsAgentsPatchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsPatchRequest object.

  Fields:
    agent: A Agent resource to be passed as the request body.
    name: The unique identifier of the agent. Read-only. Defined by the
      platform.
    updateMask: The update mask applies to the resource. For the FieldMask
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  agent = _messages.MessageField('Agent', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BusinesscommunicationsBrandsAgentsRequestLaunchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsRequestLaunchRequest object.

  Fields:
    name: Required. The unique identifier of the agent. If the brand
      identifier is "1234" and the agent identifier is "5678", this parameter
      resolves to "brands/1234/agents/5678".
    requestAgentLaunchRequest: A RequestAgentLaunchRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  requestAgentLaunchRequest = _messages.MessageField('RequestAgentLaunchRequest', 2)


class BusinesscommunicationsBrandsAgentsRequestVerificationRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsRequestVerificationRequest object.

  Fields:
    name: Required. The unique identifier of the brand and agent.
    requestAgentVerificationRequest: A RequestAgentVerificationRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  requestAgentVerificationRequest = _messages.MessageField('RequestAgentVerificationRequest', 2)


class BusinesscommunicationsBrandsAgentsUpdateLaunchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsUpdateLaunchRequest object.

  Fields:
    agentLaunch: A AgentLaunch resource to be passed as the request body.
    name: Required. The identifier for launch.
    updateMask: The update mask applies to the resource. For the FieldMask
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  agentLaunch = _messages.MessageField('AgentLaunch', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BusinesscommunicationsBrandsAgentsUpdateVerificationRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsAgentsUpdateVerificationRequest object.

  Fields:
    agentVerification: A AgentVerification resource to be passed as the
      request body.
    name: Required. The identifier for verification.
    updateMask: The update mask applies to the resource. For the FieldMask
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  agentVerification = _messages.MessageField('AgentVerification', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BusinesscommunicationsBrandsDeleteRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsDeleteRequest object.

  Fields:
    force: If true, any agents and locations associated with this brand are
      also deleted.
    name: Required. The unique identifier of the brand. If the brand
      identifier is "1234", this parameter resolves to "brands/1234".
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class BusinesscommunicationsBrandsGetRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsGetRequest object.

  Fields:
    name: Required. The unique identifier of the brand. If the brand
      identifier is "1234", this parameter resolves to "brands/1234".
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsListRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsListRequest object.

  Fields:
    pageSize: Specify the maximum number of results to be returned by the
      server. The server may further constrain the maximum number of results
      returned in a single page. If the page_size is 0, the server will decide
      the number of results to be returned.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)


class BusinesscommunicationsBrandsLocationsCreateRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsCreateRequest object.

  Fields:
    location: A Location resource to be passed as the request body.
    parent: Required. The unique identifier of the brand associated with the
      location. If the brand identifier is "1234", this parameter resolves to
      "brands/1234".
  """

  location = _messages.MessageField('Location', 1)
  parent = _messages.StringField(2, required=True)


class BusinesscommunicationsBrandsLocationsDeleteRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsDeleteRequest object.

  Fields:
    name: Required. The unique identifier of the location. If the brand
      identifier is "1234" and the location identifier is "5678", this
      parameter resolves to "brands/1234/locations/5678".
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsLocationsGetLaunchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsGetLaunchRequest object.

  Fields:
    name: Required. The unique identifier of the location launch.
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsLocationsGetRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsGetRequest object.

  Fields:
    name: Required. The unique identifier of the location. If the brand
      identifier is "1234" and the location identifier is "5678", this
      parameter resolves to "brands/1234/locations/5678".
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsLocationsGetVerificationRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsGetVerificationRequest object.

  Fields:
    name: Required. The unique identifier of the location verification.
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsBrandsLocationsListRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsListRequest object.

  Fields:
    pageSize: The maximum number of results to be returned by the server. The
      server may further constrain the maximum number of results returned in a
      single page. If the page_size is 0, the server will decide the number of
      results to be returned.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: Required. The unique identifier of the brand. If the brand
      identifier is "1234", this parameter resolves to "brands/1234".
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BusinesscommunicationsBrandsLocationsPatchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsPatchRequest object.

  Fields:
    location: A Location resource to be passed as the request body.
    name: The unique identifier of the location. Read-only. Defined by the
      platform.
    updateMask: The update mask applies to the resource. For the FieldMask
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  location = _messages.MessageField('Location', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BusinesscommunicationsBrandsLocationsRequestLaunchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsRequestLaunchRequest object.

  Fields:
    name: Required. The unique identifier of the location. If the brand
      identifier is "1234" and the location identifier is "5678", this
      parameter resolves to "brands/1234/locations/5678".
    requestLocationLaunchRequest: A RequestLocationLaunchRequest resource to
      be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  requestLocationLaunchRequest = _messages.MessageField('RequestLocationLaunchRequest', 2)


class BusinesscommunicationsBrandsLocationsRequestVerificationRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsRequestVerificationRequest
  object.

  Fields:
    name: Required. The unique identifier of the location. If the brand
      identifier is "1234" and the location identifier is "5678", this
      parameter resolves to "brands/1234/locations/5678".
    requestLocationVerificationRequest: A RequestLocationVerificationRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  requestLocationVerificationRequest = _messages.MessageField('RequestLocationVerificationRequest', 2)


class BusinesscommunicationsBrandsLocationsUpdateLaunchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsLocationsUpdateLaunchRequest object.

  Fields:
    locationLaunch: A LocationLaunch resource to be passed as the request
      body.
    name: Required. The identifier for launch.
    updateMask: The update mask applies to the resource. For the FieldMask
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  locationLaunch = _messages.MessageField('LocationLaunch', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BusinesscommunicationsBrandsPatchRequest(_messages.Message):
  r"""A BusinesscommunicationsBrandsPatchRequest object.

  Fields:
    brand: A Brand resource to be passed as the request body.
    name: Output only. The unique identifier of the brand. Defined by the
      platform.
    updateMask: The update mask applies to the resource. For the FieldMask
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  brand = _messages.MessageField('Brand', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class BusinesscommunicationsPartnersGetRequest(_messages.Message):
  r"""A BusinesscommunicationsPartnersGetRequest object.

  Fields:
    name: Optional. The unique identifier of the partner.
  """

  name = _messages.StringField(1, required=True)


class BusinesscommunicationsPartnersPatchRequest(_messages.Message):
  r"""A BusinesscommunicationsPartnersPatchRequest object.

  Fields:
    name: Output only. The unique identifier of the partner. Defined by the
      platform.
    partner: A Partner resource to be passed as the request body.
    updateMask: The update mask applies to the resource. For the FieldMask
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  name = _messages.StringField(1, required=True)
  partner = _messages.MessageField('Partner', 2)
  updateMask = _messages.StringField(3)


class CallReason(_messages.Message):
  r"""Call reason with approval information.

  Fields:
    approvalDetails: Output only. Approval details; each call reason must be
      approved before use.
    text: Immutable. The actual text of the call reason.
  """

  approvalDetails = _messages.MessageField('ApprovalDetails', 1)
  text = _messages.StringField(2)


class ContactOption(_messages.Message):
  r"""Contact details displayed in addition to the messaging button.

  Enums:
    OptionsValueListEntryValuesEnum:

  Fields:
    options: The list of contact options available for the specified URL.
    url: The URL that contact options are available for.
  """

  class OptionsValueListEntryValuesEnum(_messages.Enum):
    r"""OptionsValueListEntryValuesEnum enum type.

    Values:
      OPTION_UNSPECIFIED: Unspecified
      WEB_CHAT: Web Chat option.
      PHONE: Phone option.
      EMAIL: Email option.
      FAQS: FAQ option.
      TWITTER: Twitter option.
      WHATSAPP: Whatsapp option.
    """
    OPTION_UNSPECIFIED = 0
    WEB_CHAT = 1
    PHONE = 2
    EMAIL = 3
    FAQS = 4
    TWITTER = 5
    WHATSAPP = 6

  options = _messages.EnumField('OptionsValueListEntryValuesEnum', 1, repeated=True)
  url = _messages.StringField(2)


class ConversationStarters(_messages.Message):
  r"""Suggested replies shown to users when they enter a conversation with the
  agent for the first time.

  Fields:
    suggestion: Optional. Suggestion at the beginning of a conversation.
  """

  suggestion = _messages.MessageField('Suggestion', 1)


class ConversationalSetting(_messages.Message):
  r"""Conversational setting for an agent or location. Each locale has its own
  conversational settings. Locale is represented by a well-formed [IETF BCP
  47](https://tools.ietf.org/html/bcp47) language tag.

  Fields:
    conversationStarters: Optional. Details about the agent's conversation
      starters. Maximum 5.
    offlineMessage: Optional. Details about the offline message for an agent.
    privacyPolicy: Required. Details about the agent's privacy policy.
    welcomeMessage: Required. Details about the welcome message for an agent.
  """

  conversationStarters = _messages.MessageField('ConversationStarters', 1, repeated=True)
  offlineMessage = _messages.MessageField('OfflineMessage', 2)
  privacyPolicy = _messages.MessageField('PrivacyPolicy', 3)
  welcomeMessage = _messages.MessageField('WelcomeMessage', 4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON
  representation for `Empty` is empty JSON object `{}`.
  """



class Hours(_messages.Message):
  r"""A range of hours that messaging is available.

  Enums:
    EndDayValueValuesEnum: Required. End day. Includes the specified day.
    StartDayValueValuesEnum: Required. Start day.

  Fields:
    endDay: Required. End day. Includes the specified day.
    endTime: Required. End time for each day within the day-of-week range.
    startDay: Required. Start day.
    startTime: Required. Start time for each day within the day-of-week range.
    timeZone: Required. The [IANA time zone](https://www.iana.org/time-zones)
      for the hours. For example, "America/Los_Angeles".
  """

  class EndDayValueValuesEnum(_messages.Enum):
    r"""Required. End day. Includes the specified day.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class StartDayValueValuesEnum(_messages.Enum):
    r"""Required. Start day.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  endDay = _messages.EnumField('EndDayValueValuesEnum', 1)
  endTime = _messages.MessageField('TimeOfDay', 2)
  startDay = _messages.EnumField('StartDayValueValuesEnum', 3)
  startTime = _messages.MessageField('TimeOfDay', 4)
  timeZone = _messages.StringField(5)


class HumanRepresentative(_messages.Message):
  r"""Details for human representative.

  Fields:
    humanMessagingAvailability: Required. Human messaging availability.
  """

  humanMessagingAvailability = _messages.MessageField('MessagingAvailability', 1)


class ListAgentsResponse(_messages.Message):
  r"""A list of agents.

  Fields:
    agents: List of agent information.
    nextPageToken: The pagination token to retrieve the next page of results.
      If the value is "", it means no further results for the request.
  """

  agents = _messages.MessageField('Agent', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListBrandsResponse(_messages.Message):
  r"""A list of brands.

  Fields:
    brands: List of brand information.
    nextPageToken: The pagination token to retrieve the next page of results.
      If the value is "", it means no further results for the request.
  """

  brands = _messages.MessageField('Brand', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""A list of locations.

  Fields:
    locations: List of locations.
    nextPageToken: The pagination token to retrieve the next page of results.
      If the value is "", it means no further results for the request.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Location(_messages.Message):
  r"""Information about a physical location of a brand.

  Messages:
    ConversationalSettingsValue: Optional. Conversational settings for an
      location, mapped to a locale. Locale is represented by a well-formed
      [IETF BCP 47](https://tools.ietf.org/html/bcp47) language tag.

  Fields:
    agent: Required. The name of the agent associated with the location. If
      the brand identifier is "1234" and the agent identifier is "5678", this
      field resolves to "brands/1234/agents/5678".
    conversationalSettings: Optional. Conversational settings for an location,
      mapped to a locale. Locale is represented by a well-formed [IETF BCP
      47](https://tools.ietf.org/html/bcp47) language tag.
    defaultLocale: Required. The default locale for the location.
    locationEntryPointConfigs: Required. List of entry point configurations
      for locations. Not modifiable after being available to users through an
      agent.
    locationTestUrl: Output only. The URL for testing the location's
      conversational experience. Defined by the platform.
    name: The unique identifier of the location. Read-only. Defined by the
      platform.
    placeId: Required. The [Place ID](https://developers.google.com/places
      /place-id), or unique identifier used in Google Maps, for the location.
      Not modifiable after being available to users through an agent.
    testUrls: Output only. URLs for testing the location's conversational
      experience. Defined by the platform.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConversationalSettingsValue(_messages.Message):
    r"""Optional. Conversational settings for an location, mapped to a locale.
    Locale is represented by a well-formed [IETF BCP
    47](https://tools.ietf.org/html/bcp47) language tag.

    Messages:
      AdditionalProperty: An additional property for a
        ConversationalSettingsValue object.

    Fields:
      additionalProperties: Additional properties of type
        ConversationalSettingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConversationalSettingsValue object.

      Fields:
        key: Name of the additional property.
        value: A ConversationalSetting attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ConversationalSetting', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  agent = _messages.StringField(1)
  conversationalSettings = _messages.MessageField('ConversationalSettingsValue', 2)
  defaultLocale = _messages.StringField(3)
  locationEntryPointConfigs = _messages.MessageField('LocationEntryPointConfig', 4, repeated=True)
  locationTestUrl = _messages.StringField(5)
  name = _messages.StringField(6)
  placeId = _messages.StringField(7)
  testUrls = _messages.MessageField('TestUrl', 8, repeated=True)


class LocationEntryPointConfig(_messages.Message):
  r"""The entry point configuration for a location.

  Enums:
    AllowedEntryPointValueValuesEnum: Required. The Google surfaces the
      location is enabled to appear on.

  Fields:
    allowedEntryPoint: Required. The Google surfaces the location is enabled
      to appear on.
  """

  class AllowedEntryPointValueValuesEnum(_messages.Enum):
    r"""Required. The Google surfaces the location is enabled to appear on.

    Values:
      ENTRY_POINT_UNSPECIFIED: Unspecified entry point.
      PLACESHEET: Surface that displays when users search for a business
        location on Google Search.
      MAPS_TACTILE: Surface that displays when users search for a business
        location on Google Maps.
    """
    ENTRY_POINT_UNSPECIFIED = 0
    PLACESHEET = 1
    MAPS_TACTILE = 2

  allowedEntryPoint = _messages.EnumField('AllowedEntryPointValueValuesEnum', 1)


class LocationLaunch(_messages.Message):
  r"""Details about a location launch.

  Enums:
    LaunchStateValueValuesEnum: The launch state.

  Fields:
    launchState: The launch state.
    name: Required. The identifier for launch.
  """

  class LaunchStateValueValuesEnum(_messages.Enum):
    r"""The launch state.

    Values:
      LAUNCH_STATE_UNSPECIFIED: Unspecified state.
      LAUNCH_STATE_UNLAUNCHED: Entity is unlaunched.
      LAUNCH_STATE_PENDING: Launch in review.
      LAUNCH_STATE_LAUNCHED: Launched.
      LAUNCH_STATE_REJECTED: Launch is rejected.
      LAUNCH_STATE_SUSPENDED: Launch is suspended.
      LAUNCH_STATE_PENDING_UNLAUNCH: Unlaunch in review.
    """
    LAUNCH_STATE_UNSPECIFIED = 0
    LAUNCH_STATE_UNLAUNCHED = 1
    LAUNCH_STATE_PENDING = 2
    LAUNCH_STATE_LAUNCHED = 3
    LAUNCH_STATE_REJECTED = 4
    LAUNCH_STATE_SUSPENDED = 5
    LAUNCH_STATE_PENDING_UNLAUNCH = 6

  launchState = _messages.EnumField('LaunchStateValueValuesEnum', 1)
  name = _messages.StringField(2)


class LocationVerification(_messages.Message):
  r"""Details about the verification information for a location.

  Enums:
    VerificationStateValueValuesEnum: The verification state.

  Fields:
    name: Required. The identifier for verification.
    verificationState: The verification state.
  """

  class VerificationStateValueValuesEnum(_messages.Enum):
    r"""The verification state.

    Values:
      VERIFICATION_STATE_UNSPECIFIED: Unspecified state.
      VERIFICATION_STATE_UNVERIFIED: Unverified state.
      VERIFICATION_STATE_PENDING: Verification in review.
      VERIFICATION_STATE_VERIFIED: Verification complete.
    """
    VERIFICATION_STATE_UNSPECIFIED = 0
    VERIFICATION_STATE_UNVERIFIED = 1
    VERIFICATION_STATE_PENDING = 2
    VERIFICATION_STATE_VERIFIED = 3

  name = _messages.StringField(1)
  verificationState = _messages.EnumField('VerificationStateValueValuesEnum', 2)


class MessagingAvailability(_messages.Message):
  r"""The hours of each day of the week that messaging is available. You can
  group hours for multiple days together. For example, * 08:00\u201316:00 hrs
  PDT Monday\u2013Wednesday * 10:00\u201314:00 hrs PDT Thursday\u2013Friday *
  15:00\u201318:00 hrs PDT Thursday\u2013Friday * 10:00\u201314:00 hrs PDT
  Saturday\u2013Saturday If there are gaps in availability, such as no
  specified availability on Sunday, messaging is unavailable during those
  gaps.

  Fields:
    hours: Required. Hours of messaging availability.
  """

  hours = _messages.MessageField('Hours', 1, repeated=True)


class NonLocalConfig(_messages.Message):
  r"""Configuration to enable non-local entry points.

  Fields:
    callDeflectionPhoneNumbers: List of phone numbers for call deflection.
    contactOption: Contact information for the agent that displays with the
      messaging button.
    enabledDomains: Domains enabled to host the Business Messages widget.
    phoneNumber: Agent's phone number. Overrides the `phone` field for
      conversations started from non-local entry points.
    regionCodes: Required. List of [CLDR region
      codes](https://www.iana.org/assignments/language-subtag-registry
      /language-subtag-registry) for countries where the agent is allowed to
      launch `NON_LOCAL` entry points. Required for `NON_LOCAL` entry points.
  """

  callDeflectionPhoneNumbers = _messages.MessageField('Phone', 1, repeated=True)
  contactOption = _messages.MessageField('ContactOption', 2)
  enabledDomains = _messages.StringField(3, repeated=True)
  phoneNumber = _messages.MessageField('Phone', 4)
  regionCodes = _messages.StringField(5, repeated=True)


class OfflineMessage(_messages.Message):
  r"""The greeting shown to users when they enter a conversation with the
  agent outside the chat hours.

  Fields:
    text: The text of the offline message.
  """

  text = _messages.StringField(1)


class OpenUrlAction(_messages.Message):
  r"""Opens the specified URL.

  Fields:
    url: URL
  """

  url = _messages.StringField(1)


class Partner(_messages.Message):
  r"""Partner that is onboarded with a supported product.

  Fields:
    company: Optional. The company name of the partner.
    contactEmails: Optional. The list of contact emails.
    displayName: Required. The display name of the partner.
    name: Output only. The unique identifier of the partner. Defined by the
      platform.
    productCapabilities: The product capabilities of the partner.
  """

  company = _messages.StringField(1)
  contactEmails = _messages.StringField(2, repeated=True)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  productCapabilities = _messages.MessageField('ProductCapability', 5, repeated=True)


class Phone(_messages.Message):
  r"""Phone number.

  Fields:
    number: Required. Phone number in E.164 format. For example,
      "+12223334444".
  """

  number = _messages.StringField(1)


class PrivacyPolicy(_messages.Message):
  r"""Privacy policy details for an agent.

  Fields:
    url: Required. The URL for the privacy policy.
  """

  url = _messages.StringField(1)


class ProductCapability(_messages.Message):
  r"""The product capabilities that the partner supports.

  Enums:
    ProductValueValuesEnum: The product supported by the partner.

  Fields:
    businessMessagesCapability: Business Messages capability.
    product: The product supported by the partner.
    verifiedSmsCapability: Verified SMS capability.
  """

  class ProductValueValuesEnum(_messages.Enum):
    r"""The product supported by the partner.

    Values:
      PRODUCT_UNSPECIFIED: Unspecified product.
      BUSINESS_MESSAGES: Business Messages product.
      VERIFIED_SMS: Verified SMS product.
    """
    PRODUCT_UNSPECIFIED = 0
    BUSINESS_MESSAGES = 1
    VERIFIED_SMS = 2

  businessMessagesCapability = _messages.MessageField('BusinessMessagesCapability', 1)
  product = _messages.EnumField('ProductValueValuesEnum', 2)
  verifiedSmsCapability = _messages.MessageField('VerifiedSmsCapability', 3)


class RequestAgentLaunchRequest(_messages.Message):
  r"""Request to launch an agent.

  Fields:
    agentLaunch: Required. The agent launch to create. Name and Launch status
      are ignored.
  """

  agentLaunch = _messages.MessageField('AgentLaunch', 1)


class RequestAgentVerificationRequest(_messages.Message):
  r"""Request to begin business information verification for an agent.

  Fields:
    agentVerificationContact: Required. Verification contact details for the
      agent.
  """

  agentVerificationContact = _messages.MessageField('AgentVerificationContact', 1)


class RequestLocationLaunchRequest(_messages.Message):
  r"""Request to launch a location."""


class RequestLocationVerificationRequest(_messages.Message):
  r"""Request to begin business information verification for a location."""


class Sender(_messages.Message):
  r"""Sender IDs and the countries they operate in.

  Fields:
    countryCode: A country the sender ID operates in as an [ISO 3166 Alpha-2
      country code](https://www.iso.org/obp/ui/#search/code/). For example,
      "US" for the United States of America.
    senderId: A sender ID-a long code (E.164 format), short code, national
      code, or alphanumeric code-associated with the agent that can send SMS
      messages.
  """

  countryCode = _messages.StringField(1)
  senderId = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class SuggestedAction(_messages.Message):
  r"""When tapped, initiates the corresponding native action on the device.

  Fields:
    openUrlAction: Opens the specified URL.
    postbackData: The string that the agent receives when a user taps the
      suggested action.
    text: Text that is shown in the suggested action. Maximum 35 characters.
  """

  openUrlAction = _messages.MessageField('OpenUrlAction', 1)
  postbackData = _messages.StringField(2)
  text = _messages.StringField(3)


class SuggestedReply(_messages.Message):
  r"""When tapped, sends the text reply back to the agent.

  Fields:
    postbackData: Optional. The string the agent receives when the user taps
      the suggested reply.
    text: Required. Text that is shown in the suggested reply and sent back to
      the agent when the user taps it. Maximum 35 characters.
  """

  postbackData = _messages.StringField(1)
  text = _messages.StringField(2)


class Suggestion(_messages.Message):
  r"""A suggested reply.

  Fields:
    action: A suggested action that initiates a native action on the device.
    reply: Users can tap a suggested reply to send the text back to the agent
      as a reply.
  """

  action = _messages.MessageField('SuggestedAction', 1)
  reply = _messages.MessageField('SuggestedReply', 2)


class SupportedAgentInteraction(_messages.Message):
  r"""Interactions supported by an agent.

  Enums:
    InteractionTypeValueValuesEnum: Required. The type of interaction
      supported by the agent.

  Fields:
    botRepresentative: Bot representative details.
    humanRepresentative: Human representative details.
    interactionType: Required. The type of interaction supported by the agent.
  """

  class InteractionTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of interaction supported by the agent.

    Values:
      INTERACTION_TYPE_UNSPECIFIED: Unspecified interaction.
      BOT: Bot interaction.
      HUMAN: Human interaction.
    """
    INTERACTION_TYPE_UNSPECIFIED = 0
    BOT = 1
    HUMAN = 2

  botRepresentative = _messages.MessageField('BotRepresentative', 1)
  humanRepresentative = _messages.MessageField('HumanRepresentative', 2)
  interactionType = _messages.EnumField('InteractionTypeValueValuesEnum', 3)


class TestUrl(_messages.Message):
  r"""Test intent for supported conversational surfaces.

  Enums:
    SurfaceValueValuesEnum: The surface for the conversation.

  Fields:
    surface: The surface for the conversation.
    url: The test url for launching conversation.
  """

  class SurfaceValueValuesEnum(_messages.Enum):
    r"""The surface for the conversation.

    Values:
      SURFACE_UNSPECIFIED: Unspecified surface.
      SURFACE_ANDROID_WEB: Android web surface.
      SURFACE_ANDROID_MAPS: Android Google Maps surface.
      SURFACE_IOS_MAPS: iOS Google Maps surface.
    """
    SURFACE_UNSPECIFIED = 0
    SURFACE_ANDROID_WEB = 1
    SURFACE_ANDROID_MAPS = 2
    SURFACE_IOS_MAPS = 3

  surface = _messages.EnumField('SurfaceValueValuesEnum', 1)
  url = _messages.StringField(2)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may
      choose to allow the value "24:00:00" for scenarios like business closing
      time.
    minutes: Minutes of hour of day. Must be from 0 to 59.
    nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An
      API may allow the value 60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class VerifiedCallsAgent(_messages.Message):
  r"""Agent information specifically related to Verified Calls.

  Fields:
    callReasons: Required. Call reasons that this agent may use when placing a
      verified call. Only add / remove actions are allowed. Each action will
      be reviewed before the change takes place.
    logoUrl: Required. Publicly available URL of the agent logo to display
      with a verified call. Maximum 50 KB. Not modifiable after agent
      verification.
    phones: Required. Phone numbers that this agent may use when placing a
      verified call. Only add / remove actions are allowed. Each action will
      be reviewed before the change takes place.
  """

  callReasons = _messages.MessageField('CallReason', 1, repeated=True)
  logoUrl = _messages.StringField(2)
  phones = _messages.MessageField('VerifiedCallsPhone', 3, repeated=True)


class VerifiedCallsLaunch(_messages.Message):
  r"""Details about Verified Calls agent launch.

  Enums:
    LaunchStateValueValuesEnum: The launch state.

  Fields:
    launchState: The launch state.
  """

  class LaunchStateValueValuesEnum(_messages.Enum):
    r"""The launch state.

    Values:
      LAUNCH_STATE_UNSPECIFIED: Unspecified state.
      LAUNCH_STATE_UNLAUNCHED: Entity is unlaunched.
      LAUNCH_STATE_PENDING: Launch in review.
      LAUNCH_STATE_LAUNCHED: Launched.
      LAUNCH_STATE_REJECTED: Launch is rejected.
      LAUNCH_STATE_SUSPENDED: Launch is suspended.
      LAUNCH_STATE_PENDING_UNLAUNCH: Unlaunch in review.
    """
    LAUNCH_STATE_UNSPECIFIED = 0
    LAUNCH_STATE_UNLAUNCHED = 1
    LAUNCH_STATE_PENDING = 2
    LAUNCH_STATE_LAUNCHED = 3
    LAUNCH_STATE_REJECTED = 4
    LAUNCH_STATE_SUSPENDED = 5
    LAUNCH_STATE_PENDING_UNLAUNCH = 6

  launchState = _messages.EnumField('LaunchStateValueValuesEnum', 1)


class VerifiedCallsPhone(_messages.Message):
  r"""Phone number with approval information.

  Fields:
    approvalDetails: Output only. Approval details, each phone number must be
      approved before use.
    number: Immutable. Phone number in E.164 format i.e. +18888888888
  """

  approvalDetails = _messages.MessageField('ApprovalDetails', 1)
  number = _messages.StringField(2)


class VerifiedSmsAgent(_messages.Message):
  r"""Agent information specific to Verified SMS.

  Fields:
    description: Required. Description about the registered agent. The
      description is visible to end users. Maximum 100 characters.
    logoUrl: Required. The agent logo. Maximum 50 KB.
    senders: The list of Sender IDs for the Verified SMS agent.
  """

  description = _messages.StringField(1)
  logoUrl = _messages.StringField(2)
  senders = _messages.MessageField('Sender', 3, repeated=True)


class VerifiedSmsCapability(_messages.Message):
  r"""Verified SMS capabilities

  Fields:
    webhookUrl: Required. The webhook URL where the Verified SMS callbacks are
      delivered.
  """

  webhookUrl = _messages.StringField(1)


class WelcomeMessage(_messages.Message):
  r"""The greeting shown to users when they enter a conversation with the
  agent for the first time.

  Fields:
    text: Required. The text of the welcome message.
  """

  text = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
