import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRouteConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#description ComputeRoute#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The destination range of outgoing packets that this route applies to. Only IPv4 is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#dest_range ComputeRoute#dest_range}
     *
     * @stability stable
     */
    readonly destRange: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#name ComputeRoute#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The network that this route applies to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#network ComputeRoute#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * URL to a gateway that should handle matching packets.
     *
     * Currently, you can only specify the internet gateway, using a full or
     * partial valid URL:
     * 'https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway'
     * 'projects/project/global/gateways/default-internet-gateway'
     * 'global/gateways/default-internet-gateway'
     * The string 'default-internet-gateway'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_gateway ComputeRoute#next_hop_gateway}
     *
     * @stability stable
     */
    readonly nextHopGateway?: string;
    /**
     * The IP address or URL to a forwarding rule of type loadBalancingScheme=INTERNAL that should handle matching packets.
     *
     * With the GA provider you can only specify the forwarding
     * rule as a partial or full URL. For example, the following
     * are all valid values:
     * 10.128.0.56
     * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
     * regions/region/forwardingRules/forwardingRule
     *
     * When the beta provider, you can also specify the IP address
     * of a forwarding rule from the same VPC or any peered VPC.
     *
     * Note that this can only be used when the destinationRange is
     * a public (non-RFC 1918) IP CIDR range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_ilb ComputeRoute#next_hop_ilb}
     *
     * @stability stable
     */
    readonly nextHopIlb?: string;
    /**
     * URL to an instance that should handle matching packets.
     *
     * You can specify this as a full or partial URL. For example:
     * 'https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance'
     * 'projects/project/zones/zone/instances/instance'
     * 'zones/zone/instances/instance'
     * Just the instance name, with the zone in 'next_hop_instance_zone'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_instance ComputeRoute#next_hop_instance}
     *
     * @stability stable
     */
    readonly nextHopInstance?: string;
    /**
     * The zone of the instance specified in next_hop_instance. Omit if next_hop_instance is specified as a URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_instance_zone ComputeRoute#next_hop_instance_zone}
     *
     * @stability stable
     */
    readonly nextHopInstanceZone?: string;
    /**
     * Network IP address of an instance that should handle matching packets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_ip ComputeRoute#next_hop_ip}
     *
     * @stability stable
     */
    readonly nextHopIp?: string;
    /**
     * URL to a VpnTunnel that should handle matching packets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#next_hop_vpn_tunnel ComputeRoute#next_hop_vpn_tunnel}
     *
     * @stability stable
     */
    readonly nextHopVpnTunnel?: string;
    /**
     * The priority of this route.
     *
     * Priority is used to break ties in cases
     * where there is more than one matching route of equal prefix length.
     *
     * In the case of two routes with equal prefix length, the one with the
     * lowest-numbered priority value wins.
     *
     * Default value is 1000. Valid range is 0 through 65535.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#priority ComputeRoute#priority}
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#project ComputeRoute#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A list of instance tags to which this route applies.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#tags ComputeRoute#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#timeouts ComputeRoute#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRouteTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRouteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#create ComputeRoute#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_route.html#delete ComputeRoute#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeRouteTimeoutsToTerraform(struct?: ComputeRouteTimeoutsOutputReference | ComputeRouteTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRouteTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRouteTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_route.html google_compute_route}.
 *
 * @stability stable
 */
export declare class ComputeRoute extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_route.html google_compute_route} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRouteConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _destRange?;
    /**
     * @stability stable
     */
    get destRange(): string;
    /**
     * @stability stable
     */
    set destRange(value: string);
    /**
     * @stability stable
     */
    get destRangeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _nextHopGateway?;
    /**
     * @stability stable
     */
    get nextHopGateway(): string;
    /**
     * @stability stable
     */
    set nextHopGateway(value: string);
    /**
     * @stability stable
     */
    resetNextHopGateway(): void;
    /**
     * @stability stable
     */
    get nextHopGatewayInput(): string | undefined;
    private _nextHopIlb?;
    /**
     * @stability stable
     */
    get nextHopIlb(): string;
    /**
     * @stability stable
     */
    set nextHopIlb(value: string);
    /**
     * @stability stable
     */
    resetNextHopIlb(): void;
    /**
     * @stability stable
     */
    get nextHopIlbInput(): string | undefined;
    private _nextHopInstance?;
    /**
     * @stability stable
     */
    get nextHopInstance(): string;
    /**
     * @stability stable
     */
    set nextHopInstance(value: string);
    /**
     * @stability stable
     */
    resetNextHopInstance(): void;
    /**
     * @stability stable
     */
    get nextHopInstanceInput(): string | undefined;
    private _nextHopInstanceZone?;
    /**
     * @stability stable
     */
    get nextHopInstanceZone(): string;
    /**
     * @stability stable
     */
    set nextHopInstanceZone(value: string);
    /**
     * @stability stable
     */
    resetNextHopInstanceZone(): void;
    /**
     * @stability stable
     */
    get nextHopInstanceZoneInput(): string | undefined;
    private _nextHopIp?;
    /**
     * @stability stable
     */
    get nextHopIp(): string;
    /**
     * @stability stable
     */
    set nextHopIp(value: string);
    /**
     * @stability stable
     */
    resetNextHopIp(): void;
    /**
     * @stability stable
     */
    get nextHopIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get nextHopNetwork(): string;
    private _nextHopVpnTunnel?;
    /**
     * @stability stable
     */
    get nextHopVpnTunnel(): string;
    /**
     * @stability stable
     */
    set nextHopVpnTunnel(value: string);
    /**
     * @stability stable
     */
    resetNextHopVpnTunnel(): void;
    /**
     * @stability stable
     */
    get nextHopVpnTunnelInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRouteTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRouteTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRouteTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
