import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleIamRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_role.html#name DataGoogleIamRole#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_role.html google_iam_role}.
 *
 * @stability stable
 */
export declare class DataGoogleIamRole extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_role.html google_iam_role} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleIamRoleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get includedPermissions(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get stage(): string;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
