from rest_framework_simplejwt.authentication import (
    JWTAuthentication as SimpleJWTAuthentication,
)


class JWTAuthentication(SimpleJWTAuthentication):
    def authenticate(self, request):
        header = self.get_header(request)
        if header is None:
            return None

        raw_token = self.get_raw_token(header)
        if raw_token is None:
            return None

        validated_token = self.get_validated_token(raw_token)
        return self.get_user(validated_token), validated_token
