from prettyqt import core
from prettyqt.qt import QtBluetooth
from prettyqt.utils import bidict


md = QtBluetooth.QBluetoothUuid

CHARACTERISTIC_TYPES = bidict(
    aerobic_heart_rate_lower=md.AerobicHeartRateLowerLimit,
    aerobic_heart_rate_upper=md.AerobicHeartRateUpperLimit,
    aerobic_threshold=md.AerobicThreshold,
    age=md.Age,
    anaerobic_heart_rate_lower=md.AnaerobicHeartRateLowerLimit,
    anaerobic_heart_rate_upper=md.AnaerobicHeartRateUpperLimit,
    anaerobic_threshold=md.AnaerobicThreshold,
    alert_category_id=md.AlertCategoryID,
    alert_category_id_bitmask=md.AlertCategoryIDBitMask,
    alert_level=md.AlertLevel,
    alert_notification_control_point=md.AlertNotificationControlPoint,
    alert_status=md.AlertStatus,
    apparent_wind_direction=md.ApparentWindDirection,
    apparent_wind_speed=md.ApparentWindSpeed,
    appearance=md.Appearance,
    barometric_pressure_trend=md.BarometricPressureTrend,
    battery_level=md.BatteryLevel,
    blood_pressure_feature=md.BloodPressureFeature,
    blood_pressure_measurement=md.BloodPressureMeasurement,
    body_composition_feature=md.BodyCompositionFeature,
    body_composition_measurement=md.BodyCompositionMeasurement,
    body_sensor_location=md.BodySensorLocation,
    boot_keyboard_input_report=md.BootKeyboardInputReport,
    boot_keyboard_output_report=md.BootKeyboardOutputReport,
    boot_mouse_input_report=md.BootMouseInputReport,
    csc_feature=md.CSCFeature,
    csc_measurement=md.CSCMeasurement,
    current_time=md.CurrentTime,
    cycling_power_control_point=md.CyclingPowerControlPoint,
    cycling_power_feature=md.CyclingPowerFeature,
    cycling_power_measurement=md.CyclingPowerMeasurement,
    cycling_power_vector=md.CyclingPowerVector,
    database_change_increment=md.DatabaseChangeIncrement,
    date_of_birth=md.DateOfBirth,
    date_of_threshold_assessment=md.DateOfThresholdAssessment,
    date_time=md.DateTime,
    day_date_time=md.DayDateTime,
    day_of_week=md.DayOfWeek,
    descriptor_value_changed=md.DescriptorValueChanged,
    device_name=md.DeviceName,
    dew_point=md.DewPoint,
    dst_offset=md.DSTOffset,
    elevation=md.Elevation,
    email_address=md.EmailAddress,
    exact_time_256=md.ExactTime256,
    fat_burn_hear_rate_lower_limit=md.FatBurnHeartRateLowerLimit,
    fat_burn_hear_rate_upper_limit=md.FatBurnHeartRateUpperLimit,
    firmware_revision_string=md.FirmwareRevisionString,
    first_name=md.FirstName,
    five_zone_heart_rate_limits=md.FiveZoneHeartRateLimits,
    gender=md.Gender,
    glucose_feature=md.GlucoseFeature,
    glucose_measurement=md.GlucoseMeasurement,
    glucose_measurement_context=md.GlucoseMeasurementContext,
    gust_factor=md.GustFactor,
    hardware_revision_string=md.HardwareRevisionString,
    max_recommended_heart_rate=md.MaximumRecommendedHeartRate,
    heart_rate_control_point=md.HeartRateControlPoint,
    heart_rate_max=md.HeartRateMax,
    heart_rate_measurement=md.HeartRateMeasurement,
    heat_index=md.HeatIndex,
    height=md.Height,
    hid_control_point=md.HIDControlPoint,
    hid_information=md.HIDInformation,
    hip_circum_reference=md.HipCircumference,
    humidity=md.Humidity,
    regulatory_certification_list=md.IEEE1107320601RegulatoryCertificationDataList,
    intermediate_cuff_pressure=md.IntermediateCuffPressure,
    intermediate_temperature=md.IntermediateTemperature,
    irradiance=md.Irradiance,
    language=md.Language,
    last_name=md.LastName,
    ln_control_point=md.LNControlPoint,
    ln_feature=md.LNFeature,
    local_time_information=md.LocalTimeInformation,
    location_and_speed=md.LocationAndSpeed,
    magnetic_declination=md.MagneticDeclination,
    magnetic_flux_density_2d=md.MagneticFluxDensity2D,
    magnetic_magnetic_flux_density_3d=md.MagneticFluxDensity3D,
    manufacturer_name_string=md.ManufacturerNameString,
    measurement_interval=md.MeasurementInterval,
    model_number_string=md.ModelNumberString,
    navigation=md.Navigation,
    new_alert=md.NewAlert,
    peripheral_preferred_connection_parameters=md.PeripheralPreferredConnectionParameters,
    peripheral_privacy_flag=md.PeripheralPrivacyFlag,
    pn_pid=md.PnPID,
    pollen_concentration=md.PollenConcentration,
    position_quality=md.PositionQuality,
    pressure=md.Pressure,
    protocol_mode=md.ProtocolMode,
    rainfall=md.Rainfall,
    reconnection_address=md.ReconnectionAddress,
    record_access_control_point=md.RecordAccessControlPoint,
    reference_time_information=md.ReferenceTimeInformation,
    report=md.Report,
    report_map=md.ReportMap,
    resting_heart_rate=md.RestingHeartRate,
    ringer_control_point=md.RingerControlPoint,
    ringer_setting=md.RingerSetting,
    rsc_feature=md.RSCFeature,
    rsc_measurement=md.RSCMeasurement,
    sc_control_point=md.SCControlPoint,
    scan_interval_window=md.ScanIntervalWindow,
    scan_refresh=md.ScanRefresh,
    sensor_location=md.SensorLocation,
    serial_number_string=md.SerialNumberString,
    service_changed=md.ServiceChanged,
    software_revision_string=md.SoftwareRevisionString,
    sport_type_for_aerobic_anaerobic_thresholds=md.SportTypeForAerobicAnaerobicThresholds,
    supported_new_alert_category=md.SupportedNewAlertCategory,
    supported_unread_alert_category=md.SupportedUnreadAlertCategory,
    system_id=md.SystemID,
    temperature=md.Temperature,
    temperature_measurement=md.TemperatureMeasurement,
    temperature_type=md.TemperatureType,
    three_zone_heart_rate_limits=md.ThreeZoneHeartRateLimits,
    time_accuracy=md.TimeAccuracy,
    time_source=md.TimeSource,
    time_update_control_point=md.TimeUpdateControlPoint,
    time_update_state=md.TimeUpdateState,
    time_with_dst=md.TimeWithDST,
    time_zone=md.TimeZone,
    true_wind_direction=md.TrueWindDirection,
    true_wind_speed=md.TrueWindSpeed,
    two_zone_hear_rate_limits=md.TwoZoneHeartRateLimits,
    tx_power_level=md.TxPowerLevel,
    unread_alert_status=md.UnreadAlertStatus,
    user_control_point=md.UserControlPoint,
    user_index=md.UserIndex,
    uv_index=md.UVIndex,
    vo_2_max=md.VO2Max,
    waist_circumference=md.WaistCircumference,
    weight=md.Weight,
    weight_measurement=md.WeightMeasurement,
    weight_scale_feature=md.WeightScaleFeature,
    wind_chill=md.WindChill,
)

DESCRIPTOR_TYPE = bidict(
    characteristic_extended_properties=md.CharacteristicExtendedProperties,
    characteristic_user_description=md.CharacteristicUserDescription,
    client_characteristic_configuration=md.ClientCharacteristicConfiguration,
    server_characteristic_configuration=md.ServerCharacteristicConfiguration,
    characteristic_presentation_format=md.CharacteristicPresentationFormat,
    characteristic_aggregate_format=md.CharacteristicAggregateFormat,
    valid_range=md.ValidRange,
    external_report_reference=md.ExternalReportReference,
    report_reference=md.ReportReference,
    environmental_sensing_configuration=md.EnvironmentalSensingConfiguration,
    environmental_sensing_measurement=md.EnvironmentalSensingMeasurement,
    environmental_sensing_trigger_setting=md.EnvironmentalSensingTriggerSetting,
    unknown_descriptor_type=md.UnknownDescriptorType,
)

PROTOCOL_UUID = bidict(
    sdp=md.Sdp,
    udp=md.Udp,
    rfcomm=md.Rfcomm,
    tcp=md.Tcp,
    tcs_bin=md.TcsBin,
    tcs_at=md.TcsAt,
    att=md.Att,
    obex=md.Obex,
    ip=md.Ip,
    ftp=md.Ftp,
    http=md.Http,
    wsp=md.Wsp,
    bnep=md.Bnep,
    upnp=md.Upnp,
    hidp=md.Hidp,
    hardcopy_control_channel=md.HardcopyControlChannel,
    hardcopy_data_channel=md.HardcopyDataChannel,
    hardcopy_notification=md.HardcopyNotification,
    avctp=md.Avctp,
    avdtp=md.Avdtp,
    cmtp=md.Cmtp,
    udi_c_plain=md.UdiCPlain,
    mcap_control_channel=md.McapControlChannel,
    mcap_data_channel=md.McapDataChannel,
    l2_cap=md.L2cap,
)

SERVICE_CLASS_UUID = bidict(
    service_discovery_server=md.ServiceDiscoveryServer,
    browser_group_descriptor=md.BrowseGroupDescriptor,
    public_browse_group=md.PublicBrowseGroup,
    serial_port=md.SerialPort,
    lan_access_using_ppp=md.LANAccessUsingPPP,
    dial_up_networking=md.DialupNetworking,
    ir_mc_sync=md.IrMCSync,
    obex_object_push=md.ObexObjectPush,
    obex_file_transfer=md.OBEXFileTransfer,
    ir_mc_sync_command=md.IrMCSyncCommand,
    headset=md.Headset,
    audio_source=md.AudioSource,
    audio_sink=md.AudioSink,
    av_remove_control_target=md.AV_RemoteControlTarget,
    advanced_audio_distribution=md.AdvancedAudioDistribution,
    av_remote_control=md.AV_RemoteControl,
    av_remote_control_controller=md.AV_RemoteControlController,
    headset_ag=md.HeadsetAG,
    panu=md.PANU,
    nap=md.NAP,
    gn=md.GN,
    direct_printing=md.DirectPrinting,
    reference_printing=md.ReferencePrinting,
    basic_image=md.BasicImage,
    imaging_responder=md.ImagingResponder,
    imaging_automatic_archive=md.ImagingAutomaticArchive,
    imaging_reference_objects=md.ImagingReferenceObjects,
    hands_free=md.Handsfree,
    hands_free_audio_gateway=md.HandsfreeAudioGateway,
    direct_printing_reference_objects_service=md.DirectPrintingReferenceObjectsService,
    reflected_ui=md.ReflectedUI,
    basic_printing=md.BasicPrinting,
    printing_status=md.PrintingStatus,
    human_interface_device_service=md.HumanInterfaceDeviceService,
    hardcopy_cable_replacement=md.HardcopyCableReplacement,
    hcr_print=md.HCRPrint,
    hcr_scan=md.HCRScan,
    sim_access=md.SIMAccess,
    phonebook_access_pce=md.PhonebookAccessPCE,
    phonebook_access_pse=md.PhonebookAccessPSE,
    phonebook_access=md.PhonebookAccess,
    headset_hs=md.HeadsetHS,
    message_access_server=md.MessageAccessServer,
    message_notification_server=md.MessageNotificationServer,
    message_access_profile=md.MessageAccessProfile,
    gnss=md.GNSS,
    gnss_server=md.GNSSServer,
    display_3d=md.Display3D,
    glasses_3d=md.Glasses3D,
    synchronization_3d=md.Synchronization3D,
    mps_profile=md.MPSProfile,
    mps_service=md.MPSService,
    pnp_information=md.PnPInformation,
    generic_networking=md.GenericNetworking,
    generic_file_transfer=md.GenericFileTransfer,
    generic_audio=md.GenericAudio,
    generic_telephony=md.GenericTelephony,
    video_source=md.VideoSource,
    video_sink=md.VideoSink,
    video_distribution=md.VideoDistribution,
    hdp=md.HDP,
    hdp_source=md.HDPSource,
    hdp_sink=md.HDPSink,
    generic_access=md.GenericAccess,
    generic_attribute=md.GenericAttribute,
    immediate_alert=md.ImmediateAlert,
    link_loss=md.LinkLoss,
    tx_power=md.TxPower,
    current_time_service=md.CurrentTimeService,
    reference_time_update_service=md.ReferenceTimeUpdateService,
    next_dst_change_service=md.NextDSTChangeService,
    glucose=md.Glucose,
    health_thermometer=md.HealthThermometer,
    device_information=md.DeviceInformation,
    heart_rate=md.HeartRate,
    phone_alert_status_service=md.PhoneAlertStatusService,
    battery_service=md.BatteryService,
    blood_pressure=md.BloodPressure,
    alert_notification_service=md.AlertNotificationService,
    human_interface_device=md.HumanInterfaceDevice,
    scan_parameters=md.ScanParameters,
    running_speed_and_cadence=md.RunningSpeedAndCadence,
    cycling_speed_and_cadence=md.CyclingSpeedAndCadence,
    cycling_power=md.CyclingPower,
    location_and_navigation=md.LocationAndNavigation,
    environmental_sensing=md.EnvironmentalSensing,
    body_composition=md.BodyComposition,
    user_data=md.UserData,
    weight_scale=md.WeightScale,
    bond_management=md.BondManagement,
    continuous_glucose_monitoring=md.ContinuousGlucoseMonitoring,
)

QtBluetooth.QBluetoothUuid.__bases__ = (core.Uuid,)


class BluetoothUuid(QtBluetooth.QBluetoothUuid):
    pass


if __name__ == "__main__":
    address = BluetoothUuid()
