from prettyqt.qt import QtCore
from prettyqt.utils import bidict


Loc = QtCore.QLocale

COUNTRY = bidict(
    any=Loc.AnyCountry,
    afghanistan=Loc.Afghanistan,
    aland_islands=Loc.AlandIslands,
    albania=Loc.Albania,
    algeria=Loc.Algeria,
    american_samoa=Loc.AmericanSamoa,
    andorra=Loc.Andorra,
    angola=Loc.Angola,
    anguilla=Loc.Anguilla,
    antarctica=Loc.Antarctica,
    antigua_and_barbuda=Loc.AntiguaAndBarbuda,
    argentina=Loc.Argentina,
    armenia=Loc.Armenia,
    aruba=Loc.Aruba,
    ascension_island=Loc.AscensionIsland,
    australia=Loc.Australia,
    austria=Loc.Austria,
    azerbaijan=Loc.Azerbaijan,
    bahamas=Loc.Bahamas,
    bahrain=Loc.Bahrain,
    bangladesh=Loc.Bangladesh,
    barbados=Loc.Barbados,
    belarus=Loc.Belarus,
    belgium=Loc.Belgium,
    belize=Loc.Belize,
    benin=Loc.Benin,
    bermuda=Loc.Bermuda,
    bhutan=Loc.Bhutan,
    bolivia=Loc.Bolivia,
    bonaire=Loc.Bonaire,
    bosnia_and_herzegowina=Loc.BosniaAndHerzegowina,
    botswana=Loc.Botswana,
    bouvet_island=Loc.BouvetIsland,
    brazil=Loc.Brazil,
    british_indian_ocean_territory=Loc.BritishIndianOceanTerritory,
    british_virgin_islands=Loc.BritishVirginIslands,
    brunei=Loc.Brunei,
    bulgaria=Loc.Bulgaria,
    burkina_faso=Loc.BurkinaFaso,
    burundi=Loc.Burundi,
    cambodia=Loc.Cambodia,
    cameroon=Loc.Cameroon,
    canada=Loc.Canada,
    canary_islands=Loc.CanaryIslands,
    cape_verde=Loc.CapeVerde,
    cayman_islands=Loc.CaymanIslands,
    central_african_republic=Loc.CentralAfricanRepublic,
    ceuta_and_melilla=Loc.CeutaAndMelilla,
    chad=Loc.Chad,
    chile=Loc.Chile,
    china=Loc.China,
    christmas_island=Loc.ChristmasIsland,
    clipperton_island=Loc.ClippertonIsland,
    cocos_islands=Loc.CocosIslands,
    colombia=Loc.Colombia,
    comoros=Loc.Comoros,
    congo_brazzaville=Loc.CongoBrazzaville,
    congo_kinshasa=Loc.CongoKinshasa,
    cook_islands=Loc.CookIslands,
    costa_rica=Loc.CostaRica,
    croatia=Loc.Croatia,
    cuba=Loc.Cuba,
    curasao=Loc.CuraSao,
    cyprus=Loc.Cyprus,
    czech_republic=Loc.CzechRepublic,
    denmark=Loc.Denmark,
    diego_garcia=Loc.DiegoGarcia,
    djibouti=Loc.Djibouti,
    dominica=Loc.Dominica,
    dominican_republic=Loc.DominicanRepublic,
    east_timor=Loc.EastTimor,
    ecuador=Loc.Ecuador,
    egypt=Loc.Egypt,
    el_salvador=Loc.ElSalvador,
    equatorial_guinea=Loc.EquatorialGuinea,
    eritrea=Loc.Eritrea,
    estonia=Loc.Estonia,
    ethiopia=Loc.Ethiopia,
    european_union=Loc.EuropeanUnion,
    europe=Loc.Europe,
    falkland_islands=Loc.FalklandIslands,
    faroe_islands=Loc.FaroeIslands,
    fiji=Loc.Fiji,
    finland=Loc.Finland,
    france=Loc.France,
    french_guiana=Loc.FrenchGuiana,
    french_polynesia=Loc.FrenchPolynesia,
    french_southern_territories=Loc.FrenchSouthernTerritories,
    gabon=Loc.Gabon,
    gambia=Loc.Gambia,
    georgia=Loc.Georgia,
    germany=Loc.Germany,
    ghana=Loc.Ghana,
    gibraltar=Loc.Gibraltar,
    greece=Loc.Greece,
    greenland=Loc.Greenland,
    grenada=Loc.Grenada,
    guadeloupe=Loc.Guadeloupe,
    guam=Loc.Guam,
    guatemala=Loc.Guatemala,
    guernsey=Loc.Guernsey,
    guinea=Loc.Guinea,
    guineabissau=Loc.GuineaBissau,
    guyana=Loc.Guyana,
    haiti=Loc.Haiti,
    heard_and_mcdonald_islands=Loc.HeardAndMcDonaldIslands,
    honduras=Loc.Honduras,
    hongkong=Loc.HongKong,
    hungary=Loc.Hungary,
    iceland=Loc.Iceland,
    india=Loc.India,
    indonesia=Loc.Indonesia,
    iran=Loc.Iran,
    iraq=Loc.Iraq,
    ireland=Loc.Ireland,
    isle_of_man=Loc.IsleOfMan,
    israel=Loc.Israel,
    italy=Loc.Italy,
    ivory_coast=Loc.IvoryCoast,
    jamaica=Loc.Jamaica,
    japan=Loc.Japan,
    jersey=Loc.Jersey,
    jordan=Loc.Jordan,
    kazakhstan=Loc.Kazakhstan,
    kenya=Loc.Kenya,
    kiribati=Loc.Kiribati,
    kosovo=Loc.Kosovo,
    kuwait=Loc.Kuwait,
    kyrgyzstan=Loc.Kyrgyzstan,
    laos=Loc.Laos,
    latin_america=Loc.LatinAmerica,
    latvia=Loc.Latvia,
    lebanon=Loc.Lebanon,
    lesotho=Loc.Lesotho,
    liberia=Loc.Liberia,
    libya=Loc.Libya,
    liechtenstein=Loc.Liechtenstein,
    lithuania=Loc.Lithuania,
    luxembourg=Loc.Luxembourg,
    macau=Loc.Macau,
    macedonia=Loc.Macedonia,
    madagascar=Loc.Madagascar,
    malawi=Loc.Malawi,
    malaysia=Loc.Malaysia,
    maldives=Loc.Maldives,
    mali=Loc.Mali,
    malta=Loc.Malta,
    marshall_islands=Loc.MarshallIslands,
    martinique=Loc.Martinique,
    mauritania=Loc.Mauritania,
    mauritius=Loc.Mauritius,
    mayotte=Loc.Mayotte,
    mexico=Loc.Mexico,
    micronesia=Loc.Micronesia,
    moldova=Loc.Moldova,
    monaco=Loc.Monaco,
    mongolia=Loc.Mongolia,
    montenegro=Loc.Montenegro,
    montserrat=Loc.Montserrat,
    morocco=Loc.Morocco,
    mozambique=Loc.Mozambique,
    myanmar=Loc.Myanmar,
    namibia=Loc.Namibia,
    nauru_country=Loc.NauruCountry,
    nepal=Loc.Nepal,
    netherlands=Loc.Netherlands,
    new_caledonia=Loc.NewCaledonia,
    new_zealand=Loc.NewZealand,
    nicaragua=Loc.Nicaragua,
    niger=Loc.Niger,
    nigeria=Loc.Nigeria,
    niue=Loc.Niue,
    norfolk_island=Loc.NorfolkIsland,
    northern_mariana_islands=Loc.NorthernMarianaIslands,
    north_korea=Loc.NorthKorea,
    norway=Loc.Norway,
    oman=Loc.Oman,
    outlying_oceania=Loc.OutlyingOceania,
    pakistan=Loc.Pakistan,
    palau=Loc.Palau,
    palestinian_territories=Loc.PalestinianTerritories,
    panama=Loc.Panama,
    papua_new_guinea=Loc.PapuaNewGuinea,
    paraguay=Loc.Paraguay,
    peru=Loc.Peru,
    philippines=Loc.Philippines,
    pitcairn=Loc.Pitcairn,
    poland=Loc.Poland,
    portugal=Loc.Portugal,
    puertorico=Loc.PuertoRico,
    qatar=Loc.Qatar,
    reunion=Loc.Reunion,
    romania=Loc.Romania,
    russia=Loc.Russia,
    rwanda=Loc.Rwanda,
    saint_barthelemy=Loc.SaintBarthelemy,
    saint_helena=Loc.SaintHelena,
    saint_kitts_and_nevis=Loc.SaintKittsAndNevis,
    saint_lucia=Loc.SaintLucia,
    saint_martin=Loc.SaintMartin,
    saint_pierre_and_miquelon=Loc.SaintPierreAndMiquelon,
    saint_vincent_and_the_grenadines=Loc.SaintVincentAndTheGrenadines,
    samoa=Loc.Samoa,
    san_marino=Loc.SanMarino,
    sao_tome_and_principe=Loc.SaoTomeAndPrincipe,
    saudi_arabia=Loc.SaudiArabia,
    senegal=Loc.Senegal,
    serbia=Loc.Serbia,
    seychelles=Loc.Seychelles,
    sierra_leone=Loc.SierraLeone,
    singapore=Loc.Singapore,
    sint_maarten=Loc.SintMaarten,
    slovakia=Loc.Slovakia,
    slovenia=Loc.Slovenia,
    solomon_islands=Loc.SolomonIslands,
    somalia=Loc.Somalia,
    south_africa=Loc.SouthAfrica,
    south_georgia_and_south_sandwich_islands=Loc.SouthGeorgiaAndTheSouthSandwichIslands,
    south_korea=Loc.SouthKorea,
    south_sudan=Loc.SouthSudan,
    spain=Loc.Spain,
    sri_lanka=Loc.SriLanka,
    sudan=Loc.Sudan,
    suriname=Loc.Suriname,
    svalbard_and_jan_mayen_islands=Loc.SvalbardAndJanMayenIslands,
    swaziland=Loc.Swaziland,
    sweden=Loc.Sweden,
    switzerland=Loc.Switzerland,
    syria=Loc.Syria,
    taiwan=Loc.Taiwan,
    tajikistan=Loc.Tajikistan,
    tanzania=Loc.Tanzania,
    thailand=Loc.Thailand,
    togo=Loc.Togo,
    tokelau_country=Loc.TokelauCountry,
    tonga=Loc.Tonga,
    trinidad_and_tobago=Loc.TrinidadAndTobago,
    tristan_da_cunha=Loc.TristanDaCunha,
    tunisia=Loc.Tunisia,
    turkey=Loc.Turkey,
    turkmenistan=Loc.Turkmenistan,
    turks_and_caicos_islands=Loc.TurksAndCaicosIslands,
    tuvalu_country=Loc.TuvaluCountry,
    uganda=Loc.Uganda,
    ukraine=Loc.Ukraine,
    united_arabemirates=Loc.UnitedArabEmirates,
    united_kingdom=Loc.UnitedKingdom,
    united_states=Loc.UnitedStates,
    united_states_minor_outlying_islands=Loc.UnitedStatesMinorOutlyingIslands,
    united_states_virgin_islands=Loc.UnitedStatesVirginIslands,
    uruguay=Loc.Uruguay,
    uzbekistan=Loc.Uzbekistan,
    vanuatu=Loc.Vanuatu,
    vatican_city_state=Loc.VaticanCityState,
    venezuela=Loc.Venezuela,
    vietnam=Loc.Vietnam,
    wallis_and_futuna_islands=Loc.WallisAndFutunaIslands,
    western_sahara=Loc.WesternSahara,
    world=Loc.World,
    yemen=Loc.Yemen,
    zambia=Loc.Zambia,
    zimbabwe=Loc.Zimbabwe,
)


LANGUAGE = bidict(
    any_language=QtCore.QLocale.AnyLanguage,
    c=QtCore.QLocale.C,
    abkhazian=QtCore.QLocale.Abkhazian,
    afar=QtCore.QLocale.Afar,
    afrikaans=QtCore.QLocale.Afrikaans,
    aghem=QtCore.QLocale.Aghem,
    akan=QtCore.QLocale.Akan,
    akkadian=QtCore.QLocale.Akkadian,
    akoose=QtCore.QLocale.Akoose,
    albanian=QtCore.QLocale.Albanian,
    american_sign_language=QtCore.QLocale.AmericanSignLanguage,
    amharic=QtCore.QLocale.Amharic,
    ancient_egyptian=QtCore.QLocale.AncientEgyptian,
    ancient_greek=QtCore.QLocale.AncientGreek,
    arabic=QtCore.QLocale.Arabic,
    aragonese=QtCore.QLocale.Aragonese,
    aramaic=QtCore.QLocale.Aramaic,
    armenian=QtCore.QLocale.Armenian,
    assamese=QtCore.QLocale.Assamese,
    asturian=QtCore.QLocale.Asturian,
    asu=QtCore.QLocale.Asu,
    atsam=QtCore.QLocale.Atsam,
    avaric=QtCore.QLocale.Avaric,
    avestan=QtCore.QLocale.Avestan,
    aymara=QtCore.QLocale.Aymara,
    azerbaijani=QtCore.QLocale.Azerbaijani,
    bafia=QtCore.QLocale.Bafia,
    balinese=QtCore.QLocale.Balinese,
    bambara=QtCore.QLocale.Bambara,
    bamun=QtCore.QLocale.Bamun,
    basaa=QtCore.QLocale.Basaa,
    bashkir=QtCore.QLocale.Bashkir,
    basque=QtCore.QLocale.Basque,
    bataktoba=QtCore.QLocale.BatakToba,
    belarusian=QtCore.QLocale.Belarusian,
    bemba=QtCore.QLocale.Bemba,
    bena=QtCore.QLocale.Bena,
    bengali=QtCore.QLocale.Bengali,
    bhojpuri=QtCore.QLocale.Bhojpuri,
    bislama=QtCore.QLocale.Bislama,
    blin=QtCore.QLocale.Blin,
    bodo=QtCore.QLocale.Bodo,
    bosnian=QtCore.QLocale.Bosnian,
    breton=QtCore.QLocale.Breton,
    buginese=QtCore.QLocale.Buginese,
    bulgarian=QtCore.QLocale.Bulgarian,
    burmese=QtCore.QLocale.Burmese,
    cantonese=QtCore.QLocale.Cantonese,
    catalan=QtCore.QLocale.Catalan,
    cebuano=QtCore.QLocale.Cebuano,
    central_kurdish=QtCore.QLocale.CentralKurdish,
    central_morocco_tamazight=QtCore.QLocale.CentralMoroccoTamazight,
    chakma=QtCore.QLocale.Chakma,
    chamorro=QtCore.QLocale.Chamorro,
    chechen=QtCore.QLocale.Chechen,
    cherokee=QtCore.QLocale.Cherokee,
    chickasaw=QtCore.QLocale.Chickasaw,
    chiga=QtCore.QLocale.Chiga,
    chinese=QtCore.QLocale.Chinese,
    church=QtCore.QLocale.Church,
    chuvash=QtCore.QLocale.Chuvash,
    colognian=QtCore.QLocale.Colognian,
    coptic=QtCore.QLocale.Coptic,
    cornish=QtCore.QLocale.Cornish,
    corsican=QtCore.QLocale.Corsican,
    cree=QtCore.QLocale.Cree,
    croatian=QtCore.QLocale.Croatian,
    czech=QtCore.QLocale.Czech,
    danish=QtCore.QLocale.Danish,
    divehi=QtCore.QLocale.Divehi,
    dogri=QtCore.QLocale.Dogri,
    duala=QtCore.QLocale.Duala,
    dutch=QtCore.QLocale.Dutch,
    dzongkha=QtCore.QLocale.Dzongkha,
    embu=QtCore.QLocale.Embu,
    english=QtCore.QLocale.English,
    erzya=QtCore.QLocale.Erzya,
    esperanto=QtCore.QLocale.Esperanto,
    estonian=QtCore.QLocale.Estonian,
    ewe=QtCore.QLocale.Ewe,
    ewondo=QtCore.QLocale.Ewondo,
    faroese=QtCore.QLocale.Faroese,
    fijian=QtCore.QLocale.Fijian,
    filipino=QtCore.QLocale.Filipino,
    finnish=QtCore.QLocale.Finnish,
    french=QtCore.QLocale.French,
    friulian=QtCore.QLocale.Friulian,
    fulah=QtCore.QLocale.Fulah,
    ga=QtCore.QLocale.Ga,
    gaelic=QtCore.QLocale.Gaelic,
    galician=QtCore.QLocale.Galician,
    ganda=QtCore.QLocale.Ganda,
    geez=QtCore.QLocale.Geez,
    georgian=QtCore.QLocale.Georgian,
    german=QtCore.QLocale.German,
    gothic=QtCore.QLocale.Gothic,
    greek=QtCore.QLocale.Greek,
    greenlandic=QtCore.QLocale.Greenlandic,
    guarani=QtCore.QLocale.Guarani,
    gujarati=QtCore.QLocale.Gujarati,
    gusii=QtCore.QLocale.Gusii,
    haitian=QtCore.QLocale.Haitian,
    hausa=QtCore.QLocale.Hausa,
    hawaiian=QtCore.QLocale.Hawaiian,
    hebrew=QtCore.QLocale.Hebrew,
    herero=QtCore.QLocale.Herero,
    hindi=QtCore.QLocale.Hindi,
    hirimotu=QtCore.QLocale.HiriMotu,
    hungarian=QtCore.QLocale.Hungarian,
    icelandic=QtCore.QLocale.Icelandic,
    ido=QtCore.QLocale.Ido,
    igbo=QtCore.QLocale.Igbo,
    inari_sami=QtCore.QLocale.InariSami,
    indonesian=QtCore.QLocale.Indonesian,
    ingush=QtCore.QLocale.Ingush,
    interlingua=QtCore.QLocale.Interlingua,
    interlingue=QtCore.QLocale.Interlingue,
    inuktitut=QtCore.QLocale.Inuktitut,
    inupiak=QtCore.QLocale.Inupiak,
    irish=QtCore.QLocale.Irish,
    italian=QtCore.QLocale.Italian,
    japanese=QtCore.QLocale.Japanese,
    javanese=QtCore.QLocale.Javanese,
    jju=QtCore.QLocale.Jju,
    jola_fonyi=QtCore.QLocale.JolaFonyi,
    kabuverdianu=QtCore.QLocale.Kabuverdianu,
    kabyle=QtCore.QLocale.Kabyle,
    kako=QtCore.QLocale.Kako,
    kalenjin=QtCore.QLocale.Kalenjin,
    kamba=QtCore.QLocale.Kamba,
    kannada=QtCore.QLocale.Kannada,
    kanuri=QtCore.QLocale.Kanuri,
    kashmiri=QtCore.QLocale.Kashmiri,
    kazakh=QtCore.QLocale.Kazakh,
    kenyang=QtCore.QLocale.Kenyang,
    khmer=QtCore.QLocale.Khmer,
    kiche=QtCore.QLocale.Kiche,
    kikuyu=QtCore.QLocale.Kikuyu,
    kinyarwanda=QtCore.QLocale.Kinyarwanda,
    kirghiz=QtCore.QLocale.Kirghiz,
    komi=QtCore.QLocale.Komi,
    kongo=QtCore.QLocale.Kongo,
    konkani=QtCore.QLocale.Konkani,
    korean=QtCore.QLocale.Korean,
    koro=QtCore.QLocale.Koro,
    koyraboro_senni=QtCore.QLocale.KoyraboroSenni,
    koyra_chiini=QtCore.QLocale.KoyraChiini,
    kpelle=QtCore.QLocale.Kpelle,
    kurdish=QtCore.QLocale.Kurdish,
    kwanyama=QtCore.QLocale.Kwanyama,
    kwasio=QtCore.QLocale.Kwasio,
    lakota=QtCore.QLocale.Lakota,
    langi=QtCore.QLocale.Langi,
    lao=QtCore.QLocale.Lao,
    latin=QtCore.QLocale.Latin,
    latvian=QtCore.QLocale.Latvian,
    lezghian=QtCore.QLocale.Lezghian,
    limburgish=QtCore.QLocale.Limburgish,
    lingala=QtCore.QLocale.Lingala,
    literary_chinese=QtCore.QLocale.LiteraryChinese,
    lithuanian=QtCore.QLocale.Lithuanian,
    lojban=QtCore.QLocale.Lojban,
    lower_sorbian=QtCore.QLocale.LowerSorbian,
    low_german=QtCore.QLocale.LowGerman,
    luba_katanga=QtCore.QLocale.LubaKatanga,
    lule_sami=QtCore.QLocale.LuleSami,
    luo=QtCore.QLocale.Luo,
    luxembourgish=QtCore.QLocale.Luxembourgish,
    luyia=QtCore.QLocale.Luyia,
    macedonian=QtCore.QLocale.Macedonian,
    machame=QtCore.QLocale.Machame,
    maithili=QtCore.QLocale.Maithili,
    makhuwa_meetto=QtCore.QLocale.MakhuwaMeetto,
    makonde=QtCore.QLocale.Makonde,
    malagasy=QtCore.QLocale.Malagasy,
    malay=QtCore.QLocale.Malay,
    malayalam=QtCore.QLocale.Malayalam,
    maltese=QtCore.QLocale.Maltese,
    mandingo=QtCore.QLocale.Mandingo,
    manipuri=QtCore.QLocale.Manipuri,
    manx=QtCore.QLocale.Manx,
    maori=QtCore.QLocale.Maori,
    mapuche=QtCore.QLocale.Mapuche,
    marathi=QtCore.QLocale.Marathi,
    marshallese=QtCore.QLocale.Marshallese,
    masai=QtCore.QLocale.Masai,
    mazanderani=QtCore.QLocale.Mazanderani,
    mende=QtCore.QLocale.Mende,
    meru=QtCore.QLocale.Meru,
    meta=QtCore.QLocale.Meta,
    mohawk=QtCore.QLocale.Mohawk,
    mongolian=QtCore.QLocale.Mongolian,
    morisyen=QtCore.QLocale.Morisyen,
    mundang=QtCore.QLocale.Mundang,
    muscogee=QtCore.QLocale.Muscogee,
    nama=QtCore.QLocale.Nama,
    nauru_language=QtCore.QLocale.NauruLanguage,
    navaho=QtCore.QLocale.Navaho,
    ndonga=QtCore.QLocale.Ndonga,
    nepali=QtCore.QLocale.Nepali,
    newari=QtCore.QLocale.Newari,
    ngiemboon=QtCore.QLocale.Ngiemboon,
    ngomba=QtCore.QLocale.Ngomba,
    nko=QtCore.QLocale.Nko,
    northern_luri=QtCore.QLocale.NorthernLuri,
    northern_sami=QtCore.QLocale.NorthernSami,
    northern_sotho=QtCore.QLocale.NorthernSotho,
    north_ndebele=QtCore.QLocale.NorthNdebele,
    norwegian_bokmal=QtCore.QLocale.NorwegianBokmal,
    norwegian_nynorsk=QtCore.QLocale.NorwegianNynorsk,
    nuer=QtCore.QLocale.Nuer,
    nyanja=QtCore.QLocale.Nyanja,
    nyankole=QtCore.QLocale.Nyankole,
    occitan=QtCore.QLocale.Occitan,
    ojibwa=QtCore.QLocale.Ojibwa,
    old_irish=QtCore.QLocale.OldIrish,
    old_norse=QtCore.QLocale.OldNorse,
    old_persian=QtCore.QLocale.OldPersian,
    oriya=QtCore.QLocale.Oriya,
    oromo=QtCore.QLocale.Oromo,
    osage=QtCore.QLocale.Osage,
    ossetic=QtCore.QLocale.Ossetic,
    pahlavi=QtCore.QLocale.Pahlavi,
    palauan=QtCore.QLocale.Palauan,
    pali=QtCore.QLocale.Pali,
    papiamento=QtCore.QLocale.Papiamento,
    pashto=QtCore.QLocale.Pashto,
    persian=QtCore.QLocale.Persian,
    phoenician=QtCore.QLocale.Phoenician,
    polish=QtCore.QLocale.Polish,
    portuguese=QtCore.QLocale.Portuguese,
    prussian=QtCore.QLocale.Prussian,
    punjabi=QtCore.QLocale.Punjabi,
    quechua=QtCore.QLocale.Quechua,
    romanian=QtCore.QLocale.Romanian,
    romansh=QtCore.QLocale.Romansh,
    rombo=QtCore.QLocale.Rombo,
    rundi=QtCore.QLocale.Rundi,
    russian=QtCore.QLocale.Russian,
    rwa=QtCore.QLocale.Rwa,
    saho=QtCore.QLocale.Saho,
    sakha=QtCore.QLocale.Sakha,
    samburu=QtCore.QLocale.Samburu,
    samoan=QtCore.QLocale.Samoan,
    sango=QtCore.QLocale.Sango,
    sangu=QtCore.QLocale.Sangu,
    sanskrit=QtCore.QLocale.Sanskrit,
    santali=QtCore.QLocale.Santali,
    sardinian=QtCore.QLocale.Sardinian,
    saurashtra=QtCore.QLocale.Saurashtra,
    sena=QtCore.QLocale.Sena,
    serbian=QtCore.QLocale.Serbian,
    shambala=QtCore.QLocale.Shambala,
    shona=QtCore.QLocale.Shona,
    sichuanyi=QtCore.QLocale.SichuanYi,
    sicilian=QtCore.QLocale.Sicilian,
    sidamo=QtCore.QLocale.Sidamo,
    silesian=QtCore.QLocale.Silesian,
    sindhi=QtCore.QLocale.Sindhi,
    sinhala=QtCore.QLocale.Sinhala,
    skoltsami=QtCore.QLocale.SkoltSami,
    slovak=QtCore.QLocale.Slovak,
    slovenian=QtCore.QLocale.Slovenian,
    soga=QtCore.QLocale.Soga,
    somali=QtCore.QLocale.Somali,
    southern_kurdish=QtCore.QLocale.SouthernKurdish,
    southern_sami=QtCore.QLocale.SouthernSami,
    southern_sotho=QtCore.QLocale.SouthernSotho,
    south_ndebele=QtCore.QLocale.SouthNdebele,
    spanish=QtCore.QLocale.Spanish,
    standard_moroccan_tamazight=QtCore.QLocale.StandardMoroccanTamazight,
    sundanese=QtCore.QLocale.Sundanese,
    swahili=QtCore.QLocale.Swahili,
    swati=QtCore.QLocale.Swati,
    swedish=QtCore.QLocale.Swedish,
    swiss_german=QtCore.QLocale.SwissGerman,
    syriac=QtCore.QLocale.Syriac,
    tachelhit=QtCore.QLocale.Tachelhit,
    tahitian=QtCore.QLocale.Tahitian,
    taidam=QtCore.QLocale.TaiDam,
    taita=QtCore.QLocale.Taita,
    tajik=QtCore.QLocale.Tajik,
    tamil=QtCore.QLocale.Tamil,
    taroko=QtCore.QLocale.Taroko,
    tasawaq=QtCore.QLocale.Tasawaq,
    tatar=QtCore.QLocale.Tatar,
    telugu=QtCore.QLocale.Telugu,
    teso=QtCore.QLocale.Teso,
    thai=QtCore.QLocale.Thai,
    tibetan=QtCore.QLocale.Tibetan,
    tigre=QtCore.QLocale.Tigre,
    tigrinya=QtCore.QLocale.Tigrinya,
    tokelau_language=QtCore.QLocale.TokelauLanguage,
    tokpisin=QtCore.QLocale.TokPisin,
    tongan=QtCore.QLocale.Tongan,
    tsonga=QtCore.QLocale.Tsonga,
    tswana=QtCore.QLocale.Tswana,
    turkish=QtCore.QLocale.Turkish,
    turkmen=QtCore.QLocale.Turkmen,
    tuvalu_language=QtCore.QLocale.TuvaluLanguage,
    tyap=QtCore.QLocale.Tyap,
    ugaritic=QtCore.QLocale.Ugaritic,
    uighur=QtCore.QLocale.Uighur,
    ukrainian=QtCore.QLocale.Ukrainian,
    upper_sorbian=QtCore.QLocale.UpperSorbian,
    urdu=QtCore.QLocale.Urdu,
    uzbek=QtCore.QLocale.Uzbek,
    vai=QtCore.QLocale.Vai,
    venda=QtCore.QLocale.Venda,
    vietnamese=QtCore.QLocale.Vietnamese,
    volapuk=QtCore.QLocale.Volapuk,
    vunjo=QtCore.QLocale.Vunjo,
    walamo=QtCore.QLocale.Walamo,
    walloon=QtCore.QLocale.Walloon,
    walser=QtCore.QLocale.Walser,
    warlpiri=QtCore.QLocale.Warlpiri,
    welsh=QtCore.QLocale.Welsh,
    western_balochi=QtCore.QLocale.WesternBalochi,
    western_frisian=QtCore.QLocale.WesternFrisian,
    wolof=QtCore.QLocale.Wolof,
    xhosa=QtCore.QLocale.Xhosa,
    yangben=QtCore.QLocale.Yangben,
    yiddish=QtCore.QLocale.Yiddish,
    yoruba=QtCore.QLocale.Yoruba,
    zarma=QtCore.QLocale.Zarma,
    zhuang=QtCore.QLocale.Zhuang,
    zulu=QtCore.QLocale.Zulu,
)


class Locale(QtCore.QLocale):
    def __repr__(self):
        return f"{type(self).__name__}({self.bcp47Name()!r})"

    def __reduce__(self):
        return type(self), (self.bcp47Name(),)


if __name__ == "__main__":
    locale = Locale()
    print(repr(locale))
