import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudApplicationLoadbalancerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#datacenter_id DataIonoscloudApplicationLoadbalancer#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#id DataIonoscloudApplicationLoadbalancer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Application Load Balancer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#name DataIonoscloudApplicationLoadbalancer#name}
    */
    readonly name?: string;
    /**
    * Whether partial matching is allowed or not when using name argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#partial_match DataIonoscloudApplicationLoadbalancer#partial_match}
    */
    readonly partialMatch?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#timeouts DataIonoscloudApplicationLoadbalancer#timeouts}
    */
    readonly timeouts?: DataIonoscloudApplicationLoadbalancerTimeouts;
}
export interface DataIonoscloudApplicationLoadbalancerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#create DataIonoscloudApplicationLoadbalancer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#default DataIonoscloudApplicationLoadbalancer#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#delete DataIonoscloudApplicationLoadbalancer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer#update DataIonoscloudApplicationLoadbalancer#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudApplicationLoadbalancerTimeoutsToTerraform(struct?: DataIonoscloudApplicationLoadbalancerTimeoutsOutputReference | DataIonoscloudApplicationLoadbalancerTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudApplicationLoadbalancerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudApplicationLoadbalancerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudApplicationLoadbalancerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer ionoscloud_application_loadbalancer}
*/
export declare class DataIonoscloudApplicationLoadbalancer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_application_loadbalancer";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/application_loadbalancer ionoscloud_application_loadbalancer} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudApplicationLoadbalancerConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudApplicationLoadbalancerConfig);
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ips(): string[];
    get lbPrivateIps(): string[];
    get listenerLan(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _partialMatch?;
    get partialMatch(): boolean | cdktf.IResolvable;
    set partialMatch(value: boolean | cdktf.IResolvable);
    resetPartialMatch(): void;
    get partialMatchInput(): boolean | cdktf.IResolvable | undefined;
    get targetLan(): number;
    private _timeouts;
    get timeouts(): DataIonoscloudApplicationLoadbalancerTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudApplicationLoadbalancerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudApplicationLoadbalancerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
