# CoBRA - Comprehensive Backing up and Restoration Archiver

Cobra is a tool for creating, managing and restoring backups. 
It is designed to cover docker powered applications as well as it allows backing up of 
regular file system folders.

![Cobra cli](https://github.com/yell0w4x/assets/raw/main/cobra-cli.png)

## Run tests

```bash
git clone https://github.com/yell0w4x/cobra.git
cd cobra
./run-tests --unit
```
 
The above will run unit tests. To run end-to-end tests run as follows. 
Note that docker must reside in the system.
To install it on Ubuntu `wget -qO- https://get.docker.com | sudo bash`. 
On Manjaro (Arch) `sudo pacman -S docker`.

```bash
./run-tests --e2e --folder-id goolge-drive-folder-id --key path/to/google-service-account-key.json
```
or
```bash
GOOGLE_DRIVE_FOLDER_ID=goolge-drive-folder-id GOOGLE_SERVICE_ACC_KEY=path/to/key.json ./run-tests --e2e
```

The tests are based on pytest. All the extra arguments are passed to pytest. 
So to have verbose output use `-v` or `-vv`. To show stdout `-s`. 
To run certain tests use `-k test_name` and etc. For details see the pytest docs.

```bash
./run-tests --help
Run cobra unit and e2e tests.

Usage:
    ./run-tests [OPTIONS] [EXTRA_ARGS]

All the EXTRA_ARGS are passed to pytest

Options:
    --help                Show help message
    --unit                Run unit tests
    --e2e                 Run e2e tests
    --skip-build          Skip building dist files
    --folder-id FOLDER_ID Google drive folder id to use as remote storage for e2e tests. 
                          If not given read from GOOGLE_DRIVE_FOLDER_ID environment variable.
    --key KEY_FN          Path to google service account key file in json format
                          If not given read from GOOGLE_SERVICE_ACC_KEY environment variable.
```

## How to use

```
pip install cobra
```

### CLI

After that `cobra` command will be available from the command line.

To get the cli description please issue `cobra --help` or 
e.g. `cobra backup --help` to get help on certain command.

This will backup all the docker volumes ss well as `/want/this/dir/backed/up` 
directory, but `skip-this-volume` `and-this-one`.

```bash
cobra backup build --push --dir /want/this/dir/backed/up \
    --creds /path/to/google-service-acc-key.json --folder-id google-drive-folder-id \
    --exclude skip-this-volume and-this-one
```

This restores latest backup from the given remote folder.

```bash
cobra backup pull --latest --restore \
    --creds /path/to/google-service-acc-key.json --folder-id google-drive-folder-id
```


### Remote storage

For now Google Drive only supported. If you find this project useful you can contribute 
to enhance it. Or at least you can post a feature request.

1. To have this work the [Google Service Account](https://cloud.google.com/iam/docs/service-accounts) is necessary.
   The service account id (email) looks like `<the-name-you-choose>@hip-heading-376120.iam.gserviceaccount.com`. 
2. Under the service account you've created add the key pair and download it in `.json` format. 
3. Now create the folder within your Google Drive you wish to push the backups in.
4. Share this folder with the service account (email) from step 1.

### Python

Minimum python version is 3.7.

```python
from cobra.api import Api
from cobra.hooks import Hooks
from docker import DockerClient

api = Api(gateway=DockerClient(), hooks=Hooks())
api.backup_build()
```

Method parameters are described in cli help `cobra backup --help` e.g.
