import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AdSecretRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The mount path for the AD backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role#backend AdSecretRole#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role#id AdSecretRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role#namespace AdSecretRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role#role AdSecretRole#role}
    */
    readonly role: string;
    /**
    * The username/logon name for the service account with which this role will be associated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role#service_account_name AdSecretRole#service_account_name}
    */
    readonly serviceAccountName: string;
    /**
    * In seconds, the default password time-to-live.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role#ttl AdSecretRole#ttl}
    */
    readonly ttl?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role vault_ad_secret_role}
*/
export declare class AdSecretRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_ad_secret_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/ad_secret_role vault_ad_secret_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AdSecretRoleConfig
    */
    constructor(scope: Construct, id: string, config: AdSecretRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastVaultRotation(): string;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get passwordLastSet(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    get serviceAccountNameInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
