import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AwsAuthBackendRoleTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allows migration of the underlying instance where the client resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#allow_instance_migration AwsAuthBackendRoleTag#allow_instance_migration}
    */
    readonly allowInstanceMigration?: boolean | cdktf.IResolvable;
    /**
    * AWS auth backend to read tags from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#backend AwsAuthBackendRoleTag#backend}
    */
    readonly backend?: string;
    /**
    * Only allow a single token to be granted per instance ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#disallow_reauthentication AwsAuthBackendRoleTag#disallow_reauthentication}
    */
    readonly disallowReauthentication?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#id AwsAuthBackendRoleTag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Instance ID for which this tag is intended. The created tag can only be used by the instance with the given ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#instance_id AwsAuthBackendRoleTag#instance_id}
    */
    readonly instanceId?: string;
    /**
    * The maximum allowed lifetime of tokens issued using this role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#max_ttl AwsAuthBackendRoleTag#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#namespace AwsAuthBackendRoleTag#namespace}
    */
    readonly namespace?: string;
    /**
    * Policies to be associated with the tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#policies AwsAuthBackendRoleTag#policies}
    */
    readonly policies?: string[];
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag#role AwsAuthBackendRoleTag#role}
    */
    readonly role: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag vault_aws_auth_backend_role_tag}
*/
export declare class AwsAuthBackendRoleTag extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_aws_auth_backend_role_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/aws_auth_backend_role_tag vault_aws_auth_backend_role_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AwsAuthBackendRoleTagConfig
    */
    constructor(scope: Construct, id: string, config: AwsAuthBackendRoleTagConfig);
    private _allowInstanceMigration?;
    get allowInstanceMigration(): boolean | cdktf.IResolvable;
    set allowInstanceMigration(value: boolean | cdktf.IResolvable);
    resetAllowInstanceMigration(): void;
    get allowInstanceMigrationInput(): boolean | cdktf.IResolvable | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _disallowReauthentication?;
    get disallowReauthentication(): boolean | cdktf.IResolvable;
    set disallowReauthentication(value: boolean | cdktf.IResolvable);
    resetDisallowReauthentication(): void;
    get disallowReauthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    resetInstanceId(): void;
    get instanceIdInput(): string | undefined;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    get tagKey(): string;
    get tagValue(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
