import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultKvSecretSubkeysV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the deepest nesting level to provide in the output.If non-zero, keys that reside at the specified depth value will be artificially treated as leaves and will thus be 'null' even if further underlying sub-keys exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret_subkeys_v2#depth DataVaultKvSecretSubkeysV2#depth}
    */
    readonly depth?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret_subkeys_v2#id DataVaultKvSecretSubkeysV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Path where KV-V2 engine is mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret_subkeys_v2#mount DataVaultKvSecretSubkeysV2#mount}
    */
    readonly mount: string;
    /**
    * Full name of the secret. For a nested secret, the name is the nested path excluding the mount and data prefix. For example, for a secret at 'kvv2/data/foo/bar/baz', the name is 'foo/bar/baz'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret_subkeys_v2#name DataVaultKvSecretSubkeysV2#name}
    */
    readonly name: string;
    /**
    * Specifies the version to return. If not set the latest version is returned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secret_subkeys_v2#version DataVaultKvSecretSubkeysV2#version}
    */
    readonly version?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kv_secret_subkeys_v2 vault_kv_secret_subkeys_v2}
*/
export declare class DataVaultKvSecretSubkeysV2 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_kv_secret_subkeys_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kv_secret_subkeys_v2 vault_kv_secret_subkeys_v2} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKvSecretSubkeysV2Config
    */
    constructor(scope: Construct, id: string, config: DataVaultKvSecretSubkeysV2Config);
    get dataJson(): string;
    private _depth?;
    get depth(): number;
    set depth(value: number);
    resetDepth(): void;
    get depthInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mount?;
    get mount(): string;
    set mount(value: string);
    get mountInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get path(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
