import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultKvSecretsListConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list#id DataVaultKvSecretsList#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Full KV-V1 path where secrets will be listed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list#path DataVaultKvSecretsList#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list vault_kv_secrets_list}
*/
export declare class DataVaultKvSecretsList extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_kv_secrets_list";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list vault_kv_secrets_list} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKvSecretsListConfig
    */
    constructor(scope: Construct, id: string, config: DataVaultKvSecretsListConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get names(): string[];
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
