import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GenericSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * JSON-encoded secret data to write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#data_json GenericSecret#data_json}
    */
    readonly dataJson: string;
    /**
    * Only applicable for kv-v2 stores. If set, permanently deletes all versions for the specified key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#delete_all_versions GenericSecret#delete_all_versions}
    */
    readonly deleteAllVersions?: boolean | cdktf.IResolvable;
    /**
    * Don't attempt to read the token from Vault if true; drift won't be detected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#disable_read GenericSecret#disable_read}
    */
    readonly disableRead?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#id GenericSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#namespace GenericSecret#namespace}
    */
    readonly namespace?: string;
    /**
    * Full path where the generic secret will be written.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/generic_secret#path GenericSecret#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/generic_secret vault_generic_secret}
*/
export declare class GenericSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_generic_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/generic_secret vault_generic_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GenericSecretConfig
    */
    constructor(scope: Construct, id: string, config: GenericSecretConfig);
    private _data;
    get data(): cdktf.StringMap;
    private _dataJson?;
    get dataJson(): string;
    set dataJson(value: string);
    get dataJsonInput(): string | undefined;
    private _deleteAllVersions?;
    get deleteAllVersions(): boolean | cdktf.IResolvable;
    set deleteAllVersions(value: boolean | cdktf.IResolvable);
    resetDeleteAllVersions(): void;
    get deleteAllVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _disableRead?;
    get disableRead(): boolean | cdktf.IResolvable;
    set disableRead(value: boolean | cdktf.IResolvable);
    resetDisableRead(): void;
    get disableReadInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
