#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.add_deployment_to_application import AddDeploymentToApplication
from datarobot.models.full_api.generated.model.application_access_control_list import ApplicationAccessControlList
from datarobot.models.full_api.generated.model.application_access_control_update_request import ApplicationAccessControlUpdateRequest
from datarobot.models.full_api.generated.model.application_create import ApplicationCreate
from datarobot.models.full_api.generated.model.application_create_response import ApplicationCreateResponse
from datarobot.models.full_api.generated.model.application_deployment_state_update import ApplicationDeploymentStateUpdate
from datarobot.models.full_api.generated.model.application_deployment_update import ApplicationDeploymentUpdate
from datarobot.models.full_api.generated.model.application_list import ApplicationList
from datarobot.models.full_api.generated.model.application_model_deployment_param import ApplicationModelDeploymentParam
from datarobot.models.full_api.generated.model.application_param import ApplicationParam
from datarobot.models.full_api.generated.model.application_retrieve import ApplicationRetrieve
from datarobot.models.full_api.generated.model.application_shared_roles_entry_update import ApplicationSharedRolesEntryUpdate
from datarobot.models.full_api.generated.model.application_shared_roles_list import ApplicationSharedRolesList
from datarobot.models.full_api.generated.model.application_sharing_update_or_remove import ApplicationSharingUpdateOrRemove
from datarobot.models.full_api.generated.model.application_type_list_response import ApplicationTypeListResponse
from datarobot.models.full_api.generated.model.application_type_retrieve_response import ApplicationTypeRetrieveResponse
from datarobot.models.full_api.generated.model.application_type_usecases_list_response import ApplicationTypeUsecasesListResponse
from datarobot.models.full_api.generated.model.application_upgrade_deployment_version import ApplicationUpgradeDeploymentVersion
from datarobot.models.full_api.generated.model.application_user_role_response import ApplicationUserRoleResponse


class ApplicationsApi(APIObject):

        @classmethod
        def application_types_list(
            cls,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List of available application types to deploy.

            List of available application types to deploy.
            Args:
                offset (int): The number of records to skip over. Defaults to 0.. defaults to 0, must be one of [0]
                limit (int): The number of records to return. Defaults to 0, meaning all records.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                ApplicationTypeListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/applicationTypes/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationTypeListResponse(**server_data)

        @classmethod
        def application_types_retrieve(
            cls,
            application_type_id,
            **kwargs
        ):
            """Retrieve one application type

            Retrieve one application type
            Args:
                application_type_id (str): The application type to retrieve

            Keyword Args:
            Returns:
                ApplicationTypeRetrieveResponse
            """
            path_args = {}
            kwargs['application_type_id'] = application_type_id
            path_args['applicationTypeId'] = application_type_id
            path = '/api/v2/applicationTypes/{applicationTypeId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationTypeRetrieveResponse(**server_data)

        @classmethod
        def application_types_usecases_list(
            cls,
            application_type_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List application type usecases

            List of available usecases for application type.
            Args:
                application_type_id (str): The application type to retrieve
                offset (int): The number of records to skip over. Defaults to 0.. defaults to 0, must be one of [0]
                limit (int): The number of records to return. Defaults to 100.. defaults to 100, must be one of [100]

            Keyword Args:
            Returns:
                ApplicationTypeUsecasesListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['application_type_id'] = application_type_id
            path_args['applicationTypeId'] = application_type_id
            path = '/api/v2/applicationTypes/{applicationTypeId}/usecases/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationTypeUsecasesListResponse(**server_data)

        @classmethod
        def applications_access_control_list(
            cls,
            application_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """A list of users with access to this application

            A list of users who have access to this application and their roles
            Args:
                application_id (str): The ID of the application
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 0, must be one of [0]

            Keyword Args:
                username (str): Optional, only return the access control information for a user with this username.. [optional]
                user_id (str): Optional, only return the access control information for a user with this user ID.. [optional]
            Returns:
                ApplicationAccessControlList
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/accessControl/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationAccessControlList(**server_data)

        @classmethod
        def applications_access_control_patch_many(
            cls,
            application_id,
            **kwargs
        ):
            """Update access control for this application.

            Update access control for this application. Request is processed only if updates can be performed on all entries.
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                application_access_control_update_request (ApplicationAccessControlUpdateRequest): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/accessControl/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def applications_auth_token_patch_many(
            cls,
            application_id,
            **kwargs
        ):
            """Redeploys application with refreshed auth token.

            Redeploys application with refreshed auth token.
            Args:
                application_id (str): The ID of the application

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/authToken/'.format(**path_args)
            cls._client.patch(path)

        @classmethod
        def applications_build_jobs_create(
            cls,
            application_id,
            **kwargs
        ):
            """Schedules a build job

            Schedules a build job, which is normally automatically scheduled at the end of DataRobot autopilot. This is currently used in tests only, so this route is for internal use only.
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/buildJobs/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def applications_create(
            cls,
            **kwargs
        ):
            """Create an application

            Create an application. Note that the number of active applications users can have at the same time is limited.

            Keyword Args:
                application_create (ApplicationCreate): [optional]
            Returns:
                ApplicationCreateResponse
            """
            path_args = {}
            path = '/api/v2/applications/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationCreateResponse(**server_data)

        @classmethod
        def applications_delete(
            cls,
            application_id,
            **kwargs
        ):
            """Delete an application

            Delete an application
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                application_param (ApplicationParam): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/'.format(**path_args)
            cls._client.delete(path, data=kwargs)

        @classmethod
        def applications_deployment_state_patch_many(
            cls,
            application_id,
            **kwargs
        ):
            """Update the application's deployment state.

            Update the application's deployment state. Transitioning the app to `deactivated` state will keep the app record in the database, but the app will not be accessible at its URL until changed back to `deployed` state again. When the limit of active apps has been reached, this API can be used to deactivate some applications to make space for new ones.
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                application_deployment_state_update (ApplicationDeploymentStateUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/deploymentState/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def applications_deployments_create(
            cls,
            application_id,
            **kwargs
        ):
            """Links a deployment to an application

            If application creates deployment during its lifetime, we want to have an API to link deployment with application.
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                add_deployment_to_application (AddDeploymentToApplication): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/deployments/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def applications_deployments_delete(
            cls,
            application_id,
            model_deployment_id,
            **kwargs
        ):
            """Delete link between application and deployment.

            Delete link between application and deployment.
            Args:
                application_id (str): The ID of the application
                model_deployment_id (str): The ID of the model deployment

            Keyword Args:
                application_model_deployment_param (ApplicationModelDeploymentParam): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            kwargs['model_deployment_id'] = model_deployment_id
            path_args['modelDeploymentId'] = model_deployment_id
            path = '/api/v2/applications/{applicationId}/deployments/{modelDeploymentId}/'.format(**path_args)
            cls._client.delete(path, data=kwargs)

        @classmethod
        def applications_list(
            cls,
            offset=0,
            limit=0,
            **kwargs
        ):
            """Paginated list of applications created by the currently authenticated user.

            Paginated list of applications created by the currently authenticated user.
            Args:
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                ApplicationList
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/applications/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationList(**server_data)

        @classmethod
        def applications_patch(
            cls,
            application_id,
            **kwargs
        ):
            """Update an application's name and/or domain prefix

            Update an application's name and/or domain prefix
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                application_deployment_update (ApplicationDeploymentUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def applications_retrieve(
            cls,
            application_id,
            **kwargs
        ):
            """Retrieve an application

            Retrieve an application
            Args:
                application_id (str): The ID of the application

            Keyword Args:
            Returns:
                ApplicationRetrieve
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationRetrieve(**server_data)

        @classmethod
        def applications_shared_roles_list(
            cls,
            application_id,
            **kwargs
        ):
            """Get a list of users, groups and organizations that have an access to this application

            Get a list of users, groups and organizations that have an access to this application
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                limit (int): The number of records to return in the range of 1 to 100. [optional]
                offset (int): The number of records to skip over. Default 0.. [optional] if omitted the server will use the default value of 0
                name (str): Only return roles for a user, group or organization with this name. [optional]
                id (str): Only return roles for a user, group or organization with this id. [optional]
                share_recipient_type (str): Specify the recipient type, one of 'user', 'group', 'organization'. [optional]
                application_shared_roles_list (ApplicationSharedRolesList): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/sharedRoles/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def applications_shared_roles_patch_many(
            cls,
            note,
            operation,
            roles,
            application_id,
            send_notification=False,
            **kwargs
        ):
            """Share an application with a user, group, or organization

            Share an application with a user, group, or organization
            Args:
                note (str): A note to go with the project share
                operation (str): Name of the action being taken, only 'updateRoles' is supported
                roles ([ApplicationSharedRolesEntryUpdate]): Role objects, may contain up to 100 per request
                application_id (str): The ID of the application
                send_notification (bool): Send a notification. defaults to False, must be one of [False]

            Keyword Args:
                application_sharing_update_or_remove (ApplicationSharingUpdateOrRemove): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['send_notification'] = send_notification
            path_args['sendNotification'] = send_notification
            kwargs['note'] = note
            path_args['note'] = note
            kwargs['operation'] = operation
            path_args['operation'] = operation
            kwargs['roles'] = roles
            path_args['roles'] = roles
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/sharedRoles/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def applications_user_role_list(
            cls,
            application_id,
            **kwargs
        ):
            """Get application user role

            Get application user role
            Args:
                application_id (str): The ID of the application

            Keyword Args:
            Returns:
                ApplicationUserRoleResponse
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/userRole/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApplicationUserRoleResponse(**server_data)

        @classmethod
        def applications_version_patch_many(
            cls,
            application_id,
            **kwargs
        ):
            """Redeploys application with specified version.

            Redeploys application with specified version. If version is omitted latest available version is used.
            Args:
                application_id (str): The ID of the application

            Keyword Args:
                application_upgrade_deployment_version (ApplicationUpgradeDeploymentVersion): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['application_id'] = application_id
            path_args['applicationId'] = application_id
            path = '/api/v2/applications/{applicationId}/version/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

