#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.bias_vs_accuracy_insight_retrieve import BiasVsAccuracyInsightRetrieve
from datarobot.models.full_api.generated.model.cross_class_accuracy_create_response import CrossClassAccuracyCreateResponse
from datarobot.models.full_api.generated.model.cross_class_accuracy_list import CrossClassAccuracyList
from datarobot.models.full_api.generated.model.data_disparity_create_payload import DataDisparityCreatePayload
from datarobot.models.full_api.generated.model.data_disparity_create_response import DataDisparityCreateResponse
from datarobot.models.full_api.generated.model.data_disparity_retrieve_response import DataDisparityRetrieveResponse
from datarobot.models.full_api.generated.model.fairness_insights_list_response import FairnessInsightsListResponse
from datarobot.models.full_api.generated.model.fairness_insights_start_calculation_payload import FairnessInsightsStartCalculationPayload
from datarobot.models.full_api.generated.model.fairness_insights_start_calculation_response import FairnessInsightsStartCalculationResponse


class BiasAndFairnessApi(APIObject):

        @classmethod
        def projects_bias_vs_accuracy_insights_list(
            cls,
            project_id,
            **kwargs
        ):
            """List Bias vs Accuracy insights.

            Retrieve a list of Bias vs Accuracy insights for the model.
            Args:
                project_id (str): The project ID

            Keyword Args:
                accuracy_metric (str): The metric to return model accuracy scores. Defaults to the optimization metric configured in project options.. [optional]
                protected_feature (bool, date, datetime, dict, float, int, list, str, none_type): Name of the protected feature.. [optional]
                fairness_metric (bool, date, datetime, dict, float, int, list, str, none_type): The fairness metric used to calculate the fairness scores.. [optional]
            Returns:
                BiasVsAccuracyInsightRetrieve
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/biasVsAccuracyInsights/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BiasVsAccuracyInsightRetrieve(**server_data)

        @classmethod
        def projects_models_cross_class_accuracy_scores_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start Cross Class Accuracy calculations.

            Submits a job to start Cross Class Accuracy scores calculations for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                CrossClassAccuracyCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CrossClassAccuracyCreateResponse(**server_data)

        @classmethod
        def projects_models_cross_class_accuracy_scores_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List Cross Class Accuracy scores.

            Retrieves a list of Cross Class Accuracy scores for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
            Returns:
                CrossClassAccuracyList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CrossClassAccuracyList(**server_data)

        @classmethod
        def projects_models_data_disparity_insights_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start insight calculations.

            Submits a job to start Cross Class Data Disparity insight calculations.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                data_disparity_create_payload (DataDisparityCreatePayload): [optional]
            Returns:
                DataDisparityCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataDisparityCreateResponse(**server_data)

        @classmethod
        def projects_models_data_disparity_insights_list(
            cls,
            feature,
            class_name1,
            class_name2,
            project_id,
            model_id,
            **kwargs
        ):
            """Get Cross Class Data Disparity results.

            Retrieve a list of Cross Class Data Disparity insights for the model.
            Args:
                feature (str): Feature for which insight is computed.
                class_name1 (str): One of the compared classes.
                class_name2 (str): Another compared class.
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
            Returns:
                DataDisparityRetrieveResponse
            """
            path_args = {}
            kwargs['feature'] = feature
            path_args['feature'] = feature
            kwargs['class_name1'] = class_name1
            path_args['className1'] = class_name1
            kwargs['class_name2'] = class_name2
            path_args['className2'] = class_name2
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataDisparityRetrieveResponse(**server_data)

        @classmethod
        def projects_models_fairness_insights_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start insight calculations.

            Submits a job to start Per Class Bias insight calculations for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                fairness_insights_start_calculation_payload (FairnessInsightsStartCalculationPayload): [optional]
            Returns:
                FairnessInsightsStartCalculationResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FairnessInsightsStartCalculationResponse(**server_data)

        @classmethod
        def projects_models_fairness_insights_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List calculated Per Class Bias insights.

            Retrieve a list of Per Class Bias insights for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
                fairness_metrics_set (str): The fairness metric used to calculate the fairness scores.. [optional]
            Returns:
                FairnessInsightsListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FairnessInsightsListResponse(**server_data)

