#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.blueprint_chart_retrieve_response import BlueprintChartRetrieveResponse
from datarobot.models.full_api.generated.model.blueprint_list_documents_response import BlueprintListDocumentsResponse
from datarobot.models.full_api.generated.model.blueprint_response import BlueprintResponse
from datarobot.models.full_api.generated.model.custom_model_artifacts_response import CustomModelArtifactsResponse
from datarobot.models.full_api.generated.model.persistent_model_logs_retrieve_response import PersistentModelLogsRetrieveResponse


class BlueprintsApi(APIObject):

        @classmethod
        def projects_blueprints_blueprint_chart_list(
            cls,
            project_id,
            blueprint_id,
            **kwargs
        ):
            """Retrieve a blueprint chart by blueprint id.

            Retrieve a blueprint chart by blueprint id.
            Args:
                project_id (str): The project ID.
                blueprint_id (str): The blueprint ID.

            Keyword Args:
            Returns:
                BlueprintChartRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['blueprint_id'] = blueprint_id
            path_args['blueprintId'] = blueprint_id
            path = '/api/v2/projects/{projectId}/blueprints/{blueprintId}/blueprintChart/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlueprintChartRetrieveResponse(**server_data)

        @classmethod
        def projects_blueprints_blueprint_docs_list(
            cls,
            project_id,
            blueprint_id,
            **kwargs
        ):
            """Retrieve blueprint tasks documentation.

            Retrieve blueprint tasks documentation.
            Args:
                project_id (str): The project ID.
                blueprint_id (str): The blueprint ID.

            Keyword Args:
            Returns:
                BlueprintListDocumentsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['blueprint_id'] = blueprint_id
            path_args['blueprintId'] = blueprint_id
            path = '/api/v2/projects/{projectId}/blueprints/{blueprintId}/blueprintDocs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlueprintListDocumentsResponse(**server_data)

        @classmethod
        def projects_blueprints_list(
            cls,
            project_id,
            **kwargs
        ):
            """List blueprints

            List appropriate blueprints for the project.
            Args:
                project_id (str): The project ID.

            Keyword Args:
            Returns:
                BlueprintResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/blueprints/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlueprintResponse(**server_data)

        @classmethod
        def projects_blueprints_retrieve(
            cls,
            project_id,
            blueprint_id,
            **kwargs
        ):
            """Retrieve a blueprint by its ID.

            Retrieve a blueprint by its ID.
            Args:
                project_id (str): The project ID.
                blueprint_id (str): The blueprint ID.

            Keyword Args:
            Returns:
                BlueprintResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['blueprint_id'] = blueprint_id
            path_args['blueprintId'] = blueprint_id
            path = '/api/v2/projects/{projectId}/blueprints/{blueprintId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlueprintResponse(**server_data)

        @classmethod
        def projects_models_blueprint_chart_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a reduced model blueprint chart by model id.

            Retrieve a reduced model blueprint chart by model id. The model blueprint charts are reduced from the full blueprint charts to show only those sections of the blueprint that were actually used in the model, given the selected featurelist.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                BlueprintChartRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/blueprintChart/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlueprintChartRetrieveResponse(**server_data)

        @classmethod
        def projects_models_blueprint_docs_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve task documentation for a reduced model blueprint.

            Retrieve task documentation for a reduced model blueprint. The model blueprint is reduced from the full blueprint to show only those sections of the blueprint that were actually used in the model, given the selected featurelist.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                BlueprintListDocumentsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/blueprintDocs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlueprintListDocumentsResponse(**server_data)

        @classmethod
        def projects_models_logs_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve an archive (tar.gz) of the logs produced and persisted by a model.

            Retrieve an archive (tar.gz) of the logs produced and persisted by a model. Note that only blueprints with custom tasks create persistent logs - this will not work with any other type of model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                PersistentModelLogsRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/logs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PersistentModelLogsRetrieveResponse(**server_data)

        @classmethod
        def projects_models_training_artifact_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve an archive (tar.gz) of the artifacts produced and persisted by a model.

            Retrieve an archive (tar.gz) of the artifacts produced and persisted by a model. Note that only blueprints with custom tasks create these artifacts - this will not work with any other type of model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                CustomModelArtifactsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/trainingArtifact/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelArtifactsResponse(**server_data)

