#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.calendar_access_control_list_response import CalendarAccessControlListResponse
from datarobot.models.full_api.generated.model.calendar_access_control_update import CalendarAccessControlUpdate
from datarobot.models.full_api.generated.model.calendar_file_upload import CalendarFileUpload
from datarobot.models.full_api.generated.model.calendar_from_dataset import CalendarFromDataset
from datarobot.models.full_api.generated.model.calendar_list_response import CalendarListResponse
from datarobot.models.full_api.generated.model.calendar_name_update import CalendarNameUpdate
from datarobot.models.full_api.generated.model.calendar_record import CalendarRecord
from datarobot.models.full_api.generated.model.created_calendar_dataset_response import CreatedCalendarDatasetResponse
from datarobot.models.full_api.generated.model.preloaded_calendar import PreloadedCalendar
from datarobot.models.full_api.generated.model.preloaded_calendar_list_response import PreloadedCalendarListResponse


class CalendarsApi(APIObject):

        @classmethod
        def calendar_country_codes_list(
            cls,
            **kwargs
        ):
            """Retrieve the list of allowed country codes to request preloaded calendars generation for.

            Retrieve the list of allowed country codes to request preloaded calendars generation for.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
            Returns:
                PreloadedCalendarListResponse
            """
            path_args = {}
            path = '/api/v2/calendarCountryCodes/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PreloadedCalendarListResponse(**server_data)

        @classmethod
        def calendars_access_control_list(
            cls,
            calendar_id,
            **kwargs
        ):
            """Get a list of users who have access to this calendar and their roles on the calendar.

            Get a list of users who have access to this calendar and their roles on the calendar.
            Args:
                calendar_id (str): The ID of this calendar.

            Keyword Args:
                username (str): Optional, only return the access control information for a user with this username. Should not be specified if `userId` is specified.. [optional]
                user_id (str): Optional, only return the access control information for a user with this user ID. Should not be specified if `username` is specified.. [optional]
                offset (int): Optional (default: `0`), this many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): Optional (default: `0`), at most this many results will be returned. If `0`, all results will be returned.. [optional] if omitted the server will use the default value of 0
            Returns:
                CalendarAccessControlListResponse
            """
            path_args = {}
            kwargs['calendar_id'] = calendar_id
            path_args['calendarId'] = calendar_id
            path = '/api/v2/calendars/{calendarId}/accessControl/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CalendarAccessControlListResponse(**server_data)

        @classmethod
        def calendars_access_control_patch_many(
            cls,
            calendar_id,
            **kwargs
        ):
            """Update the access control for this calendar.

            Update the access control for this calendar. See the `entity sharing documentation <sharing>` for more information.
            Args:
                calendar_id (str): The ID of this calendar.

            Keyword Args:
                calendar_access_control_update (CalendarAccessControlUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['calendar_id'] = calendar_id
            path_args['calendarId'] = calendar_id
            path = '/api/v2/calendars/{calendarId}/accessControl/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def calendars_delete(
            cls,
            calendar_id,
            **kwargs
        ):
            """Delete a calendar.

            Delete a calendar. This can only be done if all projects and deployments using the calendar have been deleted.
            Args:
                calendar_id (str): The ID of this calendar.

            Keyword Args:
            Returns:
                dict
            """
            path_args = {}
            kwargs['calendar_id'] = calendar_id
            path_args['calendarId'] = calendar_id
            path = '/api/v2/calendars/{calendarId}/'.format(**path_args)
            server_data = (cls._client.delete(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return server_data

        @classmethod
        def calendars_file_upload_create(
            cls,
            **kwargs
        ):
            """Create a calendar from a file.

            Create a calendar from a file in a csv or xlsx format. The calendar file specifies the dates or events in a dataset such that DataRobot automatically derives and creates special features based on the calendar events (e.g., time until the next event, labeling the most recent event).

            Keyword Args:
                calendar_file_upload (CalendarFileUpload): [optional]
            Returns:
                dict
            """
            path_args = {}
            path = '/api/v2/calendars/fileUpload/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return dict(**server_data)

        @classmethod
        def calendars_from_country_code_create(
            cls,
            **kwargs
        ):
            """Initialize generation of preloaded calendars.

            Initialize generation of preloaded calendars. Preloaded calendars are available only for time series projects. Preloaded calendars do not support multiseries calendars.

            Keyword Args:
                preloaded_calendar (PreloadedCalendar): [optional]
            Returns:
                dict
            """
            path_args = {}
            path = '/api/v2/calendars/fromCountryCode/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return dict(**server_data)

        @classmethod
        def calendars_from_dataset_create(
            cls,
            **kwargs
        ):
            """Create a calendar from the dataset

            Create a calendar from the dataset.

            Keyword Args:
                calendar_from_dataset (CalendarFromDataset): [optional]
            Returns:
                CreatedCalendarDatasetResponse
            """
            path_args = {}
            path = '/api/v2/calendars/fromDataset/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedCalendarDatasetResponse(**server_data)

        @classmethod
        def calendars_list(
            cls,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List all available calendars for a user.

            List all the calendars which the user has access to.
            Args:
                offset (int): Optional (default: `0`), this many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): Optional (default: `0`), at most this many results will be returned. If `0`, all results will be returned.. defaults to 0, must be one of [0]

            Keyword Args:
                project_id (str): Optional, if provided will filter returned calendars to those being used in the specified project.. [optional]
            Returns:
                CalendarListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/calendars/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CalendarListResponse(**server_data)

        @classmethod
        def calendars_patch(
            cls,
            calendar_id,
            **kwargs
        ):
            """Update a calendar's name

            Update a calendar's name
            Args:
                calendar_id (str): The ID of this calendar.

            Keyword Args:
                calendar_name_update (CalendarNameUpdate): [optional]
            Returns:
                dict
            """
            path_args = {}
            kwargs['calendar_id'] = calendar_id
            path_args['calendarId'] = calendar_id
            path = '/api/v2/calendars/{calendarId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return dict(**server_data)

        @classmethod
        def calendars_retrieve(
            cls,
            calendar_id,
            **kwargs
        ):
            """Retrieve information about a calendar.

            List all the information about a calendar such as the total number of event dates, the earliest calendar event date, the IDs of projects currently using this calendar and the others.
            Args:
                calendar_id (str): The ID of this calendar.

            Keyword Args:
            Returns:
                CalendarRecord
            """
            path_args = {}
            kwargs['calendar_id'] = calendar_id
            path_args['calendarId'] = calendar_id
            path = '/api/v2/calendars/{calendarId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CalendarRecord(**server_data)

