#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.catalog_details_retrieve_response import CatalogDetailsRetrieveResponse
from datarobot.models.full_api.generated.model.catalog_extended_details_response import CatalogExtendedDetailsResponse
from datarobot.models.full_api.generated.model.catalog_list_search_response import CatalogListSearchResponse
from datarobot.models.full_api.generated.model.update_catalog_metadata import UpdateCatalogMetadata


class CatalogItemsApi(APIObject):

        @classmethod
        def catalog_items_list(
            cls,
            offset=0,
            limit=0,
            initial_cache_size=500,
            **kwargs
        ):
            """List all catalog items accessible by the user.

            List all catalog items accessible by the user.
            Args:
                offset (int): Specifies the number of results to skip for pagination.. defaults to 0, must be one of [0]
                limit (int): Sets the maximum number of results returned. Enter 0 to specify no limit.. defaults to 0, must be one of [0]
                initial_cache_size (int): The initial cache size, for Mongo search only.. defaults to 500, must be one of [500]

            Keyword Args:
                use_cache (str): Sets whether to use the cache, for Mongo search only.. [optional] if omitted the server will use the default value of "false"
                order_by (str): The attribute sort order applied to the returned catalog list: 'catalogName', 'originalName', 'description', 'created', or 'relevance'. For all options other than 'relevance', prefix the attribute name with a dash to sort in descending order. e.g., orderBy='-catalogName'. Defaults to '-created'.. [optional]
                search_for (str): A value to search for in the dataset's name, description, tags, column names, categories, and latest errors. The search is case insensitive. If no value is provided, or if the empty string is used, or if the string contains only whitespace, no filtering occurs. Partial matching is performed on the dataset name and description fields; all other fields require an exact match.. [optional]
                tag (bool, date, datetime, dict, float, int, list, str, none_type): Filter results to display only items with the specified catalog item tags, in lower case, with no spaces.. [optional]
                access_type (str): Access type used to filter returned results. Valid options are 'owner', 'shared', 'created', and 'any' (the default): 'owner' items are owned by the requester, 'shared' items have been shared with the requester, 'created' items have been created by the requester, and 'any' items matches all.. [optional] if omitted the server will use the default value of "any"
                datasource_type (bool, date, datetime, dict, float, int, list, str, none_type): Data source types used for filtering.. [optional]
                category (bool, date, datetime, dict, float, int, list, str, none_type): Category type(s) used for filtering. Searches are case sensitive and support '&' and 'OR' operators.. [optional]
                filter_failed (str): Sets whether to exclude from the search results all catalog items that failed during import. If True, invalid catalog items will be excluded; default is False.. [optional] if omitted the server will use the default value of "false"
                owner_user_id (bool, date, datetime, dict, float, int, list, str, none_type): Filter results to display only those owned by user(s) identified by the specified UID.. [optional]
                owner_username (bool, date, datetime, dict, float, int, list, str, none_type): Filter results to display only those owned by user(s) identified by the specified username.. [optional]
                type (str): Filter results by catalog type. The 'dataset' option matches both 'snapshot_dataset' and 'remote_dataset'.. [optional]
            Returns:
                CatalogListSearchResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['initial_cache_size'] = initial_cache_size
            path_args['initialCacheSize'] = initial_cache_size
            path = '/api/v2/catalogItems/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CatalogListSearchResponse(**server_data)

        @classmethod
        def catalog_items_patch(
            cls,
            catalog_id,
            **kwargs
        ):
            """Update the name, description, or tags for the requested catalog item.

            Update the name, description, or tags for the requested catalog item.
            Args:
                catalog_id (str): Catalog item ID.

            Keyword Args:
                update_catalog_metadata (UpdateCatalogMetadata): [optional]
            Returns:
                CatalogExtendedDetailsResponse
            """
            path_args = {}
            kwargs['catalog_id'] = catalog_id
            path_args['catalogId'] = catalog_id
            path = '/api/v2/catalogItems/{catalogId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CatalogExtendedDetailsResponse(**server_data)

        @classmethod
        def catalog_items_retrieve(
            cls,
            catalog_id,
            **kwargs
        ):
            """Retrieves latest version information, by ID, for catalog items.

            Retrieves latest version information, by ID, for catalog items.
            Args:
                catalog_id (str): Catalog item ID.

            Keyword Args:
            Returns:
                CatalogDetailsRetrieveResponse
            """
            path_args = {}
            kwargs['catalog_id'] = catalog_id
            path_args['catalogId'] = catalog_id
            path = '/api/v2/catalogItems/{catalogId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CatalogDetailsRetrieveResponse(**server_data)

