#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.comment import Comment
from datarobot.models.full_api.generated.model.comment_retrieve import CommentRetrieve
from datarobot.models.full_api.generated.model.comment_update import CommentUpdate


class CommentsApi(APIObject):

        @classmethod
        def comments_create(
            cls,
            **kwargs
        ):
            """Post a comment

            Post a comment

            Keyword Args:
                comment (Comment): [optional]
            Returns:
                CommentRetrieve
            """
            path_args = {}
            path = '/api/v2/comments/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CommentRetrieve(**server_data)

        @classmethod
        def comments_delete(
            cls,
            comment_id,
            **kwargs
        ):
            """Delete a comment

            Delete a comment
            Args:
                comment_id (str): The ID of the comment

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['comment_id'] = comment_id
            path_args['commentId'] = comment_id
            path = '/api/v2/comments/{commentId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def comments_list(
            cls,
            entity_id,
            entity_type,
            **kwargs
        ):
            """List comments

            List comments
            Args:
                entity_id (str): ID of the entity to retrieve comments of
                entity_type (str): Type of the entity to retrieve a comments of, currently only useCase is supported

            Keyword Args:
                offset (int): The number of records to skip over. Default 0.. [optional] if omitted the server will use the default value of 0
                limit (int): The number of records to return in the range from 1 to 100. Default 100.. [optional] if omitted the server will use the default value of 100
                order_by (str): Sort comments by a field of the comment.. [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['entity_id'] = entity_id
            path_args['entityId'] = entity_id
            kwargs['entity_type'] = entity_type
            path_args['entityType'] = entity_type
            path = '/api/v2/comments/{entityType}/{entityId}/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def comments_patch(
            cls,
            comment_id,
            **kwargs
        ):
            """Update a comment

            Update a comment
            Args:
                comment_id (str): The ID of the comment

            Keyword Args:
                comment_update (CommentUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['comment_id'] = comment_id
            path_args['commentId'] = comment_id
            path = '/api/v2/comments/{commentId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def comments_retrieve(
            cls,
            comment_id,
            **kwargs
        ):
            """Retrieve a comment

            Retrieve a comment
            Args:
                comment_id (str): The ID of the comment

            Keyword Args:
            Returns:
                CommentRetrieve
            """
            path_args = {}
            kwargs['comment_id'] = comment_id
            path_args['commentId'] = comment_id
            path = '/api/v2/comments/{commentId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CommentRetrieve(**server_data)

