#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.create_credentials_response import CreateCredentialsResponse
from datarobot.models.full_api.generated.model.credentials_association_update import CredentialsAssociationUpdate
from datarobot.models.full_api.generated.model.credentials_body import CredentialsBody
from datarobot.models.full_api.generated.model.credentials_list_associations_response import CredentialsListAssociationsResponse
from datarobot.models.full_api.generated.model.credentials_list_response import CredentialsListResponse
from datarobot.models.full_api.generated.model.credentials_update import CredentialsUpdate


class CredentialsApi(APIObject):

        @classmethod
        def credentials_associations_list(
            cls,
            credential_id,
            **kwargs
        ):
            """List all objects associated with the specified credentials.

            List all objects associated with specified credentials for the current user.
            Args:
                credential_id (str): Credentials entity ID.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                types (bool, date, datetime, dict, float, int, list, str, none_type): Includes only credentials of the specified type. Repeat the parameter for filtering on multiple statuses.. [optional]
            Returns:
                CredentialsListAssociationsResponse
            """
            path_args = {}
            kwargs['credential_id'] = credential_id
            path_args['credentialId'] = credential_id
            path = '/api/v2/credentials/{credentialId}/associations/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CredentialsListAssociationsResponse(**server_data)

        @classmethod
        def credentials_associations_patch_many(
            cls,
            credential_id,
            **kwargs
        ):
            """Add objects associated with credentials

            Add objects associated with credentials
            Args:
                credential_id (str): Credentials entity ID.

            Keyword Args:
                credentials_association_update (CredentialsAssociationUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['credential_id'] = credential_id
            path_args['credentialId'] = credential_id
            path = '/api/v2/credentials/{credentialId}/associations/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def credentials_create(
            cls,
            **kwargs
        ):
            """Store a new set of credentials which can be used for data sources creation.

            Store a new set of credentials.

            Keyword Args:
                credentials_body (CredentialsBody): [optional]
            Returns:
                CreateCredentialsResponse
            """
            path_args = {}
            path = '/api/v2/credentials/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreateCredentialsResponse(**server_data)

        @classmethod
        def credentials_delete(
            cls,
            credential_id,
            **kwargs
        ):
            """Delete the credentials set.

            Delete the credential set matching the specified ID if it is not used by any data connection or batch prediction job.
            Args:
                credential_id (str): Credentials entity ID.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['credential_id'] = credential_id
            path_args['credentialId'] = credential_id
            path = '/api/v2/credentials/{credentialId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def credentials_list(
            cls,
            **kwargs
        ):
            """List credentials.

            List all sets of credentials available for given user.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                types (bool, date, datetime, dict, float, int, list, str, none_type): Includes only credentials of the specified type. Repeat the parameter for filtering on multiple statuses.. [optional]
            Returns:
                CredentialsListResponse
            """
            path_args = {}
            path = '/api/v2/credentials/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CredentialsListResponse(**server_data)

        @classmethod
        def credentials_patch(
            cls,
            credential_id,
            **kwargs
        ):
            """Update specified credentials

            Update specified credentials
            Args:
                credential_id (str): Credentials entity ID.

            Keyword Args:
                credentials_update (CredentialsUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['credential_id'] = credential_id
            path_args['credentialId'] = credential_id
            path = '/api/v2/credentials/{credentialId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def credentials_retrieve(
            cls,
            credential_id,
            **kwargs
        ):
            """Retrieve the credentials set.

            Return the credential set matching the specified ID.
            Args:
                credential_id (str): Credentials entity ID.

            Keyword Args:
            Returns:
                CreateCredentialsResponse
            """
            path_args = {}
            kwargs['credential_id'] = credential_id
            path_args['credentialId'] = credential_id
            path = '/api/v2/credentials/{credentialId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreateCredentialsResponse(**server_data)

