#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.cross_class_accuracy_create_response import CrossClassAccuracyCreateResponse
from datarobot.models.full_api.generated.model.cross_class_accuracy_list import CrossClassAccuracyList


class CrossClassAccuracyApi(APIObject):

        @classmethod
        def projects_models_cross_class_accuracy_scores_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start Cross Class Accuracy calculations.

            Submits a job to start Cross Class Accuracy scores calculations for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                CrossClassAccuracyCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CrossClassAccuracyCreateResponse(**server_data)

        @classmethod
        def projects_models_cross_class_accuracy_scores_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List Cross Class Accuracy scores.

            Retrieves a list of Cross Class Accuracy scores for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
            Returns:
                CrossClassAccuracyList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CrossClassAccuracyList(**server_data)

