#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.base_dependency_build_metadata_response import BaseDependencyBuildMetadataResponse
from datarobot.models.full_api.generated.model.custom_model_access_control_list_response import CustomModelAccessControlListResponse
from datarobot.models.full_api.generated.model.custom_model_access_control_update_response import CustomModelAccessControlUpdateResponse
from datarobot.models.full_api.generated.model.custom_model_async_operation_response import CustomModelAsyncOperationResponse
from datarobot.models.full_api.generated.model.custom_model_copy import CustomModelCopy
from datarobot.models.full_api.generated.model.custom_model_create import CustomModelCreate
from datarobot.models.full_api.generated.model.custom_model_deployment_list_response import CustomModelDeploymentListResponse
from datarobot.models.full_api.generated.model.custom_model_list_response import CustomModelListResponse
from datarobot.models.full_api.generated.model.custom_model_prediction_explanations import CustomModelPredictionExplanations
from datarobot.models.full_api.generated.model.custom_model_resource_limits import CustomModelResourceLimits
from datarobot.models.full_api.generated.model.custom_model_response import CustomModelResponse
from datarobot.models.full_api.generated.model.custom_model_tests import CustomModelTests
from datarobot.models.full_api.generated.model.custom_model_tests_list_response import CustomModelTestsListResponse
from datarobot.models.full_api.generated.model.custom_model_tests_log_tail_response import CustomModelTestsLogTailResponse
from datarobot.models.full_api.generated.model.custom_model_tests_response import CustomModelTestsResponse
from datarobot.models.full_api.generated.model.custom_model_update import CustomModelUpdate
from datarobot.models.full_api.generated.model.custom_model_version_create_from_repository import CustomModelVersionCreateFromRepository
from datarobot.models.full_api.generated.model.custom_model_version_list_response import CustomModelVersionListResponse
from datarobot.models.full_api.generated.model.custom_model_version_metadata_update import CustomModelVersionMetadataUpdate
from datarobot.models.full_api.generated.model.custom_model_version_response import CustomModelVersionResponse
from datarobot.models.full_api.generated.model.custom_training_blueprint_create import CustomTrainingBlueprintCreate
from datarobot.models.full_api.generated.model.custom_training_blueprint_list_response import CustomTrainingBlueprintListResponse
from datarobot.models.full_api.generated.model.custom_training_blueprint_response import CustomTrainingBlueprintResponse
from datarobot.models.full_api.generated.model.dependency_build_log_response import DependencyBuildLogResponse
from datarobot.models.full_api.generated.model.feature_impact_create_payload import FeatureImpactCreatePayload
from datarobot.models.full_api.generated.model.feature_impact_create_response import FeatureImpactCreateResponse
from datarobot.models.full_api.generated.model.feature_impact_response import FeatureImpactResponse
from datarobot.models.full_api.generated.model.sharing_update_or_remove_with_grant import SharingUpdateOrRemoveWithGrant
from datarobot.models.full_api.generated.model.training_data_assignment import TrainingDataAssignment


class CustomModelsApi(APIObject):

        @classmethod
        def custom_inference_images_feature_impact_create(
            cls,
            image_id,
            **kwargs
        ):
            """Create custom model feature impact.

            Add a request to calculate feature impact for a custom inference model image to             the queue.  .. minversion:: v2.23     DEPRECATED: please use version route instead:     :http:post:`/api/v2/customModels/(customModelId)/versions/(customModelVersionId)/featureImpact/`  This route is a counterpart of a corresponding endpoint for native models: :http:post:`/api/v2/projects/(projectId)/models/(modelId)/featureImpact/` 
            Args:
                image_id (str): ID of the image of the custom inference model to submit feature impact job for.

            Keyword Args:
                feature_impact_create_payload (FeatureImpactCreatePayload): [optional]
            Returns:
                FeatureImpactCreateResponse
            """
            path_args = {}
            kwargs['image_id'] = image_id
            path_args['imageId'] = image_id
            path = '/api/v2/customInferenceImages/{imageId}/featureImpact/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureImpactCreateResponse(**server_data)

        @classmethod
        def custom_inference_images_feature_impact_list(
            cls,
            image_id,
            **kwargs
        ):
            """Get custom model feature impact.

            Retrieve feature impact scores for features in a custom inference model image.  .. minversion:: v2.23     DEPRECATED: please use version route instead:     :http:get:`/api/v2/customModels/(customModelId)/versions/(customModelVersionId)/featureImpact/`  This route is a counterpart of a corresponding endpoint for native models: :http:get:`/api/v2/projects/(projectId)/models/(modelId)/featureImpact/` 
            Args:
                image_id (str): ID of the image of the custom inference model to retrieve feature impact from.

            Keyword Args:
            Returns:
                FeatureImpactResponse
            """
            path_args = {}
            kwargs['image_id'] = image_id
            path_args['imageId'] = image_id
            path = '/api/v2/customInferenceImages/{imageId}/featureImpact/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureImpactResponse(**server_data)

        @classmethod
        def custom_model_deployments_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List custom model deployments.

            List of model deployments for user sorted by creation time descending.
            Args:
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 100, must be one of [100]

            Keyword Args:
                custom_model_ids (bool, date, datetime, dict, float, int, list, str, none_type): List of ID's of the custom model which model deployments will be retrieved.. [optional]
                environment_ids (bool, date, datetime, dict, float, int, list, str, none_type): List of ID's of the execution environment which model deployments will be retrieved.. [optional]
            Returns:
                CustomModelDeploymentListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/customModelDeployments/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelDeploymentListResponse(**server_data)

        @classmethod
        def custom_model_limits_list(
            cls,
            **kwargs
        ):
            """Get custom model resource limits.

            Retrieve custom model resource limits the user has access to.

            Keyword Args:
            Returns:
                CustomModelResourceLimits
            """
            path_args = {}
            path = '/api/v2/customModelLimits/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelResourceLimits(**server_data)

        @classmethod
        def custom_model_tests_create(
            cls,
            **kwargs
        ):
            """Create custom model test.

            Test a custom inference model. This will start a job to check that the custom model can make predictions against the supplied dataset without breaking.

            Keyword Args:
                custom_model_tests (CustomModelTests): [optional]
            Returns:
                CustomModelAsyncOperationResponse
            """
            path_args = {}
            path = '/api/v2/customModelTests/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelAsyncOperationResponse(**server_data)

        @classmethod
        def custom_model_tests_delete(
            cls,
            custom_model_test_id,
            **kwargs
        ):
            """Cancel custom model test.

            Cancel custom inference model testing.
            Args:
                custom_model_test_id (str): ID of the testing history attempt.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_test_id'] = custom_model_test_id
            path_args['customModelTestId'] = custom_model_test_id
            path = '/api/v2/customModelTests/{customModelTestId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def custom_model_tests_list(
            cls,
            custom_model_id,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """List custom model tests.

            Retrieve the testing history for a model.
            Args:
                custom_model_id (str): ID of the Custom Model to retrieve testing history for.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 1000, must be one of [1000]

            Keyword Args:
                network_egress_policy (str, none_type): Network egress policy.. [optional]
                desired_memory (int, none_type): The amount of memory that is expected to be allocated by the custom model.. [optional]
                maximum_memory (int, none_type): The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. [optional]
                replicas (int, none_type): A fixed number of replicas that will be set for the given custom-model.. [optional]
                requires_ha (bool, none_type): Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. [optional]
            Returns:
                CustomModelTestsListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModelTests/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelTestsListResponse(**server_data)

        @classmethod
        def custom_model_tests_log_list(
            cls,
            custom_model_test_id,
            **kwargs
        ):
            """Get custom model test log.

            Retrieve the logs from a model testing attempt.
            Args:
                custom_model_test_id (str): ID of the testing history attempt.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_test_id'] = custom_model_test_id
            path_args['customModelTestId'] = custom_model_test_id
            path = '/api/v2/customModelTests/{customModelTestId}/log/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def custom_model_tests_retrieve(
            cls,
            custom_model_test_id,
            **kwargs
        ):
            """Get custom model test.

            Retrieve a specific testing history entry for a custom model.
            Args:
                custom_model_test_id (str): ID of the testing history attempt.

            Keyword Args:
            Returns:
                CustomModelTestsResponse
            """
            path_args = {}
            kwargs['custom_model_test_id'] = custom_model_test_id
            path_args['customModelTestId'] = custom_model_test_id
            path = '/api/v2/customModelTests/{customModelTestId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelTestsResponse(**server_data)

        @classmethod
        def custom_model_tests_tail_list(
            cls,
            custom_model_test_id,
            lines=100,
            **kwargs
        ):
            """Get custom model test log tail.

            Retrieve the last N lines of logs from a model testing attempt.
            Args:
                custom_model_test_id (str): ID of the testing history attempt.
                lines (int): Number of lines from the log to retrieve (1-1000, default 100).. defaults to 100, must be one of [100]

            Keyword Args:
            Returns:
                CustomModelTestsLogTailResponse
            """
            path_args = {}
            kwargs['lines'] = lines
            path_args['lines'] = lines
            kwargs['custom_model_test_id'] = custom_model_test_id
            path_args['customModelTestId'] = custom_model_test_id
            path = '/api/v2/customModelTests/{customModelTestId}/tail/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelTestsLogTailResponse(**server_data)

        @classmethod
        def custom_models_access_control_list(
            cls,
            custom_model_id,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """Get a list of users who have access to this custom model and their roles on it.

            Get a list of users who have access to this custom model and their roles on it.
            Args:
                custom_model_id (str): ID of the custom model.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 1000, must be one of [1000]

            Keyword Args:
            Returns:
                CustomModelAccessControlListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/accessControl/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelAccessControlListResponse(**server_data)

        @classmethod
        def custom_models_access_control_patch_many(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Grant access or update roles for users on this custom model and appropriate learning data.

            Grant access or update roles for users on this custom model and appropriate learning data. Up to 100 user roles may be set in a single request.
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
                sharing_update_or_remove_with_grant (SharingUpdateOrRemoveWithGrant): [optional]
            Returns:
                CustomModelAccessControlUpdateResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/accessControl/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelAccessControlUpdateResponse(**server_data)

        @classmethod
        def custom_models_create(
            cls,
            **kwargs
        ):
            """Create custom model.

             Creates a new custom model and returns the newly created metadata record for it.  All custom models must support at least one target type (binaryClassification, regression). Custom inference models can only support a single target type.  A regression model is expected to produce predictions that are arbitrary floating-point or integer numbers. A classification model is expected to return predictions with probability scores for each class.  For example, a binary classification model might return:  .. code:: Python      {         positiveClassLabel: probability,         negativeClassLabel: 1.0 - probability     }  For Custom Inference Models, the ``file`` parameter must be either a tarball or zip archive containing, at minimum, a script named ``start_server.sh``.  It may contain additional files, including scripts and precompiled binaries as well as data files.  ``start_server.sh`` may execute these scripts and/or binaries.  When this script is executed, it is run as part of an Environment (specified via subsequent API calls), and all included scripts and binaries can take advantage of any programming language interpreters, compilers, libraries, or other tools included in the Environment. ``start_server.sh`` must be marked as executable (``chmod +x``).  When ``start_server.sh`` is launched, it must launch and maintain (in the foreground) a Web server that listens on two URLs:  * ``GET $URL_PREFIX/``     This route must return a 200 response code with an empty body immediately     if the server is ready to respond to prediction requests.  Otherwise it should     either not accept the request, not respond to the request, or return a     503 response code. * ``POST $URL_PREFIX/predict_no_state/``     This route must accept as input a JSON object of the form:      .. code-block:: Python          {             'X': {                 'col1': [...col1_data...],                 'col2': [...col2_data...],                 'col3': [...col3_data...],                 ...             }         }      The data lists will all be the same length.      It must return a JSON object of the form:      .. code-block:: Python          {             'predictions': [...predictions data...]         }      The predictions data must correspond 1:1 to the rows in the input data lists.      ``$URL_PREFIX`` is provided as an environment variable.  The Web server process must     re-read its value every time the process starts, as it may change.     It is an opaque string that is guaranteed to be a valid URL component,     but may contain path separators (``/``). 

            Keyword Args:
                custom_model_create (CustomModelCreate): [optional]
            Returns:
                CustomModelResponse
            """
            path_args = {}
            path = '/api/v2/customModels/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelResponse(**server_data)

        @classmethod
        def custom_models_delete(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Delete custom model.

            Delete a custom model. Only users who have permission to edit custom model can delete it. Only custom models which are not currently deployed or undergoing custom model testing can be deleted. Relevant CustomModelImage will be deleted also.
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def custom_models_download_list(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Download the latest custom model version content.

            Download the latest item bundle from a custom model as a zip compressed archive.
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
                pps (str): Download model version from PPS tab.If \"true\" specified, model archive includes dependencies install script. If \"false\" specified, dependencies script is not included. If not specified -> \"false\" behavior.. [optional] if omitted the server will use the default value of "False"
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/download/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def custom_models_from_custom_model_create(
            cls,
            **kwargs
        ):
            """Clone custom model.

            Creates a copy of the provided custom model, including metadata, versions of that model, and uploaded files. Associates the new versions with files owned by the custom model.

            Keyword Args:
                custom_model_copy (CustomModelCopy): [optional]
            Returns:
                CustomModelResponse
            """
            path_args = {}
            path = '/api/v2/customModels/fromCustomModel/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelResponse(**server_data)

        @classmethod
        def custom_models_list(
            cls,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """List custom models.

            Retrieve metadata for all custom models the user has access to.
            Args:
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 1000, must be one of [1000]

            Keyword Args:
                custom_model_type (str): If \"training\" specified, only custom training Models will be returned. If \"inference\" specified, only custom inference models will be returned. If not specified, all custom models will be returned.. [optional]
                is_deployed (str): If \"true\" specified, only deployed custom models will be returned. If \"false\" specified, only not deployed custom models will be returned. If not specified, all custom models will be returned.. [optional]
                order_by (str): Sort order which will be applied to custom model list, valid options are \"created\", \"updated\". Prefix the attribute name with a dash to sort in descending order, e.g. orderBy=\"-created\". By default, the orderBy parameter is None which will result in custom models being returned in order of creation time descending.. [optional]
                search_for (str): String to search for occurrence in custom model's description, language and name. Search is case insensitive. If not specified, all custom models will be returned.. [optional]
            Returns:
                CustomModelListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/customModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelListResponse(**server_data)

        @classmethod
        def custom_models_patch(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Update custom model.

             Updates metadata for an existing custom model.  All custom models must support at least one target type (binaryClassification, regression). Custom inference models can only support a single target type.  Setting `positiveClassLabel` and `negativeClassLabel` to null will set the labels to their default values (1 and 0 for positiveClassLabel and negativeClassLabel, respectively).  Setting `positiveClassLabel`, `negativeClassLabel`, 'targetName` is disabled if model has active deployments or assigned training data. 
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
                custom_model_update (CustomModelUpdate): [optional]
            Returns:
                CustomModelResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelResponse(**server_data)

        @classmethod
        def custom_models_prediction_explanations_initialization_create(
            cls,
            **kwargs
        ):
            """Create a new prediction explanations initialization for custom model.

            Create a new prediction explanations initialization for custom model. This is a necessary prerequisite for generating prediction explanations.  .. minversion:: v2.23     DEPRECATED please use custom model version route instead:     :http:post:`/api/v2/customModels/(customModelId)/versions/(customModelVersionId)/predictionExplanationsInitialization/` 

            Keyword Args:
                custom_model_prediction_explanations (CustomModelPredictionExplanations): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/customModels/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def custom_models_retrieve(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Get custom model.

            Retrieve metadata for a custom model.
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
            Returns:
                CustomModelResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelResponse(**server_data)

        @classmethod
        def custom_models_training_data_patch_many(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Assign training data to custom model.

            Assigns training data from provided dataset to provided Custom Inference Model. For each of custom model's deployments the training data from the specified project is used as baseline, this will enable turning drift tracking on for those deployments.
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
                training_data_assignment (TrainingDataAssignment): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/trainingData/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def custom_models_version_create_from_latest(
            cls,
            custom_model_id,
            is_major_update="true",
            **kwargs
        ):
            """Update custom model version files.

            Create a new custom model version with files added, replaced or deleted. Files from the previous version of a custom models will be used as a basis.
            Args:
                custom_model_id (str): ID of the custom model.
                is_major_update (str): If set to true, new major version will created, otherwise minor version will be created.. defaults to "true", must be one of ["true"]

            Keyword Args:
                base_environment_id (str): The base environment to use with this model version.. [optional]
                desired_memory (int, none_type): The amount of memory that is expected to be allocated by the custom model.. [optional]
                file (file_type): A file with code for a custom task or a custom model. For each file supplied as form data, you must have a corresponding `filePath` supplied that shows the relative location of the file. For example, you have two files: `/home/username/custom-task/main.py` and `/home/username/custom-task/helpers/helper.py`. When uploading these files, you would _also_ need to include two `filePath` fields of, `\\\"main.py\\\"` and `\\\"helpers/helper.py\\\"`. If the supplied `file` already exists at the supplied `filePath`, the old file is replaced by the new file.. [optional]
                file_path (bool, date, datetime, dict, float, int, list, str, none_type): The local path of the file being uploaded. See the `file` field explanation for more details.. [optional]
                files_to_delete (bool, date, datetime, dict, float, int, list, str, none_type): The IDs of the files to be deleted.. [optional]
                maximum_memory (int, none_type): The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. [optional]
                network_egress_policy (str, none_type): Network egress policy.. [optional]
                replicas (int, none_type): A fixed number of replicas that will be set for the given custom-model.. [optional]
                required_metadata (str): Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys. Once set, they cannot be changed. If you to change them, make a new version.. [optional]
                required_metadata_values (str): Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. [optional]
                requires_ha (bool, none_type): Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. [optional]
            Returns:
                CustomModelVersionResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['is_major_update'] = is_major_update
            path_args['isMajorUpdate'] = is_major_update
            path = '/api/v2/customModels/{customModelId}/versions/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelVersionResponse(**server_data)

        @classmethod
        def custom_models_versions_create(
            cls,
            custom_model_id,
            is_major_update="true",
            **kwargs
        ):
            """Create custom model version.

            Create a new custom model version with attached files if supplied.
            Args:
                custom_model_id (str): ID of the custom model.
                is_major_update (str): If set to true, new major version will created, otherwise minor version will be created.. defaults to "true", must be one of ["true"]

            Keyword Args:
                base_environment_id (str): The base environment to use with this model version.. [optional]
                desired_memory (int, none_type): The amount of memory that is expected to be allocated by the custom model.. [optional]
                file (file_type): A file with code for a custom task or a custom model. For each file supplied as form data, you must have a corresponding `filePath` supplied that shows the relative location of the file. For example, you have two files: `/home/username/custom-task/main.py` and `/home/username/custom-task/helpers/helper.py`. When uploading these files, you would _also_ need to include two `filePath` fields of, `\\\"main.py\\\"` and `\\\"helpers/helper.py\\\"`. If the supplied `file` already exists at the supplied `filePath`, the old file is replaced by the new file.. [optional]
                file_path (bool, date, datetime, dict, float, int, list, str, none_type): The local path of the file being uploaded. See the `file` field explanation for more details.. [optional]
                maximum_memory (int, none_type): The maximum memory that might be allocated by the custom-model. If exceeded, the custom-model will be killed. [optional]
                network_egress_policy (str, none_type): Network egress policy.. [optional]
                replicas (int, none_type): A fixed number of replicas that will be set for the given custom-model.. [optional]
                required_metadata (str): Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys. Once set, they cannot be changed. If you to change them, make a new version.. [optional]
                required_metadata_values (str): Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. [optional]
                requires_ha (bool, none_type): Require all custom model replicas to be deployed on different Kubernetes nodes for predictions fault tolerance.. [optional]
            Returns:
                CustomModelVersionResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['is_major_update'] = is_major_update
            path_args['isMajorUpdate'] = is_major_update
            path = '/api/v2/customModels/{customModelId}/versions/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelVersionResponse(**server_data)

        @classmethod
        def custom_models_versions_dependency_build_create(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Start a custom model version's dependency build.

            Start a custom model version's dependency build. This is required to test, deploy, or train custom models.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
            Returns:
                BaseDependencyBuildMetadataResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuild/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BaseDependencyBuildMetadataResponse(**server_data)

        @classmethod
        def custom_models_versions_dependency_build_delete_many(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Cancel dependency build.

            Cancel the custom model version's dependency build.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuild/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def custom_models_versions_dependency_build_list(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Retrieve the custom model version's dependency build status.

            Retrieve the custom model version's dependency build status.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
            Returns:
                BaseDependencyBuildMetadataResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuild/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BaseDependencyBuildMetadataResponse(**server_data)

        @classmethod
        def custom_models_versions_dependency_build_log_list(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Retrieve the custom model version's dependency build log.

            Retrieve the custom model version's dependency build log.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
            Returns:
                DependencyBuildLogResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/dependencyBuildLog/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DependencyBuildLogResponse(**server_data)

        @classmethod
        def custom_models_versions_download_list(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Download custom model version content.

            Download a specific item bundle from a custom model as a zip compressed archive.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
                pps (str): Download model version from PPS tab.If \"true\" specified, model archive includes dependencies install script. If \"false\" specified, dependencies script is not included. If not specified -> \"false\" behavior.. [optional] if omitted the server will use the default value of "False"
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/download/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def custom_models_versions_feature_impact_create(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Create custom model feature impact.

            Add a request to calculate feature impact for a custom inference model image to             the queue.  This route is a counterpart of a corresponding endpoint for native models: :http:post:`/api/v2/projects/(projectId)/models/(modelId)/featureImpact/` 
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
                feature_impact_create_payload (FeatureImpactCreatePayload): [optional]
            Returns:
                FeatureImpactCreateResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/featureImpact/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureImpactCreateResponse(**server_data)

        @classmethod
        def custom_models_versions_feature_impact_list(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Get custom model feature impact.

            Retrieve feature impact scores for features in a custom inference model image.   This route is a counterpart of a corresponding endpoint for native models: :http:get:`/api/v2/projects/(projectId)/models/(modelId)/featureImpact/` 
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
            Returns:
                FeatureImpactResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/featureImpact/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureImpactResponse(**server_data)

        @classmethod
        def custom_models_versions_from_repository_create(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Create custom model version from remote repository.

            Create a new custom model version with only files added from the specified remote repository.
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
                custom_model_version_create_from_repository (CustomModelVersionCreateFromRepository): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/versions/fromRepository/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def custom_models_versions_from_repository_patch_many(
            cls,
            custom_model_id,
            **kwargs
        ):
            """Create custom model version from remote repository with files from previous version.

            Create a new custom model version with files added from a remote repository. Files from the previous version of a custom models will be used as a basis.
            Args:
                custom_model_id (str): ID of the custom model.

            Keyword Args:
                custom_model_version_create_from_repository (CustomModelVersionCreateFromRepository): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/versions/fromRepository/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def custom_models_versions_list(
            cls,
            custom_model_id,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """List custom model versions.

            List custom model versions.
            Args:
                custom_model_id (str): ID of the custom model.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 1000, must be one of [1000]

            Keyword Args:
            Returns:
                CustomModelVersionListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            path = '/api/v2/customModels/{customModelId}/versions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelVersionListResponse(**server_data)

        @classmethod
        def custom_models_versions_patch(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Update custom model version.

            Edit metadata of a specific model version.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
                custom_model_version_metadata_update (CustomModelVersionMetadataUpdate): [optional]
            Returns:
                CustomModelVersionResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelVersionResponse(**server_data)

        @classmethod
        def custom_models_versions_prediction_explanations_initialization_create(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Create a new prediction explanations initialization for custom model version.

            Create a new prediction explanations initialization for custom model version. This is a necessary prerequisite for generating prediction explanations.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.post(path)

        @classmethod
        def custom_models_versions_retrieve(
            cls,
            custom_model_id,
            custom_model_version_id,
            **kwargs
        ):
            """Get custom model version.

            Display a requested version of a custom model along with the files attached to it.
            Args:
                custom_model_id (str): ID of the custom model.
                custom_model_version_id (str): ID of the custom model version.

            Keyword Args:
            Returns:
                CustomModelVersionResponse
            """
            path_args = {}
            kwargs['custom_model_id'] = custom_model_id
            path_args['customModelId'] = custom_model_id
            kwargs['custom_model_version_id'] = custom_model_version_id
            path_args['customModelVersionId'] = custom_model_version_id
            path = '/api/v2/customModels/{customModelId}/versions/{customModelVersionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomModelVersionResponse(**server_data)

        @classmethod
        def custom_training_blueprints_create(
            cls,
            **kwargs
        ):
            """Create a blueprint from a single custom training estimator.

            This route creates a blueprint from a custom training estimator with an environment so that it can be trained via blueprint ID. 

            Keyword Args:
                custom_training_blueprint_create (CustomTrainingBlueprintCreate): [optional]
            Returns:
                CustomTrainingBlueprintResponse
            """
            path_args = {}
            path = '/api/v2/customTrainingBlueprints/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTrainingBlueprintResponse(**server_data)

        @classmethod
        def custom_training_blueprints_list(
            cls,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """List training blueprints.

            List custom training blueprints.  This route retrieves the metadata for all custom training blueprints             a user has access to. 
            Args:
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 1000, must be one of [1000]

            Keyword Args:
                custom_model_id (str): List blueprints for a specific model. Default: all.. [optional]
                reverse (str): List blueprints in reverse order.. [optional] if omitted the server will use the default value of "False"
                target_types ([str]): Custom model target types to return.. [optional]
            Returns:
                CustomTrainingBlueprintListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/customTrainingBlueprints/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTrainingBlueprintListResponse(**server_data)

