#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.custom_task_copy import CustomTaskCopy
from datarobot.models.full_api.generated.model.custom_task_create import CustomTaskCreate
from datarobot.models.full_api.generated.model.custom_task_list_response import CustomTaskListResponse
from datarobot.models.full_api.generated.model.custom_task_response import CustomTaskResponse
from datarobot.models.full_api.generated.model.custom_task_update import CustomTaskUpdate
from datarobot.models.full_api.generated.model.custom_task_version_create_from_repository import CustomTaskVersionCreateFromRepository
from datarobot.models.full_api.generated.model.custom_task_version_list_response import CustomTaskVersionListResponse
from datarobot.models.full_api.generated.model.custom_task_version_metadata_update import CustomTaskVersionMetadataUpdate
from datarobot.models.full_api.generated.model.custom_task_version_response import CustomTaskVersionResponse


class CustomTasksApi(APIObject):

        @classmethod
        def custom_task_version_create_from_latest(
            cls,
            custom_task_id,
            is_major_update="true",
            **kwargs
        ):
            """Update custom task version files.

            Create a new custom task version with files added, replaced or deleted. Files from the previous version of a custom task will be used as a basis.
            Args:
                custom_task_id (str): ID of the custom task.
                is_major_update (str): If set to true, new major version will created, otherwise minor version will be created.. defaults to "true", must be one of ["true"]

            Keyword Args:
                base_environment_id (str): The base environment to use with this custom task version.. [optional]
                file (file_type): A file with code for a custom task or a custom model. For each file supplied as form data, you must have a corresponding `filePath` supplied that shows the relative location of the file. For example, you have two files: `/home/username/custom-task/main.py` and `/home/username/custom-task/helpers/helper.py`. When uploading these files, you would _also_ need to include two `filePath` fields of, `\\\"main.py\\\"` and `\\\"helpers/helper.py\\\"`. If the supplied `file` already exists at the supplied `filePath`, the old file is replaced by the new file.. [optional]
                file_path (bool, date, datetime, dict, float, int, list, str, none_type): The local path of the file being uploaded. See the `file` field explanation for more details.. [optional]
                files_to_delete (bool, date, datetime, dict, float, int, list, str, none_type): The IDs of the files to be deleted.. [optional]
                required_metadata (str): Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys. Once set, they cannot be changed. If you to change them, make a new version.. [optional]
                required_metadata_values (str): Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. [optional]
            Returns:
                CustomTaskVersionResponse
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            kwargs['is_major_update'] = is_major_update
            path_args['isMajorUpdate'] = is_major_update
            path = '/api/v2/customTasks/{customTaskId}/versions/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskVersionResponse(**server_data)

        @classmethod
        def custom_tasks_create(
            cls,
            **kwargs
        ):
            """Create a custom task

             Creates a new custom task and returns the newly created metadata record for it.  A custom task may either be an estimator or a transform. Estimators must support a single target type (e.g. binaryClassification, regression). Regression and anomaly detection models are expected to produce predictions that are arbitrary floating-point or integer numbers. A classification model is expected to return predictions with probability scores for each class.  For example, a binary classification model might return:  .. code:: Python      {         positiveClassLabel: probability,         negativeClassLabel: 1.0 - probability     }  Transforms are expected to return a dataframe or sparse matrix with the same number of rows as the input feature matrix. At this time, only numeric outputs are supported for custom transforms. 

            Keyword Args:
                custom_task_create (CustomTaskCreate): [optional]
            Returns:
                CustomTaskResponse
            """
            path_args = {}
            path = '/api/v2/customTasks/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskResponse(**server_data)

        @classmethod
        def custom_tasks_delete(
            cls,
            custom_task_id,
            **kwargs
        ):
            """Delete custom task.

            Delete a custom task. Only users who have permission to edit custom task can delete it. Only custom tasks which are not currently deployed  can be deleted. Relevant CustomTaskImage will be deleted also.
            Args:
                custom_task_id (str): ID of the custom task.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            path = '/api/v2/customTasks/{customTaskId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def custom_tasks_download_list(
            cls,
            custom_task_id,
            **kwargs
        ):
            """Download the latest custom task version content.

            Download the latest item bundle from a custom task as a zip compressed archive.
            Args:
                custom_task_id (str): ID of the custom task.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            path = '/api/v2/customTasks/{customTaskId}/download/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def custom_tasks_from_custom_task_create(
            cls,
            **kwargs
        ):
            """Clone custom task.

            Creates a copy of the provided custom task, including metadata, versions of that task, and uploaded files. Associates the new versions with files owned by the custom task.

            Keyword Args:
                custom_task_copy (CustomTaskCopy): [optional]
            Returns:
                CustomTaskResponse
            """
            path_args = {}
            path = '/api/v2/customTasks/fromCustomTask/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskResponse(**server_data)

        @classmethod
        def custom_tasks_list(
            cls,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """List custom tasks.

             Retrieve metadata for all custom tasks the user has access to. Metadata for a single task includes:      * The task Id     * The task's target type     * The latest version     * Creation date     * Last updated date     * Task name     * Task language (i.e. python, java, etc)     * The user that created the task     * Whether predictions are calibrated (for custom anomaly detection tasks only)  
            Args:
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 1000, must be one of [1000]

            Keyword Args:
                order_by (str): Sort order which will be applied to custom task list, valid options are \"created\", \"updated\". Prefix the attribute name with a dash to sort in descending order, e.g. orderBy=\"-created\". By default, the orderBy parameter is None which will result in custom tasks being returned in order of creation time descending.. [optional]
                search_for (str): String to search for occurrence in custom task's description, language and name. Search is case insensitive. If not specified, all custom tasks will be returned.. [optional]
            Returns:
                CustomTaskListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/customTasks/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskListResponse(**server_data)

        @classmethod
        def custom_tasks_patch(
            cls,
            custom_task_id,
            **kwargs
        ):
            """Update custom task.

             Updates metadata for an existing custom task.  All custom tasks must support one target type (e.g. binaryClassification, regression, transform).  Setting `positiveClassLabel` and `negativeClassLabel` to null will set the labels to their default values (1 and 0 for positiveClassLabel and negativeClassLabel, respectively).  Setting `positiveClassLabel`, `negativeClassLabel`, 'targetName` is disabled if task has active deployments. 
            Args:
                custom_task_id (str): ID of the custom task.

            Keyword Args:
                custom_task_update (CustomTaskUpdate): [optional]
            Returns:
                CustomTaskResponse
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            path = '/api/v2/customTasks/{customTaskId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskResponse(**server_data)

        @classmethod
        def custom_tasks_retrieve(
            cls,
            custom_task_id,
            **kwargs
        ):
            """Get custom task.

             Retrieve metadata for a custom task:      * The task Id     * The task's target type     * The latest version     * Creation date     * Last updated date     * Task name     * Task language (i.e. python, java, etc)     * The user that created the task     * Whether predictions are calibrated (for custom anomaly detection tasks only)  
            Args:
                custom_task_id (str): ID of the custom task.

            Keyword Args:
            Returns:
                CustomTaskResponse
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            path = '/api/v2/customTasks/{customTaskId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskResponse(**server_data)

        @classmethod
        def custom_tasks_versions_create(
            cls,
            custom_task_id,
            is_major_update="true",
            **kwargs
        ):
            """Create custom task version.

            Create a new custom task version with attached files if supplied.
            Args:
                custom_task_id (str): ID of the custom task.
                is_major_update (str): If set to true, new major version will created, otherwise minor version will be created.. defaults to "true", must be one of ["true"]

            Keyword Args:
                base_environment_id (str): The base environment to use with this custom task version.. [optional]
                file (file_type): A file with code for a custom task or a custom model. For each file supplied as form data, you must have a corresponding `filePath` supplied that shows the relative location of the file. For example, you have two files: `/home/username/custom-task/main.py` and `/home/username/custom-task/helpers/helper.py`. When uploading these files, you would _also_ need to include two `filePath` fields of, `\\\"main.py\\\"` and `\\\"helpers/helper.py\\\"`. If the supplied `file` already exists at the supplied `filePath`, the old file is replaced by the new file.. [optional]
                file_path (bool, date, datetime, dict, float, int, list, str, none_type): The local path of the file being uploaded. See the `file` field explanation for more details.. [optional]
                required_metadata (str): Additional parameters required by the execution environment. The required keys are defined by the fieldNames in the base envionment's requiredMetadataKeys. Once set, they cannot be changed. If you to change them, make a new version.. [optional]
                required_metadata_values (str): Additional parameters required by the execution environment. The required fieldNames are defined by the fieldNames in the base envionment's requiredMetadataKeys.. [optional]
            Returns:
                CustomTaskVersionResponse
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            kwargs['is_major_update'] = is_major_update
            path_args['isMajorUpdate'] = is_major_update
            path = '/api/v2/customTasks/{customTaskId}/versions/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskVersionResponse(**server_data)

        @classmethod
        def custom_tasks_versions_download_list(
            cls,
            custom_task_id,
            custom_task_version_id,
            **kwargs
        ):
            """Download custom task version content.

            Download a specific item bundle from a custom task as a zip compressed archive.
            Args:
                custom_task_id (str): ID of the custom task.
                custom_task_version_id (str): ID of the custom task version.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            kwargs['custom_task_version_id'] = custom_task_version_id
            path_args['customTaskVersionId'] = custom_task_version_id
            path = '/api/v2/customTasks/{customTaskId}/versions/{customTaskVersionId}/download/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def custom_tasks_versions_from_repository_create(
            cls,
            custom_task_id,
            **kwargs
        ):
            """Create custom task version from remote repository.

            Create a new custom task version with only files added from the specified remote repository.
            Args:
                custom_task_id (str): ID of the custom task.

            Keyword Args:
                custom_task_version_create_from_repository (CustomTaskVersionCreateFromRepository): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            path = '/api/v2/customTasks/{customTaskId}/versions/fromRepository/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def custom_tasks_versions_from_repository_patch_many(
            cls,
            custom_task_id,
            **kwargs
        ):
            """Create custom task version from remote repository with files from previous version.

            Create a new custom task version with files added from a remote repository. Files from the previous version of a custom task will be used as a basis.
            Args:
                custom_task_id (str): ID of the custom task.

            Keyword Args:
                custom_task_version_create_from_repository (CustomTaskVersionCreateFromRepository): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            path = '/api/v2/customTasks/{customTaskId}/versions/fromRepository/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def custom_tasks_versions_list(
            cls,
            custom_task_id,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """List custom task versions.

            List custom task versions.
            Args:
                custom_task_id (str): ID of the custom task.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 1000, must be one of [1000]

            Keyword Args:
            Returns:
                CustomTaskVersionListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            path = '/api/v2/customTasks/{customTaskId}/versions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskVersionListResponse(**server_data)

        @classmethod
        def custom_tasks_versions_patch(
            cls,
            custom_task_id,
            custom_task_version_id,
            **kwargs
        ):
            """Update custom task version.

            Edit metadata of a specific task version.
            Args:
                custom_task_id (str): ID of the custom task.
                custom_task_version_id (str): ID of the custom task version.

            Keyword Args:
                custom_task_version_metadata_update (CustomTaskVersionMetadataUpdate): [optional]
            Returns:
                CustomTaskVersionResponse
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            kwargs['custom_task_version_id'] = custom_task_version_id
            path_args['customTaskVersionId'] = custom_task_version_id
            path = '/api/v2/customTasks/{customTaskId}/versions/{customTaskVersionId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskVersionResponse(**server_data)

        @classmethod
        def custom_tasks_versions_retrieve(
            cls,
            custom_task_id,
            custom_task_version_id,
            **kwargs
        ):
            """Get custom task version.

            Display a requested version of a custom task along with the files attached to it.
            Args:
                custom_task_id (str): ID of the custom task.
                custom_task_version_id (str): ID of the custom task version.

            Keyword Args:
            Returns:
                CustomTaskVersionResponse
            """
            path_args = {}
            kwargs['custom_task_id'] = custom_task_id
            path_args['customTaskId'] = custom_task_id
            kwargs['custom_task_version_id'] = custom_task_version_id
            path_args['customTaskVersionId'] = custom_task_version_id
            path = '/api/v2/customTasks/{customTaskId}/versions/{customTaskVersionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CustomTaskVersionResponse(**server_data)

