#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.data_disparity_create_payload import DataDisparityCreatePayload
from datarobot.models.full_api.generated.model.data_disparity_create_response import DataDisparityCreateResponse
from datarobot.models.full_api.generated.model.data_disparity_retrieve_response import DataDisparityRetrieveResponse


class DataDisparityApi(APIObject):

        @classmethod
        def projects_models_data_disparity_insights_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start insight calculations.

            Submits a job to start Cross Class Data Disparity insight calculations.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                data_disparity_create_payload (DataDisparityCreatePayload): [optional]
            Returns:
                DataDisparityCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataDisparityCreateResponse(**server_data)

        @classmethod
        def projects_models_data_disparity_insights_list(
            cls,
            feature,
            class_name1,
            class_name2,
            project_id,
            model_id,
            **kwargs
        ):
            """Get Cross Class Data Disparity results.

            Retrieve a list of Cross Class Data Disparity insights for the model.
            Args:
                feature (str): Feature for which insight is computed.
                class_name1 (str): One of the compared classes.
                class_name2 (str): Another compared class.
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
            Returns:
                DataDisparityRetrieveResponse
            """
            path_args = {}
            kwargs['feature'] = feature
            path_args['feature'] = feature
            kwargs['class_name1'] = class_name1
            path_args['className1'] = class_name1
            kwargs['class_name2'] = class_name2
            path_args['className2'] = class_name2
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataDisparityRetrieveResponse(**server_data)

