#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.data_source_create import DataSourceCreate
from datarobot.models.full_api.generated.model.data_source_describe_permissions_response import DataSourceDescribePermissionsResponse
from datarobot.models.full_api.generated.model.data_source_list_response import DataSourceListResponse
from datarobot.models.full_api.generated.model.data_source_retrieve_response import DataSourceRetrieveResponse
from datarobot.models.full_api.generated.model.data_source_update import DataSourceUpdate
from datarobot.models.full_api.generated.model.shared_roles_update_with_grant import SharedRolesUpdateWithGrant
from datarobot.models.full_api.generated.model.shared_roles_with_grant_list_response import SharedRolesWithGrantListResponse
from datarobot.models.full_api.generated.model.sharing_list_response import SharingListResponse
from datarobot.models.full_api.generated.model.sharing_update_or_remove_with_grant import SharingUpdateOrRemoveWithGrant


class DataSourcesApi(APIObject):

        @classmethod
        def external_data_sources_access_control_list(
            cls,
            data_source_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """Get data source's access control list

            Get a list of users, groups and organizations who have access to this data source and their roles.
            Args:
                data_source_id (str): The ID of the Data Source.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 0, must be one of [0]

            Keyword Args:
                username (str): Optional, only return the access control information for a user with this username.. [optional]
                user_id (str): Optional, only return the access control information for a user with this user ID.. [optional]
            Returns:
                SharingListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/accessControl/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SharingListResponse(**server_data)

        @classmethod
        def external_data_sources_access_control_patch_many(
            cls,
            data_source_id,
            **kwargs
        ):
            """Update data source's access controls

            Set roles for users on this data source. Note that when granting access to a data source, access to the corresponding data store as a \"CONSUMER\" will also be granted.
            Args:
                data_source_id (str): The ID of the Data Source.

            Keyword Args:
                sharing_update_or_remove_with_grant (SharingUpdateOrRemoveWithGrant): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/accessControl/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def external_data_sources_create(
            cls,
            **kwargs
        ):
            """Create a data source.

            Create a fully configured source of data which could be used for datasets and projects creation.A `data source` specifies, via SQL query or selected table and schema data, which data to extract from the `data connection` (the location of data within a given endpoint) to use for modeling or predictions. A `data source` has one `data connection` and one `connector` but can have many `datasets`. To test the SQL query before creating the data source,use :http:post:`/api/v2/externalDataStores/(dataStoreId)/verifySQL/`.

            Keyword Args:
                data_source_create (DataSourceCreate): [optional]
            Returns:
                DataSourceRetrieveResponse
            """
            path_args = {}
            path = '/api/v2/externalDataSources/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataSourceRetrieveResponse(**server_data)

        @classmethod
        def external_data_sources_delete(
            cls,
            data_source_id,
            **kwargs
        ):
            """Delete the data source.

            Delete the data source with given ID if it is not used by any dataset.
            Args:
                data_source_id (str): The ID of the Data Source.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def external_data_sources_list(
            cls,
            **kwargs
        ):
            """List data sources.

            Return detailed list of available data sources.

            Keyword Args:
                type (str): Data source type to filter by.. [optional] if omitted the server will use the default value of "jdbc"
            Returns:
                DataSourceListResponse
            """
            path_args = {}
            path = '/api/v2/externalDataSources/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataSourceListResponse(**server_data)

        @classmethod
        def external_data_sources_patch(
            cls,
            data_source_id,
            **kwargs
        ):
            """Update the data source.

            Update the data source with given ID. To test the SQL query before updating the data source,use :http:post:`/api/v2/externalDataStores/(dataStoreId)/verifySQL/`.
            Args:
                data_source_id (str): The ID of the Data Source.

            Keyword Args:
                data_source_update (DataSourceUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def external_data_sources_permissions_list(
            cls,
            data_source_id,
            **kwargs
        ):
            """Describe data source permissions.

            Describe what permissions current user has for given data source.
            Args:
                data_source_id (str): The ID of the Data Source.

            Keyword Args:
            Returns:
                DataSourceDescribePermissionsResponse
            """
            path_args = {}
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/permissions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataSourceDescribePermissionsResponse(**server_data)

        @classmethod
        def external_data_sources_retrieve(
            cls,
            data_source_id,
            **kwargs
        ):
            """Data source details.

            Return details of the existing data source with given ID, including SQL query or selected table and schema data, which fully describe which data to extract and from which location.
            Args:
                data_source_id (str): The ID of the Data Source.

            Keyword Args:
            Returns:
                DataSourceRetrieveResponse
            """
            path_args = {}
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataSourceRetrieveResponse(**server_data)

        @classmethod
        def external_data_sources_shared_roles_list(
            cls,
            data_source_id,
            offset=0,
            limit=10,
            **kwargs
        ):
            """Get data source's access control list

            Get a list of users, groups and organizations who have access to this data source and their roles.
            Args:
                data_source_id (str): The ID of the Data Source.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 10, must be one of [10]

            Keyword Args:
                id (str): Only return roles for a user, group or organization with this identifier.. [optional]
                name (str): Only return roles for a user, group or organization with this name.. [optional]
                share_recipient_type (str): List access controls for recipients with this type.. [optional]
            Returns:
                SharedRolesWithGrantListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/sharedRoles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SharedRolesWithGrantListResponse(**server_data)

        @classmethod
        def external_data_sources_shared_roles_patch_many(
            cls,
            data_source_id,
            **kwargs
        ):
            """Modify data source shared roles.

            Grant access, remove access or update roles for organizations, groups or users on this data source. Up to 100 roles may be set per array in a single request.
            Args:
                data_source_id (str): The ID of the Data Source.

            Keyword Args:
                shared_roles_update_with_grant (SharedRolesUpdateWithGrant): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['data_source_id'] = data_source_id
            path_args['dataSourceId'] = data_source_id
            path = '/api/v2/externalDataSources/{dataSourceId}/sharedRoles/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

