#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.credentials_list_response import CredentialsListResponse
from datarobot.models.full_api.generated.model.data_store_create import DataStoreCreate
from datarobot.models.full_api.generated.model.data_store_credentials import DataStoreCredentials
from datarobot.models.full_api.generated.model.data_store_credentials_with_credentials_type_support import DataStoreCredentialsWithCredentialsTypeSupport
from datarobot.models.full_api.generated.model.data_store_describe_permissions_response import DataStoreDescribePermissionsResponse
from datarobot.models.full_api.generated.model.data_store_list_response import DataStoreListResponse
from datarobot.models.full_api.generated.model.data_store_retrieve_response import DataStoreRetrieveResponse
from datarobot.models.full_api.generated.model.data_store_sql_verify import DataStoreSQLVerify
from datarobot.models.full_api.generated.model.data_store_sql_verify_response import DataStoreSQLVerifyResponse
from datarobot.models.full_api.generated.model.data_store_schemas_list import DataStoreSchemasList
from datarobot.models.full_api.generated.model.data_store_tables import DataStoreTables
from datarobot.models.full_api.generated.model.data_store_tables_list import DataStoreTablesList
from datarobot.models.full_api.generated.model.data_store_test_response import DataStoreTestResponse
from datarobot.models.full_api.generated.model.data_store_update import DataStoreUpdate
from datarobot.models.full_api.generated.model.shared_roles_update_with_grant import SharedRolesUpdateWithGrant
from datarobot.models.full_api.generated.model.shared_roles_with_grant_list_response import SharedRolesWithGrantListResponse
from datarobot.models.full_api.generated.model.sharing_update_or_remove_with_grant import SharingUpdateOrRemoveWithGrant


class DataStoresApi(APIObject):

        @classmethod
        def external_data_stores_access_control_patch_many(
            cls,
            data_store_id,
            **kwargs
        ):
            """Update data store's controls

            Set roles for users on this data store.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                sharing_update_or_remove_with_grant (SharingUpdateOrRemoveWithGrant): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/accessControl/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def external_data_stores_create(
            cls,
            **kwargs
        ):
            """Create a data store.

            Create a data store which includes a name and a driver ID or a connector ID. The driver would be configured by a JDBC URL or by jdbc fields; The connector would be configured by connection fields.

            Keyword Args:
                data_store_create (DataStoreCreate): [optional]
            Returns:
                DataStoreRetrieveResponse
            """
            path_args = {}
            path = '/api/v2/externalDataStores/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreRetrieveResponse(**server_data)

        @classmethod
        def external_data_stores_credentials_list(
            cls,
            data_store_id,
            **kwargs
        ):
            """List credentials associated with the specified data store.

            Returns a list of credentials associated with the specified data store.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                types (bool, date, datetime, dict, float, int, list, str, none_type): Includes only credentials of the specified type. Repeat the parameter for filtering on multiple statuses.. [optional]
            Returns:
                CredentialsListResponse
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/credentials/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CredentialsListResponse(**server_data)

        @classmethod
        def external_data_stores_delete(
            cls,
            data_store_id,
            **kwargs
        ):
            """Delete the data store.

            Delete the data store with given ID if it is not used by any data source.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def external_data_stores_list(
            cls,
            **kwargs
        ):
            """List data stores.

            Return list with details of the existing data stores available for the user.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                type (str): Includes only data stores of the specified type or any if set to `all`.. [optional] if omitted the server will use the default value of "jdbc"
                show_hidden (str): Specifies whether non-visible OAuth fields are shown.. [optional] if omitted the server will use the default value of "False"
            Returns:
                DataStoreListResponse
            """
            path_args = {}
            path = '/api/v2/externalDataStores/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreListResponse(**server_data)

        @classmethod
        def external_data_stores_patch(
            cls,
            data_store_id,
            **kwargs
        ):
            """Updates a data store configuration.

            Updates a data store configuration.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                data_store_update (DataStoreUpdate): [optional]
            Returns:
                DataStoreRetrieveResponse
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreRetrieveResponse(**server_data)

        @classmethod
        def external_data_stores_permissions_list(
            cls,
            data_store_id,
            **kwargs
        ):
            """Describe data store permissions.

            Describe what permissions current user has for given data store.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
            Returns:
                DataStoreDescribePermissionsResponse
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/permissions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreDescribePermissionsResponse(**server_data)

        @classmethod
        def external_data_stores_retrieve(
            cls,
            data_store_id,
            **kwargs
        ):
            """Data store details.

            A configured connection to a database - it has a name and a specified driver. The driver may be specified by a JDBC URL or connection parameters if the driver was created with the parameter configuration. 
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
            Returns:
                DataStoreRetrieveResponse
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreRetrieveResponse(**server_data)

        @classmethod
        def external_data_stores_schemas_create(
            cls,
            data_store_id,
            **kwargs
        ):
            """Retrieves a data store's data schemas.

            Retrieves a data store's data schemas.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                data_store_credentials (DataStoreCredentials): [optional]
            Returns:
                DataStoreSchemasList
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/schemas/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreSchemasList(**server_data)

        @classmethod
        def external_data_stores_shared_roles_list(
            cls,
            data_store_id,
            offset=0,
            limit=10,
            **kwargs
        ):
            """Get data store's access control list

            Get a list of users who have access to this data store and their roles on the data store.
            Args:
                data_store_id (str): ID of the data store.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 10, must be one of [10]

            Keyword Args:
                id (str): Only return roles for a user, group or organization with this identifier.. [optional]
                name (str): Only return roles for a user, group or organization with this name.. [optional]
                share_recipient_type (str): List access controls for recipients with this type.. [optional]
            Returns:
                SharedRolesWithGrantListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/sharedRoles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SharedRolesWithGrantListResponse(**server_data)

        @classmethod
        def external_data_stores_shared_roles_patch_many(
            cls,
            data_store_id,
            **kwargs
        ):
            """Modify data store shared roles.

            Grant access, remove access or update roles for organizations, groups or users on this data store. Up to 100 roles may be set per array in a single request.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                shared_roles_update_with_grant (SharedRolesUpdateWithGrant): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/sharedRoles/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def external_data_stores_tables_create(
            cls,
            data_store_id,
            **kwargs
        ):
            """Retrieves a data store's database tables (including views).

            Retrieves a data store's database tables (including views).
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                data_store_tables (DataStoreTables): [optional]
            Returns:
                DataStoreTablesList
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/tables/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreTablesList(**server_data)

        @classmethod
        def external_data_stores_test_create(
            cls,
            data_store_id,
            **kwargs
        ):
            """Tests data store connection.

            Tests the ability to connect to a data store with specified authentication.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                data_store_credentials_with_credentials_type_support (DataStoreCredentialsWithCredentialsTypeSupport): [optional]
            Returns:
                DataStoreTestResponse
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/test/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreTestResponse(**server_data)

        @classmethod
        def external_data_stores_verify_sql_create(
            cls,
            data_store_id,
            **kwargs
        ):
            """Verifies a SQL query for a data store.

            Executes the SQL query on the data store, returning a small number of rows (max 999). Use this for quick query execution validation and exploring results, not for capturing an entire result set.
            Args:
                data_store_id (str): ID of the data store.

            Keyword Args:
                data_store_sql_verify (DataStoreSQLVerify): [optional]
            Returns:
                DataStoreSQLVerifyResponse
            """
            path_args = {}
            kwargs['data_store_id'] = data_store_id
            path_args['dataStoreId'] = data_store_id
            path = '/api/v2/externalDataStores/{dataStoreId}/verifySQL/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataStoreSQLVerifyResponse(**server_data)

