#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.prime_file_create import PrimeFileCreate
from datarobot.models.full_api.generated.model.prime_file_list_response import PrimeFileListResponse
from datarobot.models.full_api.generated.model.prime_file_response import PrimeFileResponse
from datarobot.models.full_api.generated.model.prime_info_retrieve_response import PrimeInfoRetrieveResponse
from datarobot.models.full_api.generated.model.prime_model_create_payload import PrimeModelCreatePayload
from datarobot.models.full_api.generated.model.prime_model_details_retrieve_response import PrimeModelDetailsRetrieveResponse
from datarobot.models.full_api.generated.model.prime_model_list_response import PrimeModelListResponse
from datarobot.models.full_api.generated.model.prime_rulesets_list_response import PrimeRulesetsListResponse


class DatarobotPrimeApi(APIObject):

        @classmethod
        def projects_models_prime_info_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Check a Model for Prime Eligibility

            Check if a model can be approximated by DataRobot Prime
            Args:
                project_id (str): the project the model belongs to
                model_id (str): the model to check

            Keyword Args:
            Returns:
                PrimeInfoRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/primeInfo/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PrimeInfoRetrieveResponse(**server_data)

        @classmethod
        def projects_models_prime_rulesets_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Create Rulesets

            Approximate an existing model on the leaderboard with DataRobot Prime. A request body should be an empty JSON {}
            Args:
                project_id (str): the project the model to approximate belongs to
                model_id (str): the model to approximate

            Keyword Args:
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/primeRulesets/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_prime_rulesets_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List Rulesets

            List all the rulesets approximating a model  When rulesets are created for the parent model, all of the rulesets are created at once, but not all rulesets have corresponding Prime models (until they are directly requested).
            Args:
                project_id (str): the project the model belongs to
                model_id (str): the model to find approximating rulesets for

            Keyword Args:
            Returns:
                PrimeRulesetsListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/primeRulesets/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PrimeRulesetsListResponse(**server_data)

        @classmethod
        def projects_prime_files_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a Prime File

            Request creation and validation of source code from a Prime model
            Args:
                project_id (str): the project the Prime model belongs to

            Keyword Args:
                prime_file_create (PrimeFileCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/primeFiles/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_prime_files_download_list(
            cls,
            project_id,
            prime_file_id,
            **kwargs
        ):
            """Download Code

            Download code from an existing Prime file
            Args:
                project_id (str): the project the file belongs to
                prime_file_id (str): the Prime file to download code from

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prime_file_id'] = prime_file_id
            path_args['primeFileId'] = prime_file_id
            path = '/api/v2/projects/{projectId}/primeFiles/{primeFileId}/download/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_prime_files_list(
            cls,
            project_id,
            **kwargs
        ):
            """Get Prime Files

            List all DataRobot Prime files available for download
            Args:
                project_id (str): the project to list available files for

            Keyword Args:
                offset (int): this many results will be skipped. [optional] if omitted the server will use the default value of 0
                limit (int): at most this many results are returned. To specify no limit, use 0. The default may change and a maximum limit may be imposed without notice.. [optional] if omitted the server will use the default value of 0
                parent_model_id (str): if specified only Prime files approximating the specified parent model will be returned; otherwise all applicable Prime files will be returned.. [optional]
                model_id (str): if specified only Prime files with code used in the specified prime model will be returned; otherwise all applicable Prime files will be returned. [optional]
            Returns:
                PrimeFileListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/primeFiles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PrimeFileListResponse(**server_data)

        @classmethod
        def projects_prime_files_retrieve(
            cls,
            project_id,
            prime_file_id,
            **kwargs
        ):
            """Retrieve metadata about a DataRobot Prime file

            Retrieve metadata about a DataRobot Prime file available for download
            Args:
                project_id (str): the project the file belongs to
                prime_file_id (str): the file to retrieve

            Keyword Args:
            Returns:
                PrimeFileResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prime_file_id'] = prime_file_id
            path_args['primeFileId'] = prime_file_id
            path = '/api/v2/projects/{projectId}/primeFiles/{primeFileId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PrimeFileResponse(**server_data)

        @classmethod
        def projects_prime_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a Prime Model from a Ruleset

            Create a Prime model using a particular ruleset.  DataRobot Prime is not available for multiclass projects.  Once rulesets approximating a parent model have been created, using POST /api/v2/projects/(projectId)/models/(modelId)/primeRulesets/, this route will allow creation of a Prime model using one of those rulesets.  Available rulesets can be retrieved via GET /api/v2/projects/(projectId)/models/(modelId)/primeRulesets/.
            Args:
                project_id (str): the project in which to create the model

            Keyword Args:
                prime_model_create_payload (PrimeModelCreatePayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/primeModels/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_prime_models_list(
            cls,
            project_id,
            **kwargs
        ):
            """List all Prime models in a project

            List all Prime models in a project
            Args:
                project_id (str): the project to list models from

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
            Returns:
                PrimeModelListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/primeModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PrimeModelListResponse(**server_data)

        @classmethod
        def projects_prime_models_retrieve(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a Prime model details

            Retrieve a Prime model details
            Args:
                project_id (str): the project to retrieve the model from
                model_id (str): the model to retrieve

            Keyword Args:
            Returns:
                PrimeModelDetailsRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/primeModels/{modelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PrimeModelDetailsRetrieveResponse(**server_data)

