#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.basic_dataset_details_response import BasicDatasetDetailsResponse
from datarobot.models.full_api.generated.model.bulk_dataset_action import BulkDatasetAction
from datarobot.models.full_api.generated.model.create_workspace_state import CreateWorkspaceState
from datarobot.models.full_api.generated.model.created_dataset_data_engine_response import CreatedDatasetDataEngineResponse
from datarobot.models.full_api.generated.model.created_dataset_response import CreatedDatasetResponse
from datarobot.models.full_api.generated.model.dataset_access_control_list_response import DatasetAccessControlListResponse
from datarobot.models.full_api.generated.model.dataset_access_set import DatasetAccessSet
from datarobot.models.full_api.generated.model.dataset_create_from_workspace_state import DatasetCreateFromWorkspaceState
from datarobot.models.full_api.generated.model.dataset_describe_permissions_response import DatasetDescribePermissionsResponse
from datarobot.models.full_api.generated.model.dataset_feature_histogram_response import DatasetFeatureHistogramResponse
from datarobot.models.full_api.generated.model.dataset_featurelist_list_response import DatasetFeaturelistListResponse
from datarobot.models.full_api.generated.model.dataset_featurelist_response import DatasetFeaturelistResponse
from datarobot.models.full_api.generated.model.dataset_features_list_response import DatasetFeaturesListResponse
from datarobot.models.full_api.generated.model.dataset_from_file import DatasetFromFile
from datarobot.models.full_api.generated.model.dataset_list_response import DatasetListResponse
from datarobot.models.full_api.generated.model.dataset_project_list_response import DatasetProjectListResponse
from datarobot.models.full_api.generated.model.dataset_refresh_job_create import DatasetRefreshJobCreate
from datarobot.models.full_api.generated.model.dataset_refresh_job_response import DatasetRefreshJobResponse
from datarobot.models.full_api.generated.model.dataset_refresh_job_retrieve_execution_results_response import DatasetRefreshJobRetrieveExecutionResultsResponse
from datarobot.models.full_api.generated.model.dataset_refresh_job_update import DatasetRefreshJobUpdate
from datarobot.models.full_api.generated.model.dataset_refresh_jobs_list_response import DatasetRefreshJobsListResponse
from datarobot.models.full_api.generated.model.dataset_relationship_create import DatasetRelationshipCreate
from datarobot.models.full_api.generated.model.dataset_relationship_list_response import DatasetRelationshipListResponse
from datarobot.models.full_api.generated.model.dataset_relationship_response import DatasetRelationshipResponse
from datarobot.models.full_api.generated.model.dataset_relationship_update import DatasetRelationshipUpdate
from datarobot.models.full_api.generated.model.dataset_shared_roles import DatasetSharedRoles
from datarobot.models.full_api.generated.model.dataset_transform_list_response import DatasetTransformListResponse
from datarobot.models.full_api.generated.model.dataset_transform_response import DatasetTransformResponse
from datarobot.models.full_api.generated.model.datasource import Datasource
from datarobot.models.full_api.generated.model.feature_list_create import FeatureListCreate
from datarobot.models.full_api.generated.model.feature_list_modify import FeatureListModify
from datarobot.models.full_api.generated.model.feature_transform import FeatureTransform
from datarobot.models.full_api.generated.model.from_latest import FromLatest
from datarobot.models.full_api.generated.model.from_specific import FromSpecific
from datarobot.models.full_api.generated.model.full_dataset_details_response import FullDatasetDetailsResponse
from datarobot.models.full_api.generated.model.get_dataset_version_projects_response import GetDatasetVersionProjectsResponse
from datarobot.models.full_api.generated.model.hdfs import Hdfs
from datarobot.models.full_api.generated.model.patch_dataset import PatchDataset
from datarobot.models.full_api.generated.model.shared_roles_list_response import SharedRolesListResponse
from datarobot.models.full_api.generated.model.url import Url
from datarobot.models.full_api.generated.model.workspace_source_created_response import WorkspaceSourceCreatedResponse
from datarobot.models.full_api.generated.model.workspace_state_response import WorkspaceStateResponse


class DatasetsApi(APIObject):

        @classmethod
        def data_engine_workspace_states_create(
            cls,
            **kwargs
        ):
            """Create Data Engine workspace state

            Create Data Engine workspace state in database.

            Keyword Args:
                create_workspace_state (CreateWorkspaceState): [optional]
            Returns:
                WorkspaceSourceCreatedResponse
            """
            path_args = {}
            path = '/api/v2/dataEngineWorkspaceStates/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return WorkspaceSourceCreatedResponse(**server_data)

        @classmethod
        def data_engine_workspace_states_retrieve(
            cls,
            workspace_state_id,
            **kwargs
        ):
            """Read Data Engine workspace state

            Read and return previously stored Data Engine workspace state.
            Args:
                workspace_state_id (str): The ID of the Data Engine workspace state.

            Keyword Args:
            Returns:
                WorkspaceStateResponse
            """
            path_args = {}
            kwargs['workspace_state_id'] = workspace_state_id
            path_args['workspaceStateId'] = workspace_state_id
            path = '/api/v2/dataEngineWorkspaceStates/{workspaceStateId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return WorkspaceStateResponse(**server_data)

        @classmethod
        def datasets_access_control_list(
            cls,
            dataset_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List dataset access

            List the users and their associated roles for the specified dataset.
            Args:
                dataset_id (str): The ID of the dataset.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 100, must be one of [100]

            Keyword Args:
                user_id (str): Only return the access control information for a user with this user ID.. [optional]
                username (str): Only return the access control information for a user with this username.. [optional]
            Returns:
                DatasetAccessControlListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/accessControl/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetAccessControlListResponse(**server_data)

        @classmethod
        def datasets_access_control_patch_many(
            cls,
            dataset_id,
            **kwargs
        ):
            """Modify dataset access

            Grant access to the dataset at the specified role level, or remove access to the dataset.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                dataset_access_set (DatasetAccessSet): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/accessControl/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def datasets_all_features_details_list(
            cls,
            dataset_id,
            limit=100,
            offset=0,
            order_by="name",
            **kwargs
        ):
            """Get dataset features

            Return detailed information on all the features and transforms for this dataset.If the Dataset Item has attribute snapshot = True, all optional fields also appear
            Args:
                dataset_id (str): The ID of the dataset.
                limit (int): At most this many results are returned. The default may change and a maximum limit may be imposed without notice.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                order_by (str): How the features should be ordered.. defaults to "name", must be one of ["name"]

            Keyword Args:
            Returns:
                DatasetFeaturesListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['order_by'] = order_by
            path_args['orderBy'] = order_by
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/allFeaturesDetails/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeaturesListResponse(**server_data)

        @classmethod
        def datasets_delete(
            cls,
            dataset_id,
            **kwargs
        ):
            """Delete dataset

            Marks the dataset with the given ID as deleted.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def datasets_deleted_patch_many(
            cls,
            dataset_id,
            **kwargs
        ):
            """Recover deleted dataset

            Recover the dataset item with given datasetId from `deleted`.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/deleted/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def datasets_feature_histograms_retrieve(
            cls,
            dataset_id,
            feature_name,
            bin_limit=60,
            **kwargs
        ):
            """Get dataset feature histogram

            Get histogram chart data for a specific feature in the specified dataset.
            Args:
                dataset_id (str): The ID of the dataset entry to retrieve.
                feature_name (str): The name of the feature.
                bin_limit (int): Maximum number of bins in the returned plot.. defaults to 60, must be one of [60]

            Keyword Args:
                key (str): Only required for the Summarized categorical feature. Name of the top 50 key for which plot to be retrieved.. [optional]
            Returns:
                DatasetFeatureHistogramResponse
            """
            path_args = {}
            kwargs['bin_limit'] = bin_limit
            path_args['binLimit'] = bin_limit
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/datasets/{datasetId}/featureHistograms/{featureName}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeatureHistogramResponse(**server_data)

        @classmethod
        def datasets_feature_transforms_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset feature transform

            Create a new feature by changing the type of an existing one.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                feature_transform (FeatureTransform): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/featureTransforms/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def datasets_feature_transforms_list(
            cls,
            dataset_id,
            limit=100,
            offset=0,
            **kwargs
        ):
            """List dataset feature transforms

            Retrieves the transforms of the dataset with given ID.
            Args:
                dataset_id (str): The ID of the dataset.
                limit (int): At most this many results are returned. The default may change and a maximum limit may be imposed without notice.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                DatasetTransformListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/featureTransforms/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetTransformListResponse(**server_data)

        @classmethod
        def datasets_feature_transforms_retrieve(
            cls,
            dataset_id,
            feature_name,
            **kwargs
        ):
            """Get dataset feature transform

            Retrieve the specified feature with descriptive information.
            Args:
                dataset_id (str): The dataset to select feature from.
                feature_name (str): The name of the feature. Note that DataRobot renames some features, so the feature name may not be the one from your original data. Non-ascii features names should be utf-8-encoded (before URL-quoting).

            Keyword Args:
            Returns:
                DatasetTransformResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/datasets/{datasetId}/featureTransforms/{featureName}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetTransformResponse(**server_data)

        @classmethod
        def datasets_featurelists_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset featurelist

            Create featurelist for specified dataset.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                feature_list_create (FeatureListCreate): [optional]
            Returns:
                DatasetFeaturelistResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/featurelists/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeaturelistResponse(**server_data)

        @classmethod
        def datasets_featurelists_delete(
            cls,
            dataset_id,
            featurelist_id,
            **kwargs
        ):
            """Delete dataset featurelist

            Deletes the indicated featurelist of the dataset with given ID.
            Args:
                dataset_id (str): The ID of the dataset.
                featurelist_id (str): The ID of the featurelist.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/datasets/{datasetId}/featurelists/{featurelistId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def datasets_featurelists_list(
            cls,
            dataset_id,
            limit=100,
            offset=0,
            order_by="name",
            **kwargs
        ):
            """Retrieve dataset featurelists

            Retrieves the featurelists of the dataset with given ID and the latest dataset version.
            Args:
                dataset_id (str): The ID of the dataset.
                limit (int): At most this many results are returned. The default may change and a maximum limit may be imposed without notice.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                order_by (str): How the features should be ordered.. defaults to "name", must be one of ["name"]

            Keyword Args:
            Returns:
                DatasetFeaturelistListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['order_by'] = order_by
            path_args['orderBy'] = order_by
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/featurelists/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeaturelistListResponse(**server_data)

        @classmethod
        def datasets_featurelists_patch(
            cls,
            dataset_id,
            featurelist_id,
            **kwargs
        ):
            """Update dataset featurelist

            Modifies the indicated featurelist of the dataset with given ID.
            Args:
                dataset_id (str): The ID of the dataset.
                featurelist_id (str): The ID of the featurelist.

            Keyword Args:
                feature_list_modify (FeatureListModify): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/datasets/{datasetId}/featurelists/{featurelistId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def datasets_featurelists_retrieve(
            cls,
            dataset_id,
            featurelist_id,
            **kwargs
        ):
            """Get dataset featurelist

            Retrieves the specified featurelist of the dataset with given ID and the latest dataset version.
            Args:
                dataset_id (str): The ID of the dataset.
                featurelist_id (str): The ID of the featurelist.

            Keyword Args:
            Returns:
                DatasetFeaturelistResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/datasets/{datasetId}/featurelists/{featurelistId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeaturelistResponse(**server_data)

        @classmethod
        def datasets_file_list(
            cls,
            dataset_id,
            **kwargs
        ):
            """Retrieve original dataset data

            Retrieve all the originally uploaded data, in CSV form.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
            Returns:
                str
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/file/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            return server_data

        @classmethod
        def datasets_from_data_engine_workspace_state_create(
            cls,
            **kwargs
        ):
            """Create dataset from Data Engine workspace

            Create a dataset from a Data Engine workspace state.

            Keyword Args:
                dataset_create_from_workspace_state (DatasetCreateFromWorkspaceState): [optional]
            Returns:
                CreatedDatasetDataEngineResponse
            """
            path_args = {}
            path = '/api/v2/datasets/fromDataEngineWorkspaceState/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetDataEngineResponse(**server_data)

        @classmethod
        def datasets_from_data_source_create(
            cls,
            **kwargs
        ):
            """Create dataset from data source

            Create a Dataset Item from a data source.

            Keyword Args:
                datasource (Datasource): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            path = '/api/v2/datasets/fromDataSource/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_from_file_create(
            cls,
            file,
            **kwargs
        ):
            """Create dataset from file

            Create a dataset from a file.
            Args:
                file (file_type): The data to be used for the creation.

            Keyword Args:
                categories (bool, date, datetime, dict, float, int, list, str, none_type): An array of strings describing the intended use of the dataset.. [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            kwargs['file'] = file
            path_args['file'] = file
            path = '/api/v2/datasets/fromFile/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_from_hdfs_create(
            cls,
            **kwargs
        ):
            """Create dataset from HDFS URL

            Create a Dataset Item from an HDFS URL.

            Keyword Args:
                hdfs (Hdfs): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            path = '/api/v2/datasets/fromHDFS/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_from_url_create(
            cls,
            **kwargs
        ):
            """Create dataset from URL

            Create a Dataset Item from a URL.

            Keyword Args:
                url (Url): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            path = '/api/v2/datasets/fromURL/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_list(
            cls,
            limit=100,
            offset=0,
            **kwargs
        ):
            """List datasets

            List all datasets accessible by the user.
            Args:
                limit (int): At most this many results are returned.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]

            Keyword Args:
                category (str): If specified, only dataset versions that have the specified category will be included in the results. Categories identify the intended use of the dataset.. [optional]
                order_by (str): Sorting order which will be applied to catalog list.. [optional]
                filter_failed (str): Whether datasets that failed during import should be excluded from the results. If True invalid datasets will be excluded.. [optional] if omitted the server will use the default value of "false"
                dataset_version_ids (bool, date, datetime, dict, float, int, list, str, none_type): If specified will only return datasets that are associated with specified dataset versions.. [optional]
            Returns:
                DatasetListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            path = '/api/v2/datasets/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetListResponse(**server_data)

        @classmethod
        def datasets_patch(
            cls,
            dataset_id,
            **kwargs
        ):
            """Modify dataset

            Modifies the specified dataset.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                patch_dataset (PatchDataset): [optional]
            Returns:
                BasicDatasetDetailsResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BasicDatasetDetailsResponse(**server_data)

        @classmethod
        def datasets_patch_many(
            cls,
            **kwargs
        ):
            """Execute bulk dataset action

            Execute the specified bulk action on multiple datasets.

            Keyword Args:
                bulk_dataset_action (BulkDatasetAction): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/datasets/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def datasets_permissions_list(
            cls,
            dataset_id,
            **kwargs
        ):
            """Describe dataset permissions

            Describe what permissions current user has for given dataset.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
            Returns:
                DatasetDescribePermissionsResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/permissions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetDescribePermissionsResponse(**server_data)

        @classmethod
        def datasets_projects_list(
            cls,
            dataset_id,
            limit=100,
            offset=0,
            **kwargs
        ):
            """Get dataset projects

            Retrieves a dataset's projects by dataset ID.
            Args:
                dataset_id (str): The ID of the dataset.
                limit (int): Only this many items are returned.. defaults to 100, must be one of [100]
                offset (int): Skip this many items.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                DatasetProjectListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/projects/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetProjectListResponse(**server_data)

        @classmethod
        def datasets_refresh_jobs_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Schedule dataset refresh

             Create a dataset refresh job that will automatically create dataset snapshots on a schedule.  Optionally if the limit of enabled jobs per user is reached the following metadata will be added to the default error response payload:  - **datasetsWithJob** (*array*) - The list of datasets IDs that have at least one enabled job. - **errorType** (*string*) - (New in version v2.21) The type of error that happened, possible values include (but are not limited to): ``Generic Limit Reached``, ``Max Job Limit Reached for Dataset``, and ``Max Job Limit Reached for User``.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                dataset_refresh_job_create (DatasetRefreshJobCreate): [optional]
            Returns:
                DatasetRefreshJobResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/refreshJobs/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRefreshJobResponse(**server_data)

        @classmethod
        def datasets_refresh_jobs_delete(
            cls,
            dataset_id,
            job_id,
            **kwargs
        ):
            """Deletes an existing dataset refresh job

            Deletes an existing dataset refresh job.
            Args:
                dataset_id (str): The dataset associated with the scheduled refresh job.
                job_id (str): ID of the user scheduled dataset refresh job.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def datasets_refresh_jobs_execution_results_list(
            cls,
            dataset_id,
            job_id,
            **kwargs
        ):
            """Results of dataset refresh job.

            Paginated list of execution results for refresh job with the given ID and dataset with the given ID, sorted from newest to oldest.
            Args:
                dataset_id (str): The dataset associated with the scheduled refresh job.
                job_id (str): ID of the user scheduled dataset refresh job.

            Keyword Args:
                limit (int): Maximum number of results returned. The default may change and a maximum limit may be imposed without notice.. [optional] if omitted the server will use the default value of 20
                offset (int): Number of results that will be skipped.. [optional] if omitted the server will use the default value of 0
            Returns:
                DatasetRefreshJobRetrieveExecutionResultsResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/executionResults/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRefreshJobRetrieveExecutionResultsResponse(**server_data)

        @classmethod
        def datasets_refresh_jobs_list(
            cls,
            dataset_id,
            limit=100,
            offset=0,
            **kwargs
        ):
            """Information about scheduled jobs for given dataset.

            Paginated list of scheduled jobs descriptions for a specific dataset with given dataset ID, sorted by time of the last update.
            Args:
                dataset_id (str): The ID of the dataset.
                limit (int): Only this many items are returned.. defaults to 100, must be one of [100]
                offset (int): Skip this many items.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                DatasetRefreshJobsListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/refreshJobs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRefreshJobsListResponse(**server_data)

        @classmethod
        def datasets_refresh_jobs_patch(
            cls,
            dataset_id,
            job_id,
            **kwargs
        ):
            """Update a dataset refresh job

             Update a dataset refresh job.  Optionally if the limit of enabled jobs per user is reached the following metadata will be added to the default error response payload:  - **datasetsWithJob** (*array*) - The list of datasets IDs that have at least one enabled job. - **errorType** (*string*) - (New in version v2.21) The type of error that happened, possible values include (but are not limited to): ``Generic Limit Reached``, ``Max Job Limit Reached for Dataset``, and ``Max Job Limit Reached for User``.
            Args:
                dataset_id (str): The dataset associated with the scheduled refresh job.
                job_id (str): ID of the user scheduled dataset refresh job.

            Keyword Args:
                dataset_refresh_job_update (DatasetRefreshJobUpdate): [optional]
            Returns:
                DatasetRefreshJobResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRefreshJobResponse(**server_data)

        @classmethod
        def datasets_refresh_jobs_retrieve(
            cls,
            dataset_id,
            job_id,
            **kwargs
        ):
            """Gets configuration of a user scheduled dataset refresh job by job ID

            Gets configuration of a user scheduled dataset refresh job by job ID.
            Args:
                dataset_id (str): The dataset associated with the scheduled refresh job.
                job_id (str): ID of the user scheduled dataset refresh job.

            Keyword Args:
            Returns:
                DatasetRefreshJobResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/datasets/{datasetId}/refreshJobs/{jobId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRefreshJobResponse(**server_data)

        @classmethod
        def datasets_relationships_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset relationship.

            Create a dataset relationship.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                dataset_relationship_create (DatasetRelationshipCreate): [optional]
            Returns:
                DatasetRelationshipResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/relationships/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRelationshipResponse(**server_data)

        @classmethod
        def datasets_relationships_delete(
            cls,
            dataset_id,
            dataset_relationship_id,
            **kwargs
        ):
            """Delete dataset relationship.

            Delete a dataset relationship.
            Args:
                dataset_id (str): The ID of the dataset.
                dataset_relationship_id (str): The ID of the dataset relationship to delete.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_relationship_id'] = dataset_relationship_id
            path_args['datasetRelationshipId'] = dataset_relationship_id
            path = '/api/v2/datasets/{datasetId}/relationships/{datasetRelationshipId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def datasets_relationships_list(
            cls,
            dataset_id,
            limit=100,
            offset=0,
            **kwargs
        ):
            """List related datasets 

            Retrieve a list of the dataset relationships for a specific dataset.
            Args:
                dataset_id (str): The ID of the dataset.
                limit (int): At most this many results are returned.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]

            Keyword Args:
                linked_dataset_id (str): Providing `linkedDatasetId` will filter such that only relationships between `datasetId` (from the path) and `linkedDatasetId` will be returned.. [optional]
            Returns:
                DatasetRelationshipListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/relationships/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRelationshipListResponse(**server_data)

        @classmethod
        def datasets_relationships_patch(
            cls,
            dataset_id,
            dataset_relationship_id,
            **kwargs
        ):
            """Update dataset relationship.

            Update a dataset relationship.
            Args:
                dataset_id (str): The ID of the dataset.
                dataset_relationship_id (str): The ID of the dataset relationship to delete.

            Keyword Args:
                dataset_relationship_update (DatasetRelationshipUpdate): [optional]
            Returns:
                DatasetRelationshipResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_relationship_id'] = dataset_relationship_id
            path_args['datasetRelationshipId'] = dataset_relationship_id
            path = '/api/v2/datasets/{datasetId}/relationships/{datasetRelationshipId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetRelationshipResponse(**server_data)

        @classmethod
        def datasets_retrieve(
            cls,
            dataset_id,
            **kwargs
        ):
            """Get dataset details

            Retrieves the details of the dataset with given ID.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
            Returns:
                FullDatasetDetailsResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FullDatasetDetailsResponse(**server_data)

        @classmethod
        def datasets_shared_roles_list(
            cls,
            dataset_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List dataset shared roles

            Get a list of users, groups and organizations who have access to this dataset and their roles.
            Args:
                dataset_id (str): The ID of the dataset.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 100, must be one of [100]

            Keyword Args:
                id (str): Only return the access control information for a organization, group or user with this ID.. [optional]
                name (str): Only return the access control information for a organization, group or user with this name.. [optional]
                share_recipient_type (str): It describes the recipient type.. [optional]
            Returns:
                SharedRolesListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/sharedRoles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SharedRolesListResponse(**server_data)

        @classmethod
        def datasets_shared_roles_patch_many(
            cls,
            dataset_id,
            **kwargs
        ):
            """Modify dataset shared roles

            Grant access, remove access or update roles for organizations, groups or users on this dataset. Up to 100 roles may be set per array in a single request.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                dataset_shared_roles (DatasetSharedRoles): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/sharedRoles/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def datasets_versions_all_features_details_list(
            cls,
            dataset_id,
            dataset_version_id,
            limit=100,
            offset=0,
            order_by="name",
            **kwargs
        ):
            """Get dataset features

            Return detailed information on all the features and transforms for this dataset.If the Dataset Item has attribute snapshot = True, all optional fields also appear
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.
                limit (int): At most this many results are returned. The default may change and a maximum limit may be imposed without notice.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                order_by (str): How the features should be ordered.. defaults to "name", must be one of ["name"]

            Keyword Args:
            Returns:
                DatasetFeaturesListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['order_by'] = order_by
            path_args['orderBy'] = order_by
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/allFeaturesDetails/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeaturesListResponse(**server_data)

        @classmethod
        def datasets_versions_delete(
            cls,
            dataset_id,
            dataset_version_id,
            **kwargs
        ):
            """Delete dataset version

            Marks the dataset version with the given ID as deleted.
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def datasets_versions_deleted_patch_many(
            cls,
            dataset_id,
            dataset_version_id,
            **kwargs
        ):
            """Recover deleted dataset version

            Recover the dataset version item with given datasetId and datasetVersionId from `deleted`.
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.

            Keyword Args:
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/deleted/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def datasets_versions_feature_histograms_retrieve(
            cls,
            dataset_id,
            dataset_version_id,
            feature_name,
            bin_limit=60,
            **kwargs
        ):
            """Get dataset feature histogram

            Get histogram chart data for a specific feature in the specified dataset.
            Args:
                dataset_id (str): The ID of the dataset entry to retrieve.
                dataset_version_id (str): The ID of the dataset version to retrieve.
                feature_name (str): The name of the feature.
                bin_limit (int): Maximum number of bins in the returned plot.. defaults to 60, must be one of [60]

            Keyword Args:
                key (str): Only required for the Summarized categorical feature. Name of the top 50 key for which plot to be retrieved.. [optional]
            Returns:
                DatasetFeatureHistogramResponse
            """
            path_args = {}
            kwargs['bin_limit'] = bin_limit
            path_args['binLimit'] = bin_limit
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/featureHistograms/{featureName}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeatureHistogramResponse(**server_data)

        @classmethod
        def datasets_versions_featurelists_list(
            cls,
            dataset_id,
            dataset_version_id,
            limit=100,
            offset=0,
            order_by="name",
            **kwargs
        ):
            """Retrieve dataset featurelists

            Retrieves the featurelists of the dataset with given ID and the latest dataset version.
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.
                limit (int): At most this many results are returned. The default may change and a maximum limit may be imposed without notice.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                order_by (str): How the features should be ordered.. defaults to "name", must be one of ["name"]

            Keyword Args:
            Returns:
                DatasetFeaturelistListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['order_by'] = order_by
            path_args['orderBy'] = order_by
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/featurelists/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeaturelistListResponse(**server_data)

        @classmethod
        def datasets_versions_featurelists_retrieve(
            cls,
            dataset_id,
            dataset_version_id,
            featurelist_id,
            **kwargs
        ):
            """Get dataset featurelist

            Retrieves the specified featurelist of the dataset with given ID and the latest dataset version.
            Args:
                dataset_id (str): The ID of the dataset to retrieve featurelist for.
                dataset_version_id (str): The ID of the dataset version to retrieve featurelists for.
                featurelist_id (str): The ID of the featurelist.

            Keyword Args:
            Returns:
                DatasetFeaturelistResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/featurelists/{featurelistId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetFeaturelistResponse(**server_data)

        @classmethod
        def datasets_versions_file_list(
            cls,
            dataset_id,
            dataset_version_id,
            **kwargs
        ):
            """Retrieve original dataset data

            Retrieve all the originally uploaded data, in CSV form.
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.

            Keyword Args:
            Returns:
                str
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/file/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            return server_data

        @classmethod
        def datasets_versions_from_data_engine_workspace_state_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset version from Data Engine workspace

            Create a new dataset version for a specified dataset from a Data Engine workspace state. The new dataset version should have the same schema as the specified dataset.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                dataset_create_from_workspace_state (DatasetCreateFromWorkspaceState): [optional]
            Returns:
                CreatedDatasetDataEngineResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/versions/fromDataEngineWorkspaceState/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetDataEngineResponse(**server_data)

        @classmethod
        def datasets_versions_from_data_source_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset version from Data Source

            Create a new version for the specified dataset from specified Data Source. The dataset must have been created from a compatible data source originally.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                datasource (Datasource): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/versions/fromDataSource/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_versions_from_file_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset version from file

            Create a new version for the specified dataset from a file.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                dataset_from_file (DatasetFromFile): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/versions/fromFile/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_versions_from_hdfs_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset version from HDFS URL

            Create a new version for the specified dataset from a HDFS URL. The dataset must have been created from the same HDFS URL originally.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                hdfs (Hdfs): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/versions/fromHDFS/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_versions_from_latest_version_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset version from data source

            Create a new version of the specified dataset from the latest dataset version. This will reuse the same source of the data that was previously used. Not supported for datasets that were previously loaded from an uploaded file. If the dataset is currently a remote dataset, it will be converted to a snapshot dataset. NOTE:  if the current version uses a Data Source, the `user` and `password` must be specified so the data can be accessed.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                from_latest (FromLatest): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/versions/fromLatestVersion/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_versions_from_url_create(
            cls,
            dataset_id,
            **kwargs
        ):
            """Create dataset version from URL

            Create a new version for the specified dataset from specified URL. The dataset must have been created from the same URL originally.
            Args:
                dataset_id (str): The ID of the dataset.

            Keyword Args:
                url (Url): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/versions/fromURL/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_versions_from_version_create(
            cls,
            dataset_id,
            dataset_version_id,
            **kwargs
        ):
            """Create dataset version from previous version

            Create a new version of the specified dataset from the specified dataset version. This will reuse the same source of the data that was previously used. Not supported for datasets that were previously loaded from an uploaded file. If the dataset is currently a remote dataset, it will be converted to a snapshot dataset. NOTE: If the specified version uses a Data Source, the `user` and `password` must be specified so the data can be accessed.
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.

            Keyword Args:
                from_specific (FromSpecific): [optional]
            Returns:
                CreatedDatasetResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/fromVersion/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatedDatasetResponse(**server_data)

        @classmethod
        def datasets_versions_list(
            cls,
            dataset_id,
            limit=100,
            offset=0,
            **kwargs
        ):
            """List dataset versions

            List all versions associated with given datasetId and which match the specified query parameters.
            Args:
                dataset_id (str): The ID of the dataset.
                limit (int): At most this many results are returned.. defaults to 100, must be one of [100]
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]

            Keyword Args:
                category (str): If specified, only dataset versions that have the specified category will be included in the results. Categories identify the intended use of the dataset.. [optional]
                order_by (str): Sorting order which will be applied to catalog list.. [optional]
                filter_failed (str): Whether datasets that failed during import should be excluded from the results. If True invalid datasets will be excluded.. [optional] if omitted the server will use the default value of "false"
            Returns:
                DatasetListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/versions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatasetListResponse(**server_data)

        @classmethod
        def datasets_versions_projects_list(
            cls,
            dataset_id,
            dataset_version_id,
            limit=100,
            offset=0,
            **kwargs
        ):
            """Get dataset projects by version

            Retrieves a dataset's projects for the specified catalog dataset and dataset version id.
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.
                limit (int): Only this many items are returned.. defaults to 100, must be one of [100]
                offset (int): Skip this many items.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                GetDatasetVersionProjectsResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/projects/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return GetDatasetVersionProjectsResponse(**server_data)

        @classmethod
        def datasets_versions_retrieve(
            cls,
            dataset_id,
            dataset_version_id,
            **kwargs
        ):
            """Get dataset details by version

            Retrieves the details of the dataset with given ID and version ID.
            Args:
                dataset_id (str): The ID of the dataset entry.
                dataset_version_id (str): The ID of the dataset version.

            Keyword Args:
            Returns:
                FullDatasetDetailsResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            kwargs['dataset_version_id'] = dataset_version_id
            path_args['datasetVersionId'] = dataset_version_id
            path = '/api/v2/datasets/{datasetId}/versions/{datasetVersionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FullDatasetDetailsResponse(**server_data)

